/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.dailog.ResourceTypeParameterDialog;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.dailog.ResourceTypeParameterNameValidator;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.dailog.ResourceTypeParameterValueValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParametersCompositeContainer {
    AbstractFormPart formPart;
    Composite parametersComposite;
    Table parameterTable;
    TableColumn nameColumn;
    TableColumn valueColumn;
    Composite buttonComposite;
    Button addButton;
    Button removeButton;
    Button editButton;
    private Map<String, String> parameters;
    private boolean isEditable = true;
    private IEditorPart editorPart;

    public ParametersCompositeContainer(IEditorPart parentPart, AbstractFormPart formPart, FormToolkit toolkit, Composite parametersComposite) {
        this.editorPart = parentPart;
        this.formPart = formPart;
        this.parametersComposite = parametersComposite;
        this.initialize(toolkit, parametersComposite);
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        int itemCount = this.parameterTable.getItemCount();
        int index = 0;
        while (index < itemCount) {
            TableItem tableItem = this.parameterTable.getItem(index);
            String name = tableItem.getText(0);
            String value = tableItem.getText(1);
            parameters.put(name, value);
            ++index;
        }
        return parameters;
    }

    public void setEnabled(boolean enable) {
        this.parameterTable.setEnabled(enable);
        this.addButton.setEnabled(enable);
        this.removeButton.setEnabled(enable);
        this.editButton.setEnabled(enable);
        if (enable) {
            this.setWidgetPermissions();
        }
    }

    private void initialize(FormToolkit toolkit, Composite parent) {
        this.initializeTable(toolkit, parent);
        this.buttonComposite = toolkit.createComposite(parent);
        toolkit.paintBordersFor(this.buttonComposite);
        this.addButton = toolkit.createButton(this.buttonComposite, "Add...", 8);
        this.editButton = toolkit.createButton(this.buttonComposite, "Edit...", 8);
        this.removeButton = toolkit.createButton(this.buttonComposite, "Remove", 8);
        this.addButton.addSelectionListener((SelectionListener)new ButtonSelectionListener());
        this.editButton.addSelectionListener((SelectionListener)new ButtonSelectionListener());
        this.removeButton.addSelectionListener((SelectionListener)new ButtonSelectionListener());
        this.initializeLayouts(parent);
        this.updateButtonStatus();
    }

    protected void initializeTable(FormToolkit toolkit, Composite parent) {
        this.parameterTable = toolkit.createTable(parent, 65540);
        this.nameColumn = new TableColumn(this.parameterTable, 16384, 0);
        this.nameColumn.setText("Parameter Name");
        this.nameColumn.setToolTipText("Parameter Name");
        this.nameColumn.setResizable(false);
        this.nameColumn.setMoveable(false);
        this.nameColumn.setWidth(130);
        this.valueColumn = new TableColumn(this.parameterTable, 16384, 1);
        this.valueColumn.setText("Parameter Value");
        this.valueColumn.setToolTipText("Parameter Value");
        this.valueColumn.setResizable(false);
        this.valueColumn.setMoveable(false);
        this.valueColumn.setWidth(200);
        this.parameterTable.setHeaderVisible(true);
        this.parameterTable.setSortColumn(this.nameColumn);
        this.parameterTable.setSortDirection(1024);
        this.parameterTable.setTopIndex(0);
        this.parameterTable.setLinesVisible(true);
        this.parameterTable.addSelectionListener((SelectionListener)new TableSelectionListener());
    }

    protected void initializeLayouts(Composite parent) {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.heightHint = 85;
        this.parameterTable.setLayoutData((Object)gridData);
        gridData = new GridData(1, 1, false, true);
        this.buttonComposite.setLayoutData((Object)gridData);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.fill = true;
        rowLayout.pack = false;
        rowLayout.marginBottom = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginRight = 2;
        rowLayout.marginLeft = 2;
        rowLayout.spacing = 5;
        this.buttonComposite.setLayout((Layout)rowLayout);
        this.addButton.setLayoutData((Object)new RowData());
        this.editButton.setLayoutData((Object)new RowData());
        this.removeButton.setLayoutData((Object)new RowData());
    }

    public void setInput(Map<String, String> parameters, boolean isEditable) {
        this.parameters = parameters;
        this.isEditable = isEditable;
        this.populateData();
        this.setWidgetPermissions();
    }

    protected void populateData() {
        this.parameterTable.setRedraw(false);
        try {
            this.parameterTable.removeAll();
            if (this.parameters != null) {
                ArrayList parameterNames = new ArrayList(this.parameters.keySet());
                Collections.sort(parameterNames, new ParameterNameComparator());
                for (String parameterName : parameterNames) {
                    String parameterValue = this.parameters.get(parameterName);
                    parameterName = parameterName != null ? parameterName.trim() : "";
                    parameterValue = parameterValue != null ? parameterValue : "";
                    TableItem tableItem = new TableItem(this.parameterTable, 0);
                    tableItem.setText(new String[]{parameterName, parameterValue});
                }
            }
        }
        finally {
            this.parameterTable.setRedraw(true);
        }
    }

    protected void setWidgetPermissions() {
        this.addButton.setEnabled(this.isEditable);
        this.editButton.setEnabled(this.isEditable);
        this.removeButton.setEnabled(this.isEditable);
        this.updateButtonStatus();
    }

    protected void updateButtonStatus() {
        if (!this.isEditable) {
            return;
        }
        boolean isItemSelected = this.parameterTable.getSelectionIndex() != -1;
        this.editButton.setEnabled(isItemSelected);
        this.removeButton.setEnabled(isItemSelected);
    }

    protected void addParameter() {
        ResourceTypeParameterDialog dialog = this.createParameterDialog(null, null);
        if (dialog.open() == 0) {
            String name = dialog.getParameterName();
            String value = dialog.getParameterValue();
            this.insertParameterInTable(name, value);
            this.markFormPartDirty();
        }
    }

    protected void editParameter() {
        String value;
        TableItem tableItem;
        String name;
        ResourceTypeParameterDialog dialog;
        int selectionIndex = this.parameterTable.getSelectionIndex();
        if (selectionIndex != -1 && (dialog = this.createParameterDialog(name = (tableItem = this.parameterTable.getItem(selectionIndex)).getText(0), value = tableItem.getText(1))).open() == 0) {
            String newName = dialog.getParameterName();
            String newValue = dialog.getParameterValue();
            if (name.equals(newName) && value.equals(newValue)) {
                return;
            }
            if (name.equals(newName)) {
                tableItem.setText(1, newValue);
            } else {
                this.parameterTable.remove(selectionIndex);
                this.insertParameterInTable(newName, newValue);
            }
            this.markFormPartDirty();
        }
    }

    protected void removeParameter() {
        int selectionIndex = this.parameterTable.getSelectionIndex();
        if (selectionIndex != -1) {
            this.parameterTable.remove(selectionIndex);
            int itemCount = this.parameterTable.getItemCount();
            if (selectionIndex >= itemCount) {
                selectionIndex = itemCount - 1;
            }
            this.parameterTable.select(selectionIndex);
            this.updateButtonStatus();
            this.markFormPartDirty();
        }
    }

    private ResourceTypeParameterDialog createParameterDialog(String name, String value) {
        ResourceTypeParameterDialog dialog = null;
        Shell shell = this.parametersComposite.getShell();
        String pluginId = this.editorPart.getSite().getPluginId();
        dialog = new ResourceTypeParameterDialog(shell, pluginId, name, value);
        Set<String> names = this.getParameterNames();
        dialog.setParameterNameValidator(new ResourceTypeParameterNameValidator(names, name));
        dialog.setParameterValueValidator(new ResourceTypeParameterValueValidator());
        return dialog;
    }

    private Set<String> getParameterNames() {
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < this.parameterTable.getItemCount()) {
            names.add(this.parameterTable.getItem(i).getText(0));
            ++i;
        }
        return names;
    }

    private void insertParameterInTable(String name, String value) {
        int index = this.parameterTable.getItemCount();
        int i = 0;
        while (i < this.parameterTable.getItemCount()) {
            String currentName = this.parameterTable.getItem(i).getText(0);
            if (currentName.compareToIgnoreCase(name) > 0 || currentName.compareToIgnoreCase(name) == 0 && currentName.compareTo(name) > 0) {
                index = i;
                break;
            }
            ++i;
        }
        TableItem tableItem = new TableItem(this.parameterTable, 0, index);
        tableItem.setText(new String[]{name, value});
        this.parameterTable.select(index);
        this.updateButtonStatus();
    }

    private void markFormPartDirty() {
        if (this.formPart != null && !this.formPart.isDirty()) {
            this.formPart.markDirty();
        }
    }

    private class ButtonSelectionListener
    extends SelectionAdapter {
        private ButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.getSource() == ParametersCompositeContainer.this.addButton) {
                ParametersCompositeContainer.this.addParameter();
            } else if (event.getSource() == ParametersCompositeContainer.this.editButton) {
                ParametersCompositeContainer.this.editParameter();
            } else if (event.getSource() == ParametersCompositeContainer.this.removeButton) {
                ParametersCompositeContainer.this.removeParameter();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterNameComparator
    implements Comparator<String> {
        private ParameterNameComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int n1 = s1.length();
            int n2 = s2.length();
            int i1 = 0;
            int i2 = 0;
            while (i1 < n1 && i2 < n2) {
                char c2;
                char c1 = s1.charAt(i1);
                if (c1 != (c2 = s2.charAt(i2)) && (c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                    return c1 - c2;
                }
                ++i1;
                ++i2;
            }
            int lengthDiff = n1 - n2;
            if (lengthDiff == 0) {
                return s1.compareTo(s2);
            }
            return lengthDiff;
        }
    }

    private class TableSelectionListener
    extends SelectionAdapter {
        private TableSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            ParametersCompositeContainer.this.updateButtonStatus();
        }

        public void widgetSelected(SelectionEvent e) {
            ParametersCompositeContainer.this.updateButtonStatus();
        }
    }
}

