/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import com.tandbergtv.watchpoint.studio.dto.ConnectionType;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditorInput;
import com.tandbergtv.watchpoint.studio.ui.model.IEditableElement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ResourceTypeSectionPart
extends SectionPart {
    private static final Logger logger = Logger.getLogger(ResourceTypeSectionPart.class);
    protected Composite sectionClient;
    protected IAdaptable input;
    protected boolean allowMarkDirty = false;
    protected IEditorPart editorPart;

    public ResourceTypeSectionPart(IEditorPart parentPart, Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style);
        this.editorPart = parentPart;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.createSectionControls(form);
        this.initializeSectionLayout(form);
        this.allowMarkDirty = true;
    }

    public void refresh() {
        super.refresh();
        this.allowMarkDirty = false;
        this.populateSectionData();
        this.setWidgetPermissions();
        this.allowMarkDirty = true;
    }

    public void markDirty() {
        if (this.allowMarkDirty) {
            super.markDirty();
        }
    }

    public boolean setFormInput(Object input) {
        if (input instanceof ResourceTypeEditorInput) {
            this.input = (ResourceTypeEditorInput)input;
            this.markStale();
            return true;
        }
        return false;
    }

    protected void createSectionControls(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = this.getSection();
        this.sectionClient = toolkit.createComposite((Composite)section, 64);
        toolkit.paintBordersFor(this.sectionClient);
        section.setClient((Control)this.sectionClient);
        this.createSectionClientControls(managedForm);
    }

    protected abstract void createSectionClientControls(IManagedForm var1);

    protected void initializeSectionLayout(IManagedForm managedForm) {
        this.sectionClient.setLayoutData((Object)this.createGridData());
        this.initializeSectionClientLayout(managedForm);
    }

    protected abstract void initializeSectionClientLayout(IManagedForm var1);

    protected GridLayout createGridLayout(int columnCount, boolean makeColumnsEqualWidth) {
        GridLayout layout = new GridLayout(columnCount, makeColumnsEqualWidth);
        layout.marginRight = 2;
        layout.marginLeft = 2;
        layout.marginBottom = 2;
        layout.marginTop = 2;
        return layout;
    }

    protected GridData createGridData() {
        return new GridData(1, 1, false, false);
    }

    protected GridData createLabelGridData() {
        GridData data = new GridData(1, 1, false, false);
        data.verticalIndent = 2;
        return data;
    }

    protected abstract void populateSectionData();

    protected abstract void setWidgetPermissions();

    protected ResourceType getResourceType() {
        return this.input != null ? (ResourceType)this.input.getAdapter(ResourceType.class) : null;
    }

    protected Message getMessage() {
        return this.input != null ? (Message)this.input.getAdapter(Message.class) : null;
    }

    protected boolean isInputEditable() {
        IEditableElement editableElement;
        boolean isEditable = true;
        if (this.input != null && (editableElement = (IEditableElement)this.input.getAdapter(IEditableElement.class)) != null) {
            isEditable = editableElement.canEdit();
        }
        return isEditable;
    }

    protected int getDefaultClassNameTextWidth() {
        return 380;
    }

    protected String formatValue(String value, boolean trim) {
        String newValue = null;
        newValue = value == null ? "" : (trim ? value.trim() : value);
        return newValue;
    }

    protected List<ConnectionType> getAvailableConnectionTypes() {
        List<ConnectionType> connectionTypeList = null;
        try {
            ServiceFactory serviceFactory = ServiceFactory.createFactory();
            IResourceTypeService service = serviceFactory.createResourceTypeService();
            connectionTypeList = service.getAllConnectionTypes();
            if (connectionTypeList == null) {
                connectionTypeList = new ArrayList<ConnectionType>();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to get the list of available Connection Types.", (Throwable)ex);
        }
        return connectionTypeList;
    }
}

