/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.model;

import com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement;
import com.tandbergtv.watchpoint.studio.ui.model.IResourceGroupElement;
import com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.ActionElement;
import org.jbpm.gd.jpdl.model.CancelTimer;
import org.jbpm.gd.jpdl.model.CreateTimer;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.Script;
import org.jbpm.gd.jpdl.model.TaskNode;

public class AbstractTaskNode
extends TaskNode
implements IResourceGroupElement,
IDueDateElement {
    private static final String NODE_ENTER_EVENT = "node-enter";
    private static final String NODE_LEAVE_EVENT = "node-leave";
    ResourceGroup resourceGroup;
    ActionElement actionElement;

    public void setResourceGroup(ResourceGroup newResourceGroup) {
        ResourceGroup oldResourceGroup = this.resourceGroup;
        this.resourceGroup = newResourceGroup;
        this.firePropertyChange("resourceGroupAdd", (Object)oldResourceGroup, (Object)newResourceGroup);
    }

    public ResourceGroup getResourceGroup() {
        return this.resourceGroup;
    }

    public void setScript(Script newActionElement) {
        ActionElement oldActionElement = this.actionElement;
        this.actionElement = newActionElement;
        this.firePropertyChange("script", oldActionElement, newActionElement);
    }

    public Script getScript() {
        if (this.actionElement instanceof Script) {
            return (Script)this.actionElement;
        }
        return null;
    }

    public String getDueDate() {
        CreateTimer createTimer = null;
        Event[] eventArray = this.getEvents();
        int n = eventArray.length;
        int n2 = 0;
        while (n2 < n) {
            Event event = eventArray[n2];
            if (event.getType().equals(NODE_ENTER_EVENT)) {
                ActionElement[] actionElementArray = event.getActionElements();
                int n3 = actionElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ActionElement action = actionElementArray[n4];
                    if (action instanceof CreateTimer) {
                        createTimer = (CreateTimer)action;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (createTimer == null) {
            return null;
        }
        return createTimer.getDueDate();
    }

    public void setDueDate(String newDueDate) {
        if (newDueDate == null) {
            this.removeTimerEvents();
            return;
        }
        CreateTimer createTimer = this.getNodeEnterCreateTimer();
        if (createTimer == null) {
            return;
        }
        createTimer.setDueDate(newDueDate);
    }

    public void setAction(Action newActionElement) {
        ActionElement oldActionElement = this.actionElement;
        this.actionElement = newActionElement;
        this.firePropertyChange("action", oldActionElement, newActionElement);
    }

    public Action getAction() {
        if (this.actionElement instanceof Action) {
            return (Action)this.actionElement;
        }
        return null;
    }

    public void setCreateTimer(CreateTimer newActionElement) {
        ActionElement oldActionElement = this.actionElement;
        this.actionElement = newActionElement;
        this.firePropertyChange("createTimer", oldActionElement, newActionElement);
    }

    public CreateTimer getCreateTimer() {
        if (this.actionElement instanceof CreateTimer) {
            return (CreateTimer)this.actionElement;
        }
        return null;
    }

    public void setCancelTimer(CancelTimer newActionElement) {
        ActionElement oldActionElement = this.actionElement;
        this.actionElement = newActionElement;
        this.firePropertyChange("cancelTimer", oldActionElement, newActionElement);
    }

    public CancelTimer getCancelTimer() {
        if (this.actionElement instanceof CancelTimer) {
            return (CancelTimer)this.actionElement;
        }
        return null;
    }

    private void removeTimerEvents() {
        Event[] eventArray = this.getEvents();
        int n = eventArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionElement action;
            int n3;
            int n4;
            ActionElement[] actionElementArray;
            Event event = eventArray[n2];
            if (event.getType().equals(NODE_ENTER_EVENT)) {
                actionElementArray = event.getActionElements();
                n4 = actionElementArray.length;
                n3 = 0;
                while (n3 < n4) {
                    action = actionElementArray[n3];
                    if (action instanceof CreateTimer) {
                        event.removeActionElement(action);
                    }
                    ++n3;
                }
                if (event.getActionElements().length == 0) {
                    this.removeEvent(event);
                }
            }
            if (event.getType().equals(NODE_LEAVE_EVENT)) {
                actionElementArray = event.getActionElements();
                n4 = actionElementArray.length;
                n3 = 0;
                while (n3 < n4) {
                    action = actionElementArray[n3];
                    if (action instanceof Action && ((Action)action).getRefName() != null && ((Action)action).getRefName().equals("timer-delete")) {
                        event.removeActionElement(action);
                    }
                    ++n3;
                }
                if (event.getActionElements().length == 0) {
                    this.removeEvent(event);
                }
            }
            ++n2;
        }
    }

    private CreateTimer getNodeEnterCreateTimer() {
        Event nodeEnterEvent = this.AddTimerActionToEvent(NODE_ENTER_EVENT, "timer-fire");
        this.AddTimerActionToEvent(NODE_LEAVE_EVENT, "timer-delete");
        ActionElement[] actionElementArray = nodeEnterEvent.getActionElements();
        int n = actionElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionElement action = actionElementArray[n2];
            if (action instanceof CreateTimer) {
                return (CreateTimer)action;
            }
            ++n2;
        }
        return null;
    }

    private Event AddTimerActionToEvent(String eventName, String timerAction) {
        boolean newEvent = false;
        Event nodeEvent = null;
        Event[] eventArray = this.getEvents();
        int n = eventArray.length;
        int n2 = 0;
        while (n2 < n) {
            Event event = eventArray[n2];
            if (event.getType().equals(eventName)) {
                nodeEvent = event;
            }
            ++n2;
        }
        if (nodeEvent == null) {
            nodeEvent = (Event)this.getFactory().createById("org.jbpm.gd.jpdl.event");
            this.addEvent(nodeEvent);
            nodeEvent.setType(eventName);
            newEvent = true;
        }
        Action action = null;
        if (eventName.equals(NODE_ENTER_EVENT)) {
            CreateTimer createTimer = null;
            if (!newEvent) {
                ActionElement[] actionElementArray = nodeEvent.getActionElements();
                int n3 = actionElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ActionElement actionElement = actionElementArray[n4];
                    if (actionElement instanceof CreateTimer) {
                        createTimer = (CreateTimer)actionElement;
                    }
                    ++n4;
                }
            }
            if (createTimer == null) {
                createTimer = (CreateTimer)this.getFactory().createById("org.jbpm.gd.jpdl.createTimer");
                nodeEvent.addActionElement((ActionElement)createTimer);
            }
            if ((action = createTimer.getAction()) == null) {
                action = (Action)this.getFactory().createById("org.jbpm.gd.jpdl.action");
                createTimer.setAction(action);
            }
        } else if (eventName.equals(NODE_LEAVE_EVENT)) {
            ActionElement[] actionElementArray = nodeEvent.getActionElements();
            int n5 = actionElementArray.length;
            n = 0;
            while (n < n5) {
                ActionElement actionElement = actionElementArray[n];
                if (actionElement instanceof Action && ((Action)actionElement).getRefName() != null && ((Action)actionElement).getRefName().equals(timerAction)) {
                    action = (Action)actionElement;
                }
                ++n;
            }
            if (action == null) {
                action = (Action)this.getFactory().createById("org.jbpm.gd.jpdl.action");
                nodeEvent.addActionElement((ActionElement)action);
            }
        }
        action.setRefName(timerAction);
        return nodeEvent;
    }
}

