/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.model;

import com.tandbergtv.watchpoint.studio.application.ApplicationProperties;
import com.tandbergtv.watchpoint.studio.ui.model.AbstractTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.IDurationElement;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageContainer;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomaticTaskNode
extends AbstractTaskNode
implements IMessageContainer,
IDurationElement {
    private static final String VALUE_ELEMENT_NAME = "value";
    private static final String KEY_ELEMENT_NAME = "key";
    private static final String KEYS_ELEMENT_NAME = "keys";
    private static final String ENTRY_ELEMENT_NAME = "entry";
    private static final String MAP_ELEMENT_NAME = "map";
    private Map<String, String> keys = null;
    private String duration;
    private String taskDuration;

    @Override
    public String getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(String newDuration) {
        String oldDuration = this.duration;
        this.duration = newDuration;
        this.firePropertyChange("duration", oldDuration, newDuration);
    }

    @Override
    public String getTaskDuration() {
        return this.taskDuration;
    }

    @Override
    public void setTaskDuration(String newTaskDuration) {
        String oldTaskDuration = this.taskDuration;
        this.taskDuration = newTaskDuration;
        this.firePropertyChange("taskDuration", oldTaskDuration, newTaskDuration);
    }

    @Override
    public String getUid() {
        Action action = this.getAction();
        if (action == null) {
            return null;
        }
        GenericElement sendElement = null;
        GenericElement[] genericElementArray = action.getGenericElements();
        int n = genericElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericElement element = genericElementArray[n2];
            if (element.getName().equals("send") || element.getName().equals("receive")) {
                sendElement = element;
                break;
            }
            ++n2;
        }
        if (sendElement == null) {
            return "";
        }
        return sendElement.getValue();
    }

    @Override
    public void setUid(String uid) {
        if (this.getAction() == null) {
            this.setAction(this.createAction());
        }
        String elementName = this.isOutgoingMessage(uid) ? "send" : "receive";
        String elementToRemove = this.isOutgoingMessage(uid) ? "receive" : "send";
        Action action = this.getAction();
        GenericElement sendElement = null;
        GenericElement[] genericElementArray = action.getGenericElements();
        int n = genericElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericElement element = genericElementArray[n2];
            if (element.getName().equals(elementName)) {
                sendElement = element;
            } else if (element.getName().equals(elementToRemove)) {
                action.removeGenericElement(element);
            }
            ++n2;
        }
        if (sendElement == null) {
            sendElement = this.createWPConfigInfoElement();
            sendElement.setName(elementName);
            action.addGenericElement(sendElement);
        }
        sendElement.setValue(uid);
        this.getAction().setClassName(this.getHandler());
    }

    @Override
    public List<WPVariable> getIncomingVariables() {
        ArrayList<WPVariable> incomingVars = new ArrayList<WPVariable>();
        if (this.getTasks().length == 0) {
            return incomingVars;
        }
        Task task = this.getTasks()[0];
        int i = 0;
        while (i < task.getController().getVariables().length) {
            WPVariable var = (WPVariable)task.getController().getVariables()[i];
            if (var.isWritable()) {
                incomingVars.add(var);
            }
            ++i;
        }
        return incomingVars;
    }

    @Override
    public List<WPVariable> getOutgoingVariables() {
        ArrayList<WPVariable> outgoingVars = new ArrayList<WPVariable>();
        if (this.getTasks().length == 0) {
            return outgoingVars;
        }
        Task task = this.getTasks()[0];
        int i = 0;
        while (i < task.getController().getVariables().length) {
            WPVariable var = (WPVariable)task.getController().getVariables()[i];
            if (var.isReadable()) {
                outgoingVars.add(var);
            }
            ++i;
        }
        return outgoingVars;
    }

    @Override
    public void addVariable(WPVariable variable) {
        if (this.getTasks().length == 0) {
            this.addTask(this.createTask());
        }
        this.getTasks()[0].getController().addVariable((Variable)variable);
    }

    @Override
    public WPVariable removeVariable(String varName) {
        if (this.getTasks().length == 0) {
            return null;
        }
        Task task = this.getTasks()[0];
        int i = 0;
        while (i < task.getController().getVariables().length) {
            WPVariable var = (WPVariable)task.getController().getVariables()[i];
            if (var.getMappedName().equals(varName)) {
                task.getController().removeVariable((Variable)var);
                if (task.getController().getVariables().length == 0) {
                    this.removeTask(task);
                }
                return var;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setConstantValue(String varName, String val) {
        if (this.getAction() == null) {
            this.setAction(this.createAction());
        }
        this.setVariableValue(varName, val, MAP_ELEMENT_NAME);
    }

    @Override
    public String getConstantValue(String varName) {
        if (this.getAction() == null) {
            return null;
        }
        return this.getVariableValue(varName, MAP_ELEMENT_NAME);
    }

    @Override
    public Map<String, String> getConstants() {
        return this.getVariables(MAP_ELEMENT_NAME);
    }

    @Override
    public String getCompositeKey(String varName) {
        if (this.getAction() == null) {
            return "";
        }
        return this.getVariableValue(varName, KEYS_ELEMENT_NAME);
    }

    @Override
    public Map<String, String> getCompositeKeys() {
        if (this.keys != null) {
            return this.keys;
        }
        return this.getVariables(KEYS_ELEMENT_NAME);
    }

    @Override
    public void setCompositeKey(String varName, String val) {
        if (this.getAction() == null) {
            this.setAction(this.createAction());
        }
        this.setVariableValue(varName, val, KEYS_ELEMENT_NAME);
    }

    @Override
    public boolean hasAttachment() {
        for (WPVariable var : this.getOutgoingVariables()) {
            if (!var.isAttachment()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateActionHandler() {
        if (this.getAction() == null) {
            this.setAction(this.createAction());
        }
        this.getAction().setClassName(this.getHandler());
    }

    private Map<String, String> getVariables(String elementName) {
        HashMap<String, String> variables;
        block7: {
            GenericElement entryElement;
            int n;
            int n2;
            GenericElement[] genericElementArray;
            GenericElement entryContainerElement;
            block6: {
                Action action = this.getAction();
                variables = new HashMap<String, String>();
                entryContainerElement = null;
                if (action == null || action.getGenericElements() == null) {
                    return variables;
                }
                genericElementArray = action.getGenericElements();
                n2 = genericElementArray.length;
                n = 0;
                while (n < n2) {
                    GenericElement element = genericElementArray[n];
                    if (element.getName().equals(elementName)) {
                        entryContainerElement = element;
                        break;
                    }
                    ++n;
                }
                if (entryContainerElement == null) {
                    return variables;
                }
                if (!MAP_ELEMENT_NAME.equals(elementName)) break block6;
                genericElementArray = entryContainerElement.getGenericElements();
                n2 = genericElementArray.length;
                n = 0;
                while (n < n2) {
                    entryElement = genericElementArray[n];
                    variables.put(this.getElementProperty(entryElement, KEY_ELEMENT_NAME), this.getElementProperty(entryElement, VALUE_ELEMENT_NAME));
                    ++n;
                }
                break block7;
            }
            if (!KEYS_ELEMENT_NAME.equals(elementName)) break block7;
            genericElementArray = entryContainerElement.getGenericElements();
            n2 = genericElementArray.length;
            n = 0;
            while (n < n2) {
                entryElement = genericElementArray[n];
                variables.put(this.getElementProperty(entryElement, VALUE_ELEMENT_NAME), this.getElementProperty(entryElement, KEY_ELEMENT_NAME));
                ++n;
            }
        }
        return variables;
    }

    private void setVariableValue(String varName, String val, String elementName) {
        int n;
        Action action = this.getAction();
        GenericElement entryContainerElement = null;
        if (action != null && action.getGenericElements() != null) {
            GenericElement[] genericElementArray = action.getGenericElements();
            n = genericElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericElement element = genericElementArray[n2];
                if (element.getName().equals(elementName)) {
                    entryContainerElement = element;
                    break;
                }
                ++n2;
            }
        }
        if (entryContainerElement == null) {
            entryContainerElement = this.createWPConfigInfoElement();
            entryContainerElement.setName(elementName);
            action.addGenericElement(entryContainerElement);
        }
        GenericElement entryElement = null;
        GenericElement[] genericElementArray = entryContainerElement.getGenericElements();
        int n3 = genericElementArray.length;
        n = 0;
        while (n < n3) {
            GenericElement element = genericElementArray[n];
            if (element.getName().equals(ENTRY_ELEMENT_NAME) && (MAP_ELEMENT_NAME.equals(elementName) && varName.equals(this.getElementProperty(element, KEY_ELEMENT_NAME)) || KEYS_ELEMENT_NAME.equals(elementName) && varName.equals(this.getElementProperty(element, VALUE_ELEMENT_NAME)))) {
                entryElement = element;
                break;
            }
            ++n;
        }
        if (val == null) {
            if (entryElement != null) {
                entryContainerElement.removeGenericElement(entryElement);
            }
            if (entryContainerElement.getGenericElements() == null || entryContainerElement.getGenericElements().length == 0) {
                action.removeGenericElement(entryContainerElement);
            }
            return;
        }
        if (entryElement == null) {
            entryElement = this.createWPConfigInfoElement();
            entryElement.setName(ENTRY_ELEMENT_NAME);
            entryContainerElement.addGenericElement(entryElement);
        }
        if (MAP_ELEMENT_NAME.equals(elementName)) {
            this.setEntryElementValue(entryElement, varName, val);
        } else if (KEYS_ELEMENT_NAME.equals(elementName)) {
            this.setEntryElementValue(entryElement, val, varName);
        }
    }

    private String getVariableValue(String varName, String elementName) {
        int n;
        int n2;
        GenericElement[] genericElementArray;
        Action action = this.getAction();
        GenericElement entryContainerElement = null;
        if (action != null && action.getGenericElements() != null) {
            genericElementArray = action.getGenericElements();
            n2 = genericElementArray.length;
            n = 0;
            while (n < n2) {
                GenericElement element = genericElementArray[n];
                if (element.getName().equals(elementName)) {
                    entryContainerElement = element;
                    break;
                }
                ++n;
            }
        }
        if (entryContainerElement == null) {
            return null;
        }
        genericElementArray = entryContainerElement.getGenericElements();
        n2 = genericElementArray.length;
        n = 0;
        while (n < n2) {
            GenericElement entryElement = genericElementArray[n];
            if (entryElement.getName().equals(ENTRY_ELEMENT_NAME)) {
                if (MAP_ELEMENT_NAME.equals(elementName) && varName.equals(this.getElementProperty(entryElement, KEY_ELEMENT_NAME))) {
                    GenericElement[] genericElementArray2 = entryElement.getGenericElements();
                    int n3 = genericElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        GenericElement element = genericElementArray2[n4];
                        if (element.getName().equals(VALUE_ELEMENT_NAME)) {
                            return element.getValue();
                        }
                        ++n4;
                    }
                    break;
                }
                if (KEYS_ELEMENT_NAME.equals(elementName) && varName.equals(this.getElementProperty(entryElement, VALUE_ELEMENT_NAME))) {
                    GenericElement[] genericElementArray3 = entryElement.getGenericElements();
                    int n5 = genericElementArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        GenericElement element = genericElementArray3[n6];
                        if (element.getName().equals(KEY_ELEMENT_NAME)) {
                            return element.getValue();
                        }
                        ++n6;
                    }
                    break;
                }
            }
            ++n;
        }
        return null;
    }

    private void setEntryElementValue(GenericElement entryElement, String varName, String val) {
        GenericElement keyElement = null;
        GenericElement valueElement = null;
        GenericElement[] genericElementArray = entryElement.getGenericElements();
        int n = genericElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericElement element = genericElementArray[n2];
            if (element.getName().equals(KEY_ELEMENT_NAME)) {
                keyElement = element;
            } else if (element.getName().equals(VALUE_ELEMENT_NAME)) {
                valueElement = element;
            }
            if (keyElement != null && valueElement != null) break;
            ++n2;
        }
        if (keyElement == null) {
            keyElement = this.createWPConfigInfoElement();
            keyElement.setName(KEY_ELEMENT_NAME);
            entryElement.addGenericElement(keyElement);
        }
        if (keyElement.getValue() == null || !keyElement.getValue().equals(varName)) {
            keyElement.setValue(varName);
        }
        if (valueElement == null) {
            valueElement = this.createWPConfigInfoElement();
            valueElement.setName(VALUE_ELEMENT_NAME);
            entryElement.addGenericElement(valueElement);
        }
        valueElement.setValue(val);
    }

    private String getElementProperty(GenericElement element, String property) {
        GenericElement keyElement = null;
        GenericElement[] genericElementArray = element.getGenericElements();
        int n = genericElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericElement subElement = genericElementArray[n2];
            if (subElement.getName().equals(property)) {
                keyElement = subElement;
                break;
            }
            ++n2;
        }
        if (keyElement == null) {
            return null;
        }
        return keyElement.getValue();
    }

    private GenericElement createWPConfigInfoElement() {
        return (GenericElement)this.getFactory().createById("org.jbpm.gd.jpdl.genericElement");
    }

    private Task createTask() {
        Controller controller = (Controller)this.getFactory().createById("org.jbpm.gd.jpdl.controller");
        Task task = (Task)this.getFactory().createById("org.jbpm.gd.jpdl.task");
        task.setController(controller);
        return task;
    }

    private Action createAction() {
        Action action = (Action)this.getFactory().createById("org.jbpm.gd.jpdl.action");
        return action;
    }

    private String getHandler() {
        String outgoingHandler = ApplicationProperties.getInstance().get("AutoTask.OutgoingHandler").toString();
        String incomingHandler = ApplicationProperties.getInstance().get("AutoTask.IncomingHandler").toString();
        String attachmentHandler = ApplicationProperties.getInstance().get("AutoTask.AttachmentHandler").toString();
        if (this.hasAttachment()) {
            return attachmentHandler;
        }
        return this.isOutgoingMessage(this.getUid()) ? outgoingHandler : incomingHandler;
    }

    private boolean isOutgoingMessage(String uid) {
        String workflowSystemId = ApplicationProperties.getInstance().get("WFS.ResourceType.SystemId").toString();
        return !uid.substring(2, 4).equals(workflowSystemId);
    }
}

