/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.model;

import com.tandbergtv.watchpoint.studio.application.StudioRuntimeException;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement;
import com.tandbergtv.watchpoint.studio.ui.model.IDurationElement;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageContainer;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageNodeContainer;
import com.tandbergtv.watchpoint.studio.ui.model.IResourceGroupElement;
import com.tandbergtv.watchpoint.studio.ui.model.NodeGroup;
import com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.util.NameValuePair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.gd.jpdl.model.AbstractNode;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDefinition
extends AbstractNode
implements IResourceGroupElement,
IMessageNodeContainer,
IDurationElement,
IDueDateElement,
NodeElementContainer {
    private long id;
    private AbstractNode node;
    private String definitionName;
    private long resourceType;
    private NodeDefinitionType nodeType;
    private List<WPVariable> variables = new ArrayList<WPVariable>();

    public long getId() {
        return this.id;
    }

    public void setId(long newId) {
        long oldId = this.id;
        this.id = newId;
        this.firePropertyChange("id", oldId, newId);
    }

    public void setName(String newName) {
        super.setName(newName);
        if (this.node != null) {
            this.node.setName(newName);
        }
    }

    public AbstractNode getNode() {
        return this.node;
    }

    public void setNode(AbstractNode newNode) {
        AbstractNode oldNode = this.node;
        this.node = newNode;
        if (newNode instanceof AutomaticTaskNode) {
            this.firePropertyChange("auto-task", oldNode, newNode);
        } else {
            this.firePropertyChange("super-state", oldNode, newNode);
        }
    }

    public String getDefinitionName() {
        return this.definitionName;
    }

    public void setDefinitionName(String newDefinitionName) {
        String oldDefinitionName = this.definitionName;
        this.definitionName = newDefinitionName;
        this.firePropertyChange("definitionName", oldDefinitionName, newDefinitionName);
    }

    public NodeDefinitionType getNodeType() {
        if (this.nodeType != null) {
            return this.nodeType;
        }
        if (this.node instanceof NodeElementContainer) {
            return NodeDefinitionType.SuperState;
        }
        return NodeDefinitionType.SingleNode;
    }

    public void setNodeType(NodeDefinitionType nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public long getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(long newResourceType) {
        String oldResourceType = this.definitionName;
        this.resourceType = newResourceType;
        this.firePropertyChange("resourceType", oldResourceType, newResourceType);
    }

    @Override
    public ResourceGroup getResourceGroup() {
        if (this.node == null) {
            return null;
        }
        return ((IResourceGroupElement)this.node).getResourceGroup();
    }

    @Override
    public void setResourceGroup(ResourceGroup group) {
        ((IResourceGroupElement)this.node).setResourceGroup(group);
    }

    @Override
    public String getUid() {
        if (this.node instanceof IMessageContainer) {
            return ((IMessageContainer)this.node).getUid();
        }
        return null;
    }

    @Override
    public void setUid(String uid) {
        if (this.node instanceof IMessageContainer) {
            ((IMessageContainer)this.node).setUid(uid);
        }
    }

    @Override
    public List<WPVariable> getVariables() {
        if (this.node instanceof NodeElementContainer) {
            return this.variables;
        }
        if (this.node == null) {
            return new ArrayList<WPVariable>();
        }
        IMessageContainer messageContainer = (IMessageContainer)this.node;
        List<WPVariable> vars = messageContainer.getIncomingVariables();
        vars.addAll(messageContainer.getOutgoingVariables());
        vars.addAll(this.getNodeCompositeKeys());
        return vars;
    }

    @Override
    public void addVariable(WPVariable variable) {
        if (!(this.node instanceof NodeElementContainer)) {
            return;
        }
        this.variables.add(variable);
        this.firePropertyChange("variableAdd", null, (Object)variable);
    }

    @Override
    public WPVariable removeVariable(String name) {
        WPVariable variable = null;
        if (this.node instanceof NodeElementContainer) {
            for (WPVariable var : this.variables) {
                if (!var.getMappedName().equals(name)) continue;
                variable = this.variables.remove(this.variables.indexOf((Object)var));
                this.firePropertyChange("variableRemove", (Object)var, null);
                break;
            }
        }
        return variable;
    }

    @Override
    public List<NameValuePair> getConstants() {
        ArrayList<NameValuePair> constants = new ArrayList<NameValuePair>();
        if (this.node == null) {
            return constants;
        }
        if (this.node instanceof NodeElementContainer) {
            NodeElementContainer superState = (NodeElementContainer)this.node;
            NodeElement[] nodeElementArray = superState.getNodeElements();
            int n = nodeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeElement nodeElement = nodeElementArray[n2];
                if (nodeElement instanceof IMessageNodeContainer) {
                    IMessageNodeContainer messageNodeContainer = (IMessageNodeContainer)nodeElement;
                    constants.addAll(messageNodeContainer.getConstants());
                }
                ++n2;
            }
        } else {
            IMessageContainer messageContainer = (IMessageContainer)this.node;
            for (String key : messageContainer.getConstants().keySet()) {
                constants.add(new NameValuePair(key, messageContainer.getConstants().get(key)));
            }
        }
        return constants;
    }

    @Override
    public void setConstantValue(String varName, String val) {
        if (this.node instanceof NodeElementContainer) {
            throw new StudioRuntimeException("Can not set constant values for super-states.");
        }
        ((IMessageContainer)this.node).setConstantValue(varName, val);
    }

    @Override
    public String getCompositeKey(String varName) {
        if (this.node instanceof NodeElementContainer) {
            return null;
        }
        return ((IMessageContainer)this.node).getCompositeKey(varName);
    }

    @Override
    public void setCompositeKey(String varName, String val) {
        if (this.node instanceof NodeElementContainer) {
            throw new StudioRuntimeException("Can not set composite key for a super-state.");
        }
        ((IMessageContainer)this.node).setCompositeKey(varName, val);
    }

    @Override
    public Map<String, String> getCompositeKeys() {
        HashMap<String, String> keys = new HashMap<String, String>();
        if (this.node == null) {
            return keys;
        }
        if (!(this.node instanceof NodeElementContainer)) {
            IMessageContainer messageContainer = (IMessageContainer)this.node;
            keys.putAll(messageContainer.getCompositeKeys());
        }
        return keys;
    }

    @Override
    public List<WPVariable> getIncomingVariables() {
        ArrayList<WPVariable> incomingVars = new ArrayList<WPVariable>();
        if (!(this.node instanceof NodeElementContainer)) {
            IMessageContainer messageContainer = (IMessageContainer)this.node;
            this.addIncomingVariablesFromNode(incomingVars, messageContainer);
        }
        return incomingVars;
    }

    @Override
    public List<WPVariable> getOutgoingVariables() {
        ArrayList<WPVariable> outgoingVars = new ArrayList<WPVariable>();
        if (!(this.node instanceof NodeElementContainer)) {
            IMessageContainer messageContainer = (IMessageContainer)this.node;
            this.addOutgoingVariablesFromNode(outgoingVars, messageContainer);
        }
        return outgoingVars;
    }

    @Override
    public String getDuration() {
        if (this.node == null) {
            return "";
        }
        return ((IDurationElement)this.node).getDuration();
    }

    @Override
    public String getTaskDuration() {
        if (this.node == null) {
            return "";
        }
        return ((IDurationElement)this.node).getTaskDuration();
    }

    @Override
    public void setDuration(String duration) {
        ((IDurationElement)this.node).setDuration(duration);
    }

    @Override
    public void setTaskDuration(String taskDuration) {
        ((IDurationElement)this.node).setTaskDuration(taskDuration);
    }

    @Override
    public String getDueDate() {
        if (this.node == null) {
            return "";
        }
        return ((IDueDateElement)this.node).getDueDate();
    }

    @Override
    public void setDueDate(String dueDate) {
        if (this.node != null) {
            ((IDueDateElement)this.node).setDueDate(dueDate);
        }
    }

    public void addNodeElement(NodeElement node) {
        if (this.node instanceof NodeGroup) {
            ((NodeGroup)this.node).addNodeElement(node);
            this.firePropertyChange("nodeElementAdd", null, node);
        }
    }

    public boolean canAdd(NodeElement node) {
        if (this.node instanceof NodeGroup) {
            return node.isPossibleChildOf((NodeElementContainer)this);
        }
        return false;
    }

    public NodeElement getNodeElementByName(String nodeName) {
        if (this.node instanceof NodeGroup) {
            return ((NodeGroup)this.node).getNodeElementByName(nodeName);
        }
        if (this.node.getName().equals(nodeName)) {
            return this.node;
        }
        return null;
    }

    public NodeElement[] getNodeElements() {
        if (this.node instanceof NodeGroup) {
            return ((NodeGroup)this.node).getNodeElements();
        }
        return new NodeElement[]{this.node};
    }

    public void removeNodeElement(NodeElement node) {
        if (this.node instanceof NodeGroup) {
            ((NodeGroup)this.node).removeNodeElement(node);
            this.firePropertyChange("nodeElementRemove", node, null);
        }
    }

    private void addIncomingVariablesFromNode(List<WPVariable> incomingVars, IMessageContainer node) {
        if (node == null) {
            return;
        }
        incomingVars.addAll(node.getIncomingVariables());
    }

    private void addOutgoingVariablesFromNode(List<WPVariable> outgoingVars, IMessageContainer node) {
        if (node == null) {
            return;
        }
        outgoingVars.addAll(node.getOutgoingVariables());
    }

    private List<WPVariable> getNodeCompositeKeys() {
        ArrayList<WPVariable> compositeKeys = new ArrayList<WPVariable>();
        if (this.node == null) {
            return compositeKeys;
        }
        if (!(this.node instanceof NodeElementContainer)) {
            IMessageContainer messageContainer = (IMessageContainer)this.node;
            for (String key : messageContainer.getCompositeKeys().keySet()) {
                WPVariable var = this.createWPVariable();
                var.setMappedName(key);
                var.setName(messageContainer.getCompositeKeys().get(key));
                compositeKeys.add(var);
            }
        }
        return compositeKeys;
    }

    private WPVariable createWPVariable() {
        return (WPVariable)this.getFactory().createById("org.jbpm.gd.jpdl.variable");
    }
}

