/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.model;

import com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement;
import com.tandbergtv.watchpoint.studio.ui.model.IDurationElement;
import com.tandbergtv.watchpoint.studio.ui.model.IResourceGroupElement;
import com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.ActionElement;
import org.jbpm.gd.jpdl.model.CreateTimer;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.SuperState;

public class NodeGroup
extends SuperState
implements IDurationElement,
IDueDateElement,
IResourceGroupElement {
    private static final String SUPERSTATE_ENTER_EVENT = "superstate-enter";
    private static final String SUPERSTATE_LEAVE_EVENT = "superstate-leave";
    ResourceGroup resourceGroup = null;
    String duration;
    String taskDuration;

    public ResourceGroup getResourceGroup() {
        return this.resourceGroup;
    }

    public void setResourceGroup(ResourceGroup group) {
        this.resourceGroup = group;
        this.firePropertyChange("resourceGroupAdd", null, (Object)this.resourceGroup);
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String newDuration) {
        String oldDuration = this.duration;
        this.duration = newDuration;
        this.firePropertyChange("duration", oldDuration, newDuration);
    }

    public String getTaskDuration() {
        return this.taskDuration;
    }

    public void setTaskDuration(String newTaskDuration) {
        String oldTaskDuration = this.taskDuration;
        this.taskDuration = newTaskDuration;
        this.firePropertyChange("taskDuration", oldTaskDuration, newTaskDuration);
    }

    public String getDueDate() {
        CreateTimer createTimer = null;
        Event[] eventArray = this.getEvents();
        int n = eventArray.length;
        int n2 = 0;
        while (n2 < n) {
            Event event = eventArray[n2];
            if (event.getType().equals(SUPERSTATE_ENTER_EVENT)) {
                ActionElement[] actionElementArray = event.getActionElements();
                int n3 = actionElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ActionElement action = actionElementArray[n4];
                    if (action instanceof CreateTimer) {
                        createTimer = (CreateTimer)action;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (createTimer == null) {
            return null;
        }
        return createTimer.getDueDate();
    }

    public void setDueDate(String dueDate) {
        CreateTimer createTimer = this.getNodeEnterCreateTimer();
        if (createTimer == null) {
            return;
        }
        createTimer.setDueDate(dueDate);
    }

    private CreateTimer getNodeEnterCreateTimer() {
        Event nodeEnterEvent = this.AddTimerActionToEvent(SUPERSTATE_ENTER_EVENT, "timer-fire");
        this.AddTimerActionToEvent(SUPERSTATE_LEAVE_EVENT, "timer-delete");
        ActionElement[] actionElementArray = nodeEnterEvent.getActionElements();
        int n = actionElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionElement action = actionElementArray[n2];
            if (action instanceof CreateTimer) {
                return (CreateTimer)action;
            }
            ++n2;
        }
        return null;
    }

    private Event AddTimerActionToEvent(String eventName, String timerAction) {
        boolean newEvent = false;
        Event nodeEvent = null;
        Event[] eventArray = this.getEvents();
        int n = eventArray.length;
        int n2 = 0;
        while (n2 < n) {
            Event event = eventArray[n2];
            if (event.getType().equals(eventName)) {
                nodeEvent = event;
            }
            ++n2;
        }
        if (nodeEvent == null) {
            nodeEvent = (Event)this.getFactory().createById("org.jbpm.gd.jpdl.event");
            this.addEvent(nodeEvent);
            nodeEvent.setType(eventName);
            newEvent = true;
        }
        Action action = null;
        if (eventName.equals(SUPERSTATE_ENTER_EVENT)) {
            CreateTimer createTimer = null;
            if (!newEvent) {
                ActionElement[] actionElementArray = nodeEvent.getActionElements();
                int n3 = actionElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ActionElement actionElement = actionElementArray[n4];
                    if (actionElement instanceof CreateTimer) {
                        createTimer = (CreateTimer)actionElement;
                    }
                    ++n4;
                }
            }
            if (createTimer == null) {
                createTimer = (CreateTimer)this.getFactory().createById("org.jbpm.gd.jpdl.createTimer");
                nodeEvent.addActionElement((ActionElement)createTimer);
            }
            if ((action = createTimer.getAction()) == null) {
                action = (Action)this.getFactory().createById("org.jbpm.gd.jpdl.action");
                createTimer.setAction(action);
            }
        } else if (eventName.equals(SUPERSTATE_LEAVE_EVENT)) {
            ActionElement[] actionElementArray = nodeEvent.getActionElements();
            int n5 = actionElementArray.length;
            n = 0;
            while (n < n5) {
                ActionElement actionElement = actionElementArray[n];
                if (actionElement instanceof Action && ((Action)actionElement).getRefName() != null && ((Action)actionElement).getRefName().equals(timerAction)) {
                    action = (Action)actionElement;
                }
                ++n;
            }
            if (action == null) {
                action = (Action)this.getFactory().createById("org.jbpm.gd.jpdl.action");
                nodeEvent.addActionElement((ActionElement)action);
            }
        }
        action.setRefName(timerAction);
        return nodeEvent;
    }
}

