/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.properties.WPVariableTableCellClickedResolver;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jbpm.gd.jpdl.util.AutoResizeTableLayout;

public abstract class AbstractMessageContainerComposite
implements SelectionListener {
    protected FormToolkit widgetFactory;
    protected Label outMessageLabel;
    protected Label inMessageLabel;
    protected Table outVariablesTable;
    protected Table inVariablesTable;
    private WPVariableTableCellClickedResolver outResolver;
    private WPVariableTableCellClickedResolver inResolver;

    protected void init(FormToolkit widgetFactory) {
        this.widgetFactory = widgetFactory;
    }

    protected void create(Composite parent) {
        this.outMessageLabel = this.widgetFactory.createLabel(parent, "Define the outgoing variables :");
        this.outVariablesTable = this.widgetFactory.createTable(parent, 66304);
        this.inMessageLabel = this.widgetFactory.createLabel(parent, "Define the incoming variables :");
        this.inVariablesTable = this.widgetFactory.createTable(parent, 66304);
        this.outResolver = new WPVariableTableCellClickedResolver(this.outVariablesTable);
        this.inResolver = new WPVariableTableCellClickedResolver(this.inVariablesTable);
        this.outMessageLabel.setLayoutData((Object)this.createOutMessageLabelLayoutData());
        this.outVariablesTable.setLayoutData((Object)this.createOutVariablesTableLayoutData());
        this.initializeOutVariablesTable();
        this.inMessageLabel.setLayoutData((Object)this.createInMessageLabelLayoutData());
        this.inVariablesTable.setLayoutData((Object)this.createInVariablesTableLayoutData());
        this.initializeInVariablesTable();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    protected void hookListeners() {
        this.outVariablesTable.addSelectionListener((SelectionListener)this);
        this.outVariablesTable.addMouseListener((MouseListener)this.outResolver);
        this.inVariablesTable.addSelectionListener((SelectionListener)this);
        this.inVariablesTable.addMouseListener((MouseListener)this.inResolver);
    }

    protected void unhookListeners() {
        this.outVariablesTable.removeSelectionListener((SelectionListener)this);
        this.outVariablesTable.removeMouseListener((MouseListener)this.outResolver);
        this.inVariablesTable.removeSelectionListener((SelectionListener)this);
        this.inVariablesTable.removeMouseListener((MouseListener)this.inResolver);
    }

    protected void clearControls() {
        this.outVariablesTable.removeAll();
        this.inVariablesTable.removeAll();
    }

    protected void updateControls() {
        this.refreshTables();
    }

    protected abstract void refreshTables();

    protected abstract void initializeOutTableColumns();

    protected abstract void initializeInTableColumns();

    protected void initializeOutVariablesTable() {
        this.outVariablesTable.setHeaderVisible(true);
        this.outVariablesTable.setLinesVisible(true);
        this.outVariablesTable.setLayout((Layout)new AutoResizeTableLayout(this.outVariablesTable));
        this.initializeOutTableColumns();
        this.outVariablesTable.pack();
    }

    private void initializeInVariablesTable() {
        this.inVariablesTable.setHeaderVisible(true);
        this.inVariablesTable.setLinesVisible(true);
        this.inVariablesTable.setLayout((Layout)new AutoResizeTableLayout(this.inVariablesTable));
        this.initializeInTableColumns();
        this.inVariablesTable.pack();
    }

    private FormData createOutMessageLabelLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 5);
        result.left = new FormAttachment(0, 5);
        return result;
    }

    private FormData createInMessageLabelLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 100);
        result.left = new FormAttachment(0, 5);
        return result;
    }

    private FormData createOutVariablesTableLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.outMessageLabel, 5);
        result.left = new FormAttachment(0, 5);
        result.bottom = new FormAttachment((Control)this.inMessageLabel, -5);
        result.right = new FormAttachment(100, -50);
        result.width = 400;
        return result;
    }

    private FormData createInVariablesTableLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.inMessageLabel, 5);
        result.left = new FormAttachment(0, 5);
        result.bottom = new FormAttachment(100, -5);
        result.right = new FormAttachment(100, -50);
        result.width = 400;
        return result;
    }
}

