/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jbpm.gd.jpdl.model.Variable;

public abstract class AbstractVariableTableItemWrapper
implements DisposeListener,
SelectionListener,
FocusListener {
    protected TableItem tableItem;
    protected Text mappedNameText;
    protected WPVariable variable;

    public AbstractVariableTableItemWrapper(Table table, Variable variable) {
        this.variable = (WPVariable)variable;
        this.initializeTableItem(table);
        this.initializeMappedNameText(table);
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.mappedNameText && this.mappedNameText.getEditable()) {
            this.variable.setMappedName(this.mappedNameText.getText());
            this.applyMappedName();
        }
        this.cancelEditing();
    }

    public void focusGained(FocusEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.mappedNameText == null || this.mappedNameText.isDisposed()) {
            return;
        }
        this.mappedNameText.removeSelectionListener((SelectionListener)this);
        this.mappedNameText.removeFocusListener((FocusListener)this);
        this.mappedNameText.dispose();
    }

    public TableItem getTableItem() {
        return this.tableItem;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void editCell(int column) {
        if (column == 1) {
            this.editMappedName();
        }
    }

    protected void initializeTableItem(Table table) {
        this.tableItem = new TableItem(table, 0);
        this.tableItem.addDisposeListener((DisposeListener)this);
        this.tableItem.setData((Object)this);
    }

    protected void initializeMappedNameText(Table table) {
        this.mappedNameText = this.createText(table, 1);
        this.mappedNameText.addSelectionListener((SelectionListener)this);
        this.mappedNameText.addFocusListener((FocusListener)this);
        this.mappedNameText.setText(this.getMappedName());
        this.mappedNameText.setEditable(false);
        this.mappedNameText.pack();
    }

    protected Button createButton(Table table, int index) {
        TableEditor checkboxEditor = new TableEditor(table);
        Button result = new Button((Composite)table, 32);
        result.pack();
        checkboxEditor.minimumWidth = result.getSize().x;
        checkboxEditor.horizontalAlignment = 0x1000000;
        checkboxEditor.setEditor((Control)result, this.tableItem, index);
        return result;
    }

    protected Text createText(Table table, int index) {
        TableEditor textEditor = new TableEditor(table);
        Text result = new Text((Composite)table, 0);
        result.pack();
        textEditor.horizontalAlignment = 16384;
        textEditor.grabHorizontal = true;
        textEditor.setEditor((Control)result, this.tableItem, index);
        return result;
    }

    protected CCombo createCombo(Table table, int index) {
        TableEditor textEditor = new TableEditor(table);
        CCombo result = new CCombo((Composite)table, 780);
        result.pack();
        textEditor.horizontalAlignment = 16384;
        textEditor.grabHorizontal = true;
        textEditor.setEditor((Control)result, this.tableItem, index);
        return result;
    }

    protected void editMappedName() {
        this.mappedNameText.setVisible(true);
        this.mappedNameText.setText(this.getMappedName());
        this.mappedNameText.setFocus();
        this.mappedNameText.selectAll();
    }

    protected void cancelEditing() {
        this.applyMappedName();
    }

    protected void applyMappedName() {
        if (this.mappedNameText == null && !this.mappedNameText.isDisposed()) {
            return;
        }
        this.mappedNameText.setVisible(false);
        this.tableItem.setText(1, this.getMappedName());
    }

    protected String getMappedName() {
        if (this.variable.getMappedName() == null || this.variable.getMappedName().equals("")) {
            return this.variable.getName() == null ? "" : this.variable.getName();
        }
        return this.variable.getMappedName();
    }
}

