/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.util.ValidationMessages;
import com.tandbergtv.watchpoint.studio.util.TimerExpression;
import com.tandbergtv.watchpoint.studio.util.TimerExpressionMarshaller;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.io.IOException;
import java.util.HashSet;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.NodeElementContainer;

public class DueDateElementConfigurationComposite
implements FocusListener,
SelectionListener {
    private static final Logger logger = Logger.getLogger(DueDateElementConfigurationComposite.class);
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private CCombo dueDateFirstText;
    private CCombo dueDateOperator;
    private CCombo dueDateSecondText;
    private Label dueDateLabel;
    private IDueDateElement dueDateElement;
    private AbstractPropertySection parentPropertySection;
    private String currentOperator = null;
    private static final String[] ADD_OPERATOR_VARIABLE_FILTER = new String[]{"DURATION"};
    private static final String[] MLPY_OPERATOR_VARIABLE_FILTER = new String[]{"INT", "STRING"};

    private DueDateElementConfigurationComposite() {
    }

    public static DueDateElementConfigurationComposite create(AbstractPropertySection parentSection, TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        DueDateElementConfigurationComposite result = new DueDateElementConfigurationComposite();
        result.parentPropertySection = parentSection;
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    public void setDueDateElement(IDueDateElement dueDateElement) {
        if (dueDateElement instanceof NodeDefinition) {
            if (((NodeDefinition)dueDateElement).getNode() == null) {
                this.dueDateFirstText.setEnabled(false);
                this.dueDateSecondText.setEnabled(false);
                this.dueDateOperator.setEnabled(false);
            } else {
                this.dueDateFirstText.setEnabled(true);
                this.dueDateSecondText.setEnabled(true);
                this.dueDateOperator.setEnabled(true);
            }
        }
        this.clearControls();
        this.dueDateElement = dueDateElement;
        if (dueDateElement != null) {
            this.updateControls();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.dueDateElement == null) {
            return;
        }
        if (e.widget == this.dueDateFirstText || e.widget == this.dueDateSecondText || e.widget == this.dueDateOperator) {
            String firstExpr = this.dueDateFirstText.getText();
            String operator = this.dueDateOperator.getText();
            String secondExpr = this.dueDateSecondText.getText();
            String expression = String.valueOf(firstExpr) + operator + secondExpr;
            this.dueDateElement.setDueDate(expression);
            if (operator.length() <= 0 || secondExpr.length() != 0) {
                this.validate();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent arg0) {
        String operator = this.dueDateOperator.getText();
        if (!operator.equals(this.currentOperator)) {
            this.setVariables();
            this.dueDateSecondText.setText("");
            this.currentOperator = operator;
        }
    }

    private void clearControls() {
        this.dueDateFirstText.removeAll();
        this.dueDateSecondText.removeAll();
        this.dueDateOperator.select(0);
        this.currentOperator = this.dueDateOperator.getText();
    }

    private void updateControls() {
        String dueDate = this.dueDateElement.getDueDate();
        if (dueDate != null) {
            TimerExpression te = TimerExpressionMarshaller.unmarshall(dueDate);
            this.dueDateFirstText.setText(te.getOperand1() != null ? te.getOperand1() : "");
            this.dueDateSecondText.setText(te.getOperand2() != null ? te.getOperand2() : "");
            this.dueDateOperator.setText(te.getOperator() != null ? te.getOperator() : "");
        } else {
            this.dueDateFirstText.setText("");
            this.dueDateSecondText.setText("");
            this.dueDateOperator.setText("");
        }
        this.currentOperator = this.dueDateOperator.getText();
        this.dueDateFirstText.setItems(this.getVariables(ADD_OPERATOR_VARIABLE_FILTER));
        this.setVariables();
    }

    private void create() {
        Composite composite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.dueDateLabel = new Label(composite, 0);
        this.dueDateLabel.setText("Due Date");
        this.dueDateLabel.setLayoutData((Object)this.createDueDateLabelLayoutData());
        this.dueDateLabel.setBackground(ColorConstants.white);
        this.dueDateLabel.pack();
        this.dueDateFirstText = this.widgetFactory.createCCombo(this.parent, 4);
        this.dueDateFirstText.setLayoutData((Object)this.createDueDateTextLayoutData(0, 85, 200));
        this.dueDateFirstText.setItems(new String[0]);
        this.dueDateFirstText.setEditable(true);
        this.dueDateFirstText.addFocusListener((FocusListener)this);
        this.dueDateFirstText.pack();
        this.dueDateOperator = this.widgetFactory.createCCombo(this.parent, 4);
        this.dueDateOperator.setLayoutData((Object)this.createDueDateTextLayoutData(0, 310, 35));
        this.dueDateOperator.setItems(this.getOptions());
        this.dueDateOperator.setEditable(false);
        this.dueDateOperator.addSelectionListener((SelectionListener)this);
        this.dueDateOperator.addFocusListener((FocusListener)this);
        this.dueDateOperator.pack();
        this.currentOperator = this.dueDateOperator.getText();
        this.dueDateSecondText = this.widgetFactory.createCCombo(this.parent, 4);
        this.dueDateSecondText.setLayoutData((Object)this.createDueDateTextLayoutData(0, 370, 200));
        this.dueDateSecondText.setItems(new String[0]);
        this.dueDateSecondText.setEditable(true);
        this.dueDateSecondText.addFocusListener((FocusListener)this);
        this.dueDateSecondText.pack();
    }

    private FormData createDueDateLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, -6);
        data.top = new FormAttachment(0, 0);
        return data;
    }

    private FormData createDueDateTextLayoutData(int x, int y, int z) {
        FormData data = new FormData();
        data.left = new FormAttachment(x, y);
        data.top = new FormAttachment(0, 0);
        data.width = z;
        return data;
    }

    private String[] getOptions() {
        String[] options = new String[]{"", "+", "*"};
        return options;
    }

    private String[] getVariables(String[] types) {
        IWorkbenchPart part = this.parentPropertySection.getPart();
        List<WPVariable> variables = Utility.getVariables(Utility.getNodeElementContainer(part));
        HashSet<String> variableNames = new HashSet<String>();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            for (WPVariable variable : variables) {
                if (!type.equals(variable.getType()) || variable.getName() == null) continue;
                variableNames.add(variable.getName());
            }
            ++n2;
        }
        String[] options = variableNames.toArray(new String[variableNames.size()]);
        return options;
    }

    private void validate() {
        ValidationServiceFactory serviceFactory = ValidationServiceFactory.createFactory();
        IValidationService validationService = serviceFactory.createValidationService();
        IWorkbenchPart part = this.parentPropertySection.getPart();
        NodeElementContainer container = Utility.getNodeElementContainer(part);
        List<ValidationMessage> messages = null;
        if (container instanceof WorkflowTemplate) {
            WorkflowTemplate template = (WorkflowTemplate)container;
            messages = validationService.validateDueDate(this.dueDateElement, template);
        } else if (container instanceof NodeDefinition) {
            NodeDefinition nodeDefinition = (NodeDefinition)container;
            messages = validationService.validateDueDate(this.dueDateElement, nodeDefinition);
        }
        if (messages != null && messages.size() > 0) {
            try {
                String msg = ValidationMessages.getInstance().getMessage(messages.get(0));
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error in Due Date Expression", (String)msg);
            }
            catch (InvalidPropertiesFormatException e) {
                logger.error((Object)"Error occured while opening the Message Dialog", (Throwable)e);
                throw new UIException("Error occured while opening the Message Dialog");
            }
            catch (IOException e) {
                logger.error((Object)"Error occured while opening the Message Dialog", (Throwable)e);
                throw new UIException("Error occured while opening the Message Dialog");
            }
        }
    }

    private void setVariables() {
        String operator = this.dueDateOperator.getText();
        boolean enabled = operator.length() > 0;
        String[] variables = new String[]{};
        if (operator.equals("+")) {
            variables = this.getVariables(ADD_OPERATOR_VARIABLE_FILTER);
        } else if (operator.equals("*")) {
            variables = this.getVariables(MLPY_OPERATOR_VARIABLE_FILTER);
        }
        this.dueDateSecondText.setEnabled(enabled);
        this.dueDateSecondText.setItems(variables);
    }
}

