/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.model.IDurationElement;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.util.ValidationMessages;
import com.tandbergtv.watchpoint.studio.util.TimerExpression;
import com.tandbergtv.watchpoint.studio.util.TimerExpressionMarshaller;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.io.IOException;
import java.util.HashSet;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.NodeElementContainer;

public class DurationElementConfigurationComposite
implements FocusListener,
SelectionListener {
    private static final Logger logger = Logger.getLogger(DurationElementConfigurationComposite.class);
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Text taskDurationText;
    private CCombo durationText;
    private CCombo durationSecondText;
    private CCombo durationOperator;
    private Label durationLabel;
    private Label taskDurationLabel;
    private IDurationElement durationElement;
    private AbstractPropertySection parentPropertySection;
    private String currentOperator = null;
    private static final String[] ADD_OPERATOR_VARIABLE_FILTER = new String[]{"DURATION"};
    private static final String[] MLPY_OPERATOR_VARIABLE_FILTER = new String[]{"INT", "STRING"};

    private DurationElementConfigurationComposite() {
    }

    public static DurationElementConfigurationComposite create(AbstractPropertySection parentSection, TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        DurationElementConfigurationComposite result = new DurationElementConfigurationComposite();
        result.parentPropertySection = parentSection;
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    public void setDurationElement(IDurationElement durationElement) {
        if (durationElement instanceof NodeDefinition) {
            if (((NodeDefinition)durationElement).getNode() == null) {
                this.durationText.setEnabled(false);
                this.durationSecondText.setEnabled(false);
                this.durationOperator.setEnabled(false);
                this.taskDurationText.setEnabled(false);
            } else {
                this.durationText.setEnabled(true);
                this.durationSecondText.setEnabled(true);
                this.durationOperator.setEnabled(true);
                this.taskDurationText.setEnabled(true);
            }
        }
        this.clearControls();
        this.durationElement = durationElement;
        if (durationElement != null) {
            this.updateControls();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.durationElement == null) {
            return;
        }
        if (e.widget == this.durationText || e.widget == this.durationSecondText || e.widget == this.durationOperator) {
            String firstExpr = this.durationText.getText();
            String operator = this.durationOperator.getText();
            String secondExpr = this.durationSecondText.getText();
            String expression = String.valueOf(firstExpr) + operator + secondExpr;
            this.durationElement.setDuration(expression);
            if (operator.length() <= 0 || secondExpr.length() != 0) {
                this.validate();
            }
        } else if (e.widget == this.taskDurationText) {
            this.durationElement.setTaskDuration(this.taskDurationText.getText());
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent arg0) {
        String operator = this.durationOperator.getText();
        if (!operator.equals(this.currentOperator)) {
            this.setVariables();
            this.durationSecondText.setText("");
            this.currentOperator = operator;
        }
    }

    private void clearControls() {
        this.durationText.removeAll();
        this.durationSecondText.removeAll();
        this.durationOperator.select(0);
        this.taskDurationText.setText("");
        this.currentOperator = this.durationOperator.getText();
    }

    private void updateControls() {
        String duration = this.durationElement.getDuration();
        if (duration != null) {
            TimerExpression te = TimerExpressionMarshaller.unmarshall(duration);
            this.durationText.setText(te.getOperand1() != null ? te.getOperand1() : "");
            this.durationSecondText.setText(te.getOperand2() != null ? te.getOperand2() : "");
            this.durationOperator.setText(te.getOperator() != null ? te.getOperator() : "");
        } else {
            this.durationText.setText("");
            this.durationSecondText.setText("");
            this.durationOperator.setText("");
        }
        String taskDuration = this.durationElement.getTaskDuration();
        if (taskDuration != null) {
            this.taskDurationText.setText(taskDuration);
        } else {
            this.taskDurationText.setText("");
        }
        this.currentOperator = this.durationOperator.getText();
        this.durationText.setItems(this.getVariables(ADD_OPERATOR_VARIABLE_FILTER));
        this.setVariables();
    }

    private void create() {
        Composite composite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.durationLabel = new Label(composite, 0);
        this.durationLabel.setText("Duration");
        this.durationLabel.setLayoutData((Object)this.createDurationpLabelLayoutData());
        this.durationLabel.setBackground(ColorConstants.white);
        this.durationLabel.pack();
        this.taskDurationLabel = new Label(composite, 0);
        this.taskDurationLabel.setText("Task Duration");
        this.taskDurationLabel.setLayoutData((Object)this.createTaskDurationpLabelLayoutData());
        this.taskDurationLabel.setBackground(ColorConstants.white);
        this.taskDurationLabel.pack();
        this.durationText = this.widgetFactory.createCCombo(this.parent, 4);
        this.durationText.setLayoutData((Object)this.createDurationTextLayoutData(0, 85, 200));
        this.durationText.setItems(new String[0]);
        this.durationText.setEditable(true);
        this.durationText.addFocusListener((FocusListener)this);
        this.durationText.pack();
        this.durationOperator = this.widgetFactory.createCCombo(this.parent, 4);
        this.durationOperator.setLayoutData((Object)this.createDurationTextLayoutData(0, 310, 35));
        this.durationOperator.setItems(this.getOptions());
        this.durationOperator.setEditable(false);
        this.durationOperator.addSelectionListener((SelectionListener)this);
        this.durationOperator.addFocusListener((FocusListener)this);
        this.durationOperator.pack();
        this.currentOperator = this.durationOperator.getText();
        this.durationSecondText = this.widgetFactory.createCCombo(this.parent, 4);
        this.durationSecondText.setLayoutData((Object)this.createDurationTextLayoutData(0, 370, 200));
        this.durationSecondText.setItems(new String[0]);
        this.durationSecondText.setEditable(true);
        this.durationSecondText.addFocusListener((FocusListener)this);
        this.durationSecondText.pack();
        this.taskDurationText = this.widgetFactory.createText(this.parent, "");
        this.taskDurationText.setLayoutData((Object)this.createTaskDurationTextLayoutData());
        this.taskDurationText.addFocusListener((FocusListener)this);
        this.taskDurationText.pack();
    }

    private FormData createDurationpLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, -6);
        data.top = new FormAttachment(0, 0);
        return data;
    }

    private FormData createTaskDurationpLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, -6);
        data.top = new FormAttachment((Control)this.durationLabel, 2);
        return data;
    }

    private FormData createDurationTextLayoutData(int x, int y, int z) {
        FormData data = new FormData();
        data.left = new FormAttachment(x, y);
        data.top = new FormAttachment(0, 0);
        data.width = z;
        return data;
    }

    private FormData createTaskDurationTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.top = new FormAttachment((Control)this.durationText, 2);
        data.width = 450;
        return data;
    }

    private String[] getOptions() {
        String[] options = new String[]{"", "+", "*"};
        return options;
    }

    private String[] getVariables(String[] types) {
        IWorkbenchPart part = this.parentPropertySection.getPart();
        List<WPVariable> variables = Utility.getVariables(Utility.getNodeElementContainer(part));
        HashSet<String> variableNames = new HashSet<String>();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            for (WPVariable variable : variables) {
                if (!type.equals(variable.getType()) || variable.getName() == null) continue;
                variableNames.add(variable.getName());
            }
            ++n2;
        }
        String[] options = variableNames.toArray(new String[variableNames.size()]);
        return options;
    }

    private void validate() {
        ValidationServiceFactory serviceFactory = ValidationServiceFactory.createFactory();
        IValidationService validationService = serviceFactory.createValidationService();
        IWorkbenchPart part = this.parentPropertySection.getPart();
        NodeElementContainer container = Utility.getNodeElementContainer(part);
        List<ValidationMessage> messages = null;
        if (container instanceof WorkflowTemplate) {
            WorkflowTemplate template = (WorkflowTemplate)container;
            messages = validationService.validateDuration(this.durationElement, template);
        } else if (container instanceof NodeDefinition) {
            NodeDefinition nodeDefinition = (NodeDefinition)container;
            messages = validationService.validateDuration(this.durationElement, nodeDefinition);
        }
        if (messages != null && messages.size() > 0) {
            try {
                String msg = ValidationMessages.getInstance().getMessage(messages.get(0));
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error in Duration Expression", (String)msg);
            }
            catch (InvalidPropertiesFormatException e) {
                logger.error((Object)"Error occured while opening the Message Dialog", (Throwable)e);
                throw new UIException("Error occured while opening the Message Dialog");
            }
            catch (IOException e) {
                logger.error((Object)"Error occured while opening the Message Dialog", (Throwable)e);
                throw new UIException("Error occured while opening the Message Dialog");
            }
        }
    }

    private void setVariables() {
        String operator = this.durationOperator.getText();
        boolean enabled = operator.length() > 0;
        String[] variables = new String[]{};
        if (operator.equals("+")) {
            variables = this.getVariables(ADD_OPERATOR_VARIABLE_FILTER);
        } else if (operator.equals("*")) {
            variables = this.getVariables(MLPY_OPERATOR_VARIABLE_FILTER);
        }
        this.durationSecondText.setEnabled(enabled);
        this.durationSecondText.setItems(variables);
    }
}

