/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.model.IDurationElement;
import com.tandbergtv.watchpoint.studio.ui.properties.DurationElementConfigurationComposite;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;

public class DurationElementSection
extends AbstractPropertySection {
    private DurationElementConfigurationComposite durationElementConfigurationComposite;
    private IDurationElement durationElement;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite clientArea = this.getWidgetFactory().createFlatFormComposite(parent);
        this.durationElementConfigurationComposite = DurationElementConfigurationComposite.create(this, this.getWidgetFactory(), clientArea);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
            AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
            IDurationElement nodeSelected = (IDurationElement)notationElement.getSemanticElement();
            this.setDurationElement(nodeSelected);
        } else if (input instanceof OutlineEditPart) {
            IDurationElement nodeSelected = (IDurationElement)((OutlineEditPart)input).getModel();
            this.setDurationElement(nodeSelected);
        }
    }

    public void refresh() {
        if (this.durationElement != null) {
            this.durationElementConfigurationComposite.setDurationElement(this.durationElement);
        }
    }

    private void setDurationElement(IDurationElement dueDateElement) {
        this.durationElement = dueDateElement;
    }
}

