/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageNodeContainer;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractInVariableWrapper;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Variable;

public class InVariableTableItemWrapper
extends AbstractInVariableWrapper {
    private IMessageNodeContainer messageNodeContainer;
    private AbstractPropertySection parentPropertySection;

    public InVariableTableItemWrapper(AbstractPropertySection parentSection, Table table, Variable variable, IMessageNodeContainer messageContainer) {
        super(table, variable);
        this.parentPropertySection = parentSection;
        this.messageNodeContainer = messageContainer;
        this.compositeButton.setSelection(this.messageNodeContainer.getCompositeKey(this.variable.getMappedName()) != null);
        NodeElementContainer container = Utility.getNodeElementContainer(parentSection.getPart());
        boolean enabled = container instanceof NodeDefinition && ((NodeDefinition)container).getNodeType().equals(NodeDefinitionType.SuperState);
        this.variableCombo.setEnabled(enabled);
        if (enabled) {
            this.fillVariableCombo();
        }
    }

    public InVariableTableItemWrapper(AbstractPropertySection parentSection, Table table, String name, IMessageNodeContainer messageContainer) {
        super(table, new WPVariable());
        this.parentPropertySection = parentSection;
        this.variable.setMappedName(name);
        this.messageNodeContainer = messageContainer;
        this.compositeButton.setSelection(this.messageNodeContainer.getCompositeKey(this.variable.getMappedName()) != null);
        NodeElementContainer container = Utility.getNodeElementContainer(parentSection.getPart());
        boolean enabled = container instanceof NodeDefinition && ((NodeDefinition)container).getNodeType().equals(NodeDefinitionType.SuperState);
        this.variableCombo.setEnabled(enabled);
        if (enabled) {
            this.variable.setName(this.messageNodeContainer.getCompositeKey(name));
            this.fillVariableCombo();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.variableCombo) {
            this.variable.setName(this.variableCombo.getText());
            if (this.compositeButton.getSelection()) {
                this.messageNodeContainer.setCompositeKey(this.variable.getMappedName(), this.variableCombo.getText());
            }
        }
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.variableCombo) {
            this.setVariableName(this.variableCombo.getText());
        } else {
            super.focusLost(e);
        }
    }

    private void fillVariableCombo() {
        NodeDefinition nodeDefinition = (NodeDefinition)Utility.getNodeElementContainer(this.parentPropertySection.getPart());
        int index = 0;
        for (Variable variable : nodeDefinition.getVariables()) {
            if (variable.getMappedName() == null) continue;
            this.variableCombo.add(variable.getMappedName());
            if (this.variable.getName() != null && this.variable.getName().equals(variable.getMappedName())) {
                this.variableCombo.select(index);
            }
            ++index;
        }
    }

    private void setVariableName(String varName) {
        if (varName == null || varName.trim().equals("")) {
            return;
        }
        if (this.variable.getMappedName() == null || this.variable.getMappedName().equals("")) {
            this.variable.setMappedName(this.variable.getName());
        }
        this.variable.setName(varName);
    }
}

