/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.model.IMessageContainer;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractMessageContainerComposite;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractVariableTableItemWrapper;
import com.tandbergtv.watchpoint.studio.ui.properties.EditableInVarTableItemWrapper;
import com.tandbergtv.watchpoint.studio.ui.properties.EditableOutVarTableItemWrapper;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.jpdl.model.Variable;

public class MessageContainerComposite
extends AbstractMessageContainerComposite {
    protected IMessageContainer messageContainer;
    private String[] outColumnTitles = null;
    private String[] inColumnTitles = null;
    private Button addOutVarButton;
    private Button removeOutVarButton;
    private Button addInVarButton;
    private Button removeInVarButton;

    public static MessageContainerComposite create(FormToolkit widgetFactory, Composite parent, String[] outColumnTitles, String[] inColumnTitles) {
        MessageContainerComposite result = new MessageContainerComposite();
        result.init(widgetFactory, outColumnTitles, inColumnTitles);
        result.create(parent);
        return result;
    }

    public static MessageContainerComposite create(FormToolkit widgetFactory, Composite parent) {
        return MessageContainerComposite.create(widgetFactory, parent, new String[]{"Name", "Attachment", "Value", "Constant"}, new String[]{"Name", "Process variable", "Composite Key"});
    }

    protected void init(FormToolkit widgetFactory, String[] outColumnTitles, String[] inColumnTitles) {
        super.init(widgetFactory);
        this.outColumnTitles = outColumnTitles;
        this.inColumnTitles = inColumnTitles;
    }

    protected void create(Composite parent) {
        super.create(parent);
        this.addOutVarButton = this.widgetFactory.createButton(parent, "Add", 8);
        this.removeOutVarButton = this.widgetFactory.createButton(parent, "Remove", 8);
        this.addOutVarButton.setLayoutData((Object)this.createAddOutButtonLayoutData());
        this.removeOutVarButton.setLayoutData((Object)this.createRemoveOutButtonLayoutData());
        this.addInVarButton = this.widgetFactory.createButton(parent, "Add", 8);
        this.removeInVarButton = this.widgetFactory.createButton(parent, "Remove", 8);
        this.addInVarButton.setLayoutData((Object)this.createAddInButtonLayoutData());
        this.removeInVarButton.setLayoutData((Object)this.createRemoveInButtonLayoutData());
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.addOutVarButton) {
            this.handleAddOutVarButtonSelected();
        } else if (e.widget == this.removeOutVarButton) {
            this.handleRemoveOutVarButtonSelected();
        } else if (e.widget == this.addInVarButton) {
            this.handleAddInVarButtonSelected();
        } else if (e.widget == this.removeInVarButton) {
            this.handleRemoveInVarButtonSelected();
        }
    }

    public void setMessageContainer(IMessageContainer messageContainer) {
        this.unhookListeners();
        this.messageContainer = messageContainer;
        this.clearControls();
        if (messageContainer != null) {
            this.updateControls();
            this.hookListeners();
            boolean enable = messageContainer.getUid() != null && messageContainer.getUid().length() > 0;
            this.addOutVarButton.setEnabled(enable);
            this.addInVarButton.setEnabled(enable);
        }
    }

    protected void hookListeners() {
        super.hookListeners();
        this.addOutVarButton.addSelectionListener((SelectionListener)this);
        this.removeOutVarButton.addSelectionListener((SelectionListener)this);
        this.addInVarButton.addSelectionListener((SelectionListener)this);
        this.removeInVarButton.addSelectionListener((SelectionListener)this);
    }

    protected void unhookListeners() {
        super.unhookListeners();
        this.addOutVarButton.removeSelectionListener((SelectionListener)this);
        this.removeOutVarButton.removeSelectionListener((SelectionListener)this);
        this.addInVarButton.removeSelectionListener((SelectionListener)this);
        this.removeInVarButton.removeSelectionListener((SelectionListener)this);
    }

    protected void clearControls() {
        super.clearControls();
        this.addOutVarButton.setEnabled(false);
        this.removeOutVarButton.setEnabled(false);
        this.addInVarButton.setEnabled(false);
        this.removeInVarButton.setEnabled(false);
    }

    protected void updateControls() {
        this.addOutVarButton.setEnabled(true);
        this.addInVarButton.setEnabled(true);
        super.updateControls();
    }

    protected void initializeOutTableColumns() {
        TableLayout layout = (TableLayout)this.outVariablesTable.getLayout();
        TableColumn dummyColumn = new TableColumn(this.outVariablesTable, 0x1000000);
        dummyColumn.setText("");
        ColumnWeightData dummyColumnData = new ColumnWeightData(0);
        layout.addColumnData((ColumnLayoutData)dummyColumnData);
        TableColumn nameColumn = new TableColumn(this.outVariablesTable, 16384);
        nameColumn.setText(this.outColumnTitles[0]);
        nameColumn.pack();
        ColumnWeightData nameColumnData = new ColumnWeightData(15);
        layout.addColumnData((ColumnLayoutData)nameColumnData);
        TableColumn attachmemtColumn = new TableColumn(this.outVariablesTable, 16384);
        attachmemtColumn.setText(this.outColumnTitles[1]);
        attachmemtColumn.setAlignment(0x1000000);
        attachmemtColumn.pack();
        ColumnWeightData attachmentColumnData = new ColumnWeightData(9);
        layout.addColumnData((ColumnLayoutData)attachmentColumnData);
        TableColumn valueColumn = new TableColumn(this.outVariablesTable, 0x1000000);
        valueColumn.setText(this.outColumnTitles[2]);
        valueColumn.pack();
        ColumnWeightData valueColumnData = new ColumnWeightData(12);
        layout.addColumnData((ColumnLayoutData)valueColumnData);
        TableColumn constantColumn = new TableColumn(this.outVariablesTable, 0x1000000);
        constantColumn.setText(this.outColumnTitles[3]);
        constantColumn.pack();
        ColumnWeightData constantColumnData = new ColumnWeightData(12);
        layout.addColumnData((ColumnLayoutData)constantColumnData);
    }

    protected void initializeInTableColumns() {
        TableLayout layout = (TableLayout)this.inVariablesTable.getLayout();
        TableColumn dummyColumn = new TableColumn(this.inVariablesTable, 0x1000000);
        dummyColumn.setText("");
        ColumnWeightData dummyColumnData = new ColumnWeightData(0);
        layout.addColumnData((ColumnLayoutData)dummyColumnData);
        TableColumn nameColumn = new TableColumn(this.inVariablesTable, 16384);
        nameColumn.setText(this.inColumnTitles[0]);
        nameColumn.pack();
        ColumnWeightData nameColumnData = new ColumnWeightData(14);
        layout.addColumnData((ColumnLayoutData)nameColumnData);
        TableColumn processVarColumn = new TableColumn(this.inVariablesTable, 16384);
        processVarColumn.setText(this.inColumnTitles[1]);
        processVarColumn.pack();
        ColumnWeightData processVarColumnData = new ColumnWeightData(14);
        layout.addColumnData((ColumnLayoutData)processVarColumnData);
        TableColumn compositeKeyColumn = new TableColumn(this.inVariablesTable, 0x1000000);
        compositeKeyColumn.setText(this.inColumnTitles[2]);
        compositeKeyColumn.pack();
        ColumnWeightData compositeKeyColumnData = new ColumnWeightData(6);
        layout.addColumnData((ColumnLayoutData)compositeKeyColumnData);
    }

    protected void refreshTables() {
        AbstractVariableTableItemWrapper wrapper;
        Object var;
        this.outVariablesTable.removeAll();
        List<WPVariable> variables = this.messageContainer.getOutgoingVariables();
        for (WPVariable var2 : variables) {
            EditableOutVarTableItemWrapper wrapper2 = new EditableOutVarTableItemWrapper(this.outVariablesTable, var2, this.messageContainer);
            this.outVariablesTable.setSelection(wrapper2.getTableItem());
            wrapper2.editCell(1);
        }
        for (String key : this.messageContainer.getConstants().keySet()) {
            var = this.createVariable(this.messageContainer.getFactory());
            var.setMappedName(key);
            var.setAccess("read");
            wrapper = new EditableOutVarTableItemWrapper(this.outVariablesTable, (Variable)var, this.messageContainer);
            this.outVariablesTable.setSelection(wrapper.getTableItem());
            wrapper.editCell(1);
        }
        this.inVariablesTable.removeAll();
        variables = this.messageContainer.getIncomingVariables();
        for (WPVariable var3 : variables) {
            wrapper = new EditableInVarTableItemWrapper(this.inVariablesTable, var3, this.messageContainer);
            this.inVariablesTable.setSelection(wrapper.getTableItem());
            wrapper.editCell(1);
        }
        for (String key : this.messageContainer.getCompositeKeys().keySet()) {
            var = this.createVariable(this.messageContainer.getFactory());
            var.setMappedName(key);
            var.setAccess("write");
            wrapper = new EditableInVarTableItemWrapper(this.inVariablesTable, (Variable)var, this.messageContainer);
            this.inVariablesTable.setSelection(wrapper.getTableItem());
            wrapper.editCell(1);
        }
        this.removeOutVarButton.setEnabled(this.outVariablesTable.getSelectionIndex() != -1);
        this.removeInVarButton.setEnabled(this.inVariablesTable.getSelectionIndex() != -1);
    }

    private FormData createAddOutButtonLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.outVariablesTable, 0);
        result.top.alignment = 128;
        result.left = new FormAttachment((Control)this.removeOutVarButton, 0);
        result.left.alignment = 16384;
        result.right = new FormAttachment(100, -5);
        return result;
    }

    private FormData createRemoveOutButtonLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.addOutVarButton, 5);
        result.right = new FormAttachment(100, -5);
        return result;
    }

    private FormData createAddInButtonLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.inVariablesTable, 0);
        result.top.alignment = 128;
        result.left = new FormAttachment((Control)this.removeInVarButton, 0);
        result.left.alignment = 16384;
        result.right = new FormAttachment(100, -4);
        return result;
    }

    private FormData createRemoveInButtonLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.addInVarButton, 5);
        result.right = new FormAttachment(100, -4);
        return result;
    }

    private void handleAddOutVarButtonSelected() {
        WPVariable variable = this.createVariable(this.messageContainer.getFactory());
        variable.setMappedName(this.getNextAvailableVariableName());
        variable.setAccess("read");
        this.messageContainer.addVariable(variable);
        EditableOutVarTableItemWrapper wrapper = new EditableOutVarTableItemWrapper(this.outVariablesTable, variable, this.messageContainer);
        this.outVariablesTable.setSelection(wrapper.getTableItem());
        wrapper.editCell(1);
        this.removeOutVarButton.setEnabled(this.outVariablesTable.getSelectionIndex() != -1);
    }

    private void handleRemoveOutVarButtonSelected() {
        TableItem item = this.outVariablesTable.getItem(this.outVariablesTable.getSelectionIndex());
        EditableOutVarTableItemWrapper wrapper = (EditableOutVarTableItemWrapper)item.getData();
        WPVariable var = (WPVariable)wrapper.getVariable();
        if (wrapper.isConstant()) {
            this.messageContainer.setConstantValue(var.getMappedName(), null);
        } else {
            this.messageContainer.removeVariable(wrapper.getVariable().getMappedName());
        }
        this.refreshTables();
        this.removeOutVarButton.setEnabled(this.outVariablesTable.getSelectionIndex() != -1);
    }

    private void handleAddInVarButtonSelected() {
        WPVariable variable = this.createVariable(this.messageContainer.getFactory());
        variable.setMappedName(this.getNextAvailableVariableName());
        variable.setAccess("write");
        this.messageContainer.addVariable(variable);
        EditableInVarTableItemWrapper wrapper = new EditableInVarTableItemWrapper(this.inVariablesTable, variable, this.messageContainer);
        this.inVariablesTable.setSelection(wrapper.getTableItem());
        wrapper.editCell(1);
        this.removeInVarButton.setEnabled(this.inVariablesTable.getSelectionIndex() != -1);
    }

    private void handleRemoveInVarButtonSelected() {
        TableItem item = this.inVariablesTable.getItem(this.inVariablesTable.getSelectionIndex());
        EditableInVarTableItemWrapper wrapper = (EditableInVarTableItemWrapper)item.getData();
        WPVariable var = (WPVariable)wrapper.getVariable();
        if (wrapper.isCompositeKey()) {
            this.messageContainer.setCompositeKey(var.getMappedName(), null);
        } else {
            this.messageContainer.removeVariable(wrapper.getVariable().getMappedName());
        }
        this.refreshTables();
        this.removeInVarButton.setEnabled(this.inVariablesTable.getSelectionIndex() != -1);
    }

    private WPVariable createVariable(SemanticElementFactory delegateFactory) {
        return (WPVariable)delegateFactory.createById("org.jbpm.gd.jpdl.variable");
    }

    private String getNextAvailableVariableName() {
        String result = "variable";
        int runner = 1;
        while (this.hasTableVariableWithName(String.valueOf(result) + runner)) {
            ++runner;
        }
        return String.valueOf(result) + runner;
    }

    private boolean hasTableVariableWithName(String name) {
        AbstractVariableTableItemWrapper wrapper;
        boolean result = false;
        int max = this.outVariablesTable.getItemCount();
        int i = 0;
        while (i < max) {
            wrapper = (AbstractVariableTableItemWrapper)this.outVariablesTable.getItem(i).getData();
            if (name.equals(wrapper.getVariable().getMappedName())) {
                result = true;
            }
            ++i;
        }
        max = this.inVariablesTable.getItemCount();
        i = 0;
        while (i < max) {
            wrapper = (AbstractVariableTableItemWrapper)this.inVariablesTable.getItem(i).getData();
            if (name.equals(wrapper.getVariable().getMappedName())) {
                result = true;
            }
            ++i;
        }
        return result;
    }
}

