/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.model.IMessageContainer;
import com.tandbergtv.watchpoint.studio.ui.properties.MessageContainerComposite;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;

public class MessageContainerSection
extends AbstractPropertySection {
    private IMessageContainer messageContainer;
    private MessageContainerComposite variableContainerComposite;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Group variablesArea = this.getWidgetFactory().createGroup(parent, "Variables");
        variablesArea.setVisible(false);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.height = 300;
        variablesArea.setLayout((Layout)new FormLayout());
        variablesArea.setData((Object)data);
        this.variableContainerComposite = MessageContainerComposite.create((FormToolkit)this.getWidgetFactory(), (Composite)variablesArea);
        variablesArea.pack();
        variablesArea.setVisible(true);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
            AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
            input = notationElement.getSemanticElement();
        } else if (input instanceof OutlineEditPart) {
            input = ((OutlineEditPart)input).getModel();
        }
        if (input instanceof IMessageContainer) {
            this.messageContainer = (IMessageContainer)input;
            this.refresh();
        }
    }

    public void refresh() {
        if (this.variableContainerComposite == null) {
            return;
        }
        if (this.messageContainer == null) {
            this.variableContainerComposite.setMessageContainer(null);
        } else {
            this.variableContainerComposite.setMessageContainer(this.messageContainer);
        }
    }
}

