/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.model.IMessageNodeContainer;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractMessageContainerComposite;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractVariableTableItemWrapper;
import com.tandbergtv.watchpoint.studio.ui.properties.InVariableTableItemWrapper;
import com.tandbergtv.watchpoint.studio.ui.properties.OutVariableTableItemWrapper;
import com.tandbergtv.watchpoint.studio.ui.util.NameValuePair;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;

public class MessageNodeContainerComposite
extends AbstractMessageContainerComposite {
    protected IMessageNodeContainer messageContainer;
    private String[] outColumnTitles = null;
    private String[] inColumnTitles = null;
    private AbstractPropertySection parentPropertySection;

    protected MessageNodeContainerComposite() {
    }

    public static MessageNodeContainerComposite create(AbstractPropertySection parentSection, FormToolkit widgetFactory, Composite parent, String[] outColumnTitles, String[] inColumnTitles) {
        MessageNodeContainerComposite result = new MessageNodeContainerComposite();
        result.parentPropertySection = parentSection;
        result.init(widgetFactory, outColumnTitles, inColumnTitles);
        result.create(parent);
        return result;
    }

    public static MessageNodeContainerComposite create(AbstractPropertySection parentSection, FormToolkit widgetFactory, Composite parent) {
        return MessageNodeContainerComposite.create(parentSection, widgetFactory, parent, new String[]{"Name", "Attachment", "Value", "Node Definition Variable"}, new String[]{"Name", "Node Definition Variable", "Composite Key"});
    }

    protected void init(FormToolkit widgetFactory, String[] outColumnTitles, String[] inColumnTitles) {
        super.init(widgetFactory);
        this.outColumnTitles = outColumnTitles;
        this.inColumnTitles = inColumnTitles;
    }

    public IMessageNodeContainer getMessageContainer() {
        return this.messageContainer;
    }

    public void setMessageContainer(IMessageNodeContainer messageContainer) {
        this.unhookListeners();
        this.messageContainer = messageContainer;
        this.clearControls();
        if (messageContainer != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    protected void refreshTables() {
        AbstractVariableTableItemWrapper wrapper;
        this.outVariablesTable.removeAll();
        List<WPVariable> variables = this.messageContainer.getOutgoingVariables();
        for (WPVariable var : variables) {
            wrapper = new OutVariableTableItemWrapper(this.parentPropertySection, this.outVariablesTable, var);
            this.outVariablesTable.setSelection(wrapper.getTableItem());
            wrapper.editCell(1);
        }
        for (NameValuePair pair : this.messageContainer.getConstants()) {
            wrapper = new OutVariableTableItemWrapper(this.parentPropertySection, this.outVariablesTable, pair.getName(), pair.getValue());
            this.outVariablesTable.setSelection(wrapper.getTableItem());
            wrapper.editCell(1);
        }
        this.inVariablesTable.removeAll();
        variables = this.messageContainer.getIncomingVariables();
        for (WPVariable var : variables) {
            wrapper = new InVariableTableItemWrapper(this.parentPropertySection, this.inVariablesTable, var, this.messageContainer);
            this.inVariablesTable.setSelection(wrapper.getTableItem());
            wrapper.editCell(1);
        }
        for (String key : this.messageContainer.getCompositeKeys().keySet()) {
            wrapper = new InVariableTableItemWrapper(this.parentPropertySection, this.inVariablesTable, key, this.messageContainer);
            this.inVariablesTable.setSelection(wrapper.getTableItem());
            wrapper.editCell(1);
        }
    }

    protected void initializeOutTableColumns() {
        TableLayout layout = (TableLayout)this.outVariablesTable.getLayout();
        TableColumn dummyColumn = new TableColumn(this.outVariablesTable, 0x1000000);
        dummyColumn.setText("");
        ColumnWeightData dummyColumnData = new ColumnWeightData(0);
        layout.addColumnData((ColumnLayoutData)dummyColumnData);
        TableColumn nameColumn = new TableColumn(this.outVariablesTable, 16384);
        nameColumn.setText(this.outColumnTitles[0]);
        nameColumn.pack();
        ColumnWeightData nameColumnData = new ColumnWeightData(15);
        layout.addColumnData((ColumnLayoutData)nameColumnData);
        TableColumn attachmemtColumn = new TableColumn(this.outVariablesTable, 16384);
        attachmemtColumn.setText(this.outColumnTitles[1]);
        attachmemtColumn.setAlignment(0x1000000);
        attachmemtColumn.pack();
        ColumnWeightData attachmentColumnData = new ColumnWeightData(9);
        layout.addColumnData((ColumnLayoutData)attachmentColumnData);
        TableColumn valueColumn = new TableColumn(this.outVariablesTable, 0x1000000);
        valueColumn.setText(this.outColumnTitles[2]);
        valueColumn.pack();
        ColumnWeightData valueColumnData = new ColumnWeightData(12);
        layout.addColumnData((ColumnLayoutData)valueColumnData);
        TableColumn processVarColumn = new TableColumn(this.outVariablesTable, 0x1000000);
        processVarColumn.setText(this.outColumnTitles[3]);
        processVarColumn.pack();
        ColumnWeightData processVarColumnData = new ColumnWeightData(12);
        layout.addColumnData((ColumnLayoutData)processVarColumnData);
    }

    protected void initializeInTableColumns() {
        TableLayout layout = (TableLayout)this.inVariablesTable.getLayout();
        TableColumn dummyColumn = new TableColumn(this.inVariablesTable, 0x1000000);
        dummyColumn.setText("");
        ColumnWeightData dummyColumnData = new ColumnWeightData(0);
        layout.addColumnData((ColumnLayoutData)dummyColumnData);
        TableColumn nameColumn = new TableColumn(this.inVariablesTable, 16384);
        nameColumn.setText(this.inColumnTitles[0]);
        nameColumn.pack();
        ColumnWeightData nameColumnData = new ColumnWeightData(14);
        layout.addColumnData((ColumnLayoutData)nameColumnData);
        TableColumn processVarColumn = new TableColumn(this.inVariablesTable, 0x1000000);
        processVarColumn.setText(this.inColumnTitles[1]);
        processVarColumn.pack();
        ColumnWeightData processVarColumnData = new ColumnWeightData(14);
        layout.addColumnData((ColumnLayoutData)processVarColumnData);
        TableColumn compositeKeyColumn = new TableColumn(this.inVariablesTable, 0x1000000);
        compositeKeyColumn.setText(this.inColumnTitles[2]);
        compositeKeyColumn.pack();
        ColumnWeightData compositeKeyColumnData = new ColumnWeightData(6);
        layout.addColumnData((ColumnLayoutData)compositeKeyColumnData);
    }
}

