/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.model.IHumanResourceTypeElement;
import com.tandbergtv.watchpoint.studio.ui.model.IResourceTypeElement;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ResourceGroupElementConfigurationComposite
implements SelectionListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private CCombo resourceGroupCombo;
    private Label resourceGroupLabel;
    private IResourceTypeElement resourceTypeElement;
    private com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup resourceGroup;

    private ResourceGroupElementConfigurationComposite() {
    }

    public static ResourceGroupElementConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        ResourceGroupElementConfigurationComposite result = new ResourceGroupElementConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    public void setResourceGroupElement(IResourceTypeElement resourceTypeElement) {
        this.resourceTypeElement = resourceTypeElement;
        if (this.resourceTypeElement instanceof NodeDefinition) {
            if (((NodeDefinition)this.resourceTypeElement).getNode() == null) {
                this.resourceGroupCombo.setEnabled(false);
            } else {
                this.resourceGroupCombo.setEnabled(true);
            }
        }
        this.unhookSelectionListener();
        if (resourceTypeElement != null) {
            this.updateControls();
            this.hookSelectionListener();
            this.fillResourceGroupCombo();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.resourceGroupCombo) {
            if (this.resourceGroup == null) {
                this.resourceGroup = (com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup)this.resourceTypeElement.getFactory().createById("com.tandbergtv.watchpoint.studio.resourceGroup");
            }
            this.resourceGroup.setName(this.resourceGroupCombo.getItem(this.resourceGroupCombo.getSelectionIndex()));
            this.resourceTypeElement.setResourceGroup(this.resourceGroup);
        }
    }

    private void hookSelectionListener() {
        this.resourceGroupCombo.addSelectionListener((SelectionListener)this);
    }

    private void unhookSelectionListener() {
        this.resourceGroupCombo.removeSelectionListener((SelectionListener)this);
    }

    private void updateControls() {
        this.resourceGroup = this.resourceTypeElement.getResourceGroup();
    }

    private void create() {
        String defName;
        Composite composite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.resourceGroupLabel = new Label(composite, 0);
        this.resourceGroupLabel.setText("Resource Group");
        this.resourceGroupLabel.setLayoutData((Object)this.createResourceGroupLabelLayoutData());
        this.resourceGroupLabel.setBackground(ColorConstants.white);
        this.resourceGroupLabel.pack();
        this.resourceGroupCombo = this.widgetFactory.createCCombo(composite, 780);
        this.resourceGroupCombo.setLayoutData((Object)this.createResourceGroupComboLayoutData());
        if (this.resourceTypeElement instanceof NodeDefinition && ((defName = ((NodeDefinition)this.resourceTypeElement).getDefinitionName()) == null || defName.trim().length() == 0)) {
            this.resourceGroupCombo.setEnabled(false);
        }
        this.resourceGroupCombo.pack();
    }

    private FormData createResourceGroupLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, -6);
        data.top = new FormAttachment(0, 2);
        return data;
    }

    private FormData createResourceGroupComboLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 79);
        data.top = new FormAttachment(0, 0);
        data.width = 200;
        return data;
    }

    private void fillResourceGroupCombo() {
        this.resourceGroupCombo.removeAll();
        List<ResourceGroup> groups = null;
        groups = this.resourceTypeElement instanceof IHumanResourceTypeElement ? ServiceFactory.createFactory().createResourceGroupService().getResourceGroupsByHumanResourceType() : ServiceFactory.createFactory().createResourceGroupService().getResourceGroupsByResourceType(this.resourceTypeElement.getResourceType());
        int index = 0;
        for (ResourceGroup group : groups) {
            this.resourceGroupCombo.add(group.getName());
            if (this.resourceTypeElement.getResourceGroup() != null && group.getName().equals(this.resourceTypeElement.getResourceGroup().getName())) {
                this.resourceGroupCombo.select(index);
            }
            ++index;
        }
    }
}

