/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.model.IResourceTypeElement;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ResourceTypeElementConfigurationComposite {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Text resourceTypeText;
    private Label resourceTypeLabel;
    private IResourceTypeElement resourceTypeElement;

    private ResourceTypeElementConfigurationComposite() {
    }

    public static ResourceTypeElementConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        ResourceTypeElementConfigurationComposite result = new ResourceTypeElementConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    public void setResourceTypeElement(IResourceTypeElement resourceTypeElement) {
        this.resourceTypeElement = resourceTypeElement;
        if (resourceTypeElement.getResourceType() > 0L) {
            this.resourceTypeText.setText(this.getResourceType(resourceTypeElement.getResourceType()));
        }
    }

    private void create() {
        String defName;
        Composite composite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.resourceTypeLabel = new Label(composite, 0);
        this.resourceTypeLabel.setText("Resource Type");
        this.resourceTypeLabel.setLayoutData((Object)this.createResourceTypeLabelLayoutData());
        this.resourceTypeLabel.setBackground(ColorConstants.white);
        this.resourceTypeLabel.pack();
        this.resourceTypeText = this.widgetFactory.createText(composite, "");
        this.resourceTypeText.setLayoutData((Object)this.createResourceTypeTextLayoutData());
        if (this.resourceTypeElement instanceof NodeDefinition && ((defName = ((NodeDefinition)this.resourceTypeElement).getDefinitionName()) == null || defName.trim().length() == 0)) {
            this.resourceTypeText.setEnabled(false);
        }
        this.resourceTypeText.setEnabled(false);
        this.resourceTypeText.pack();
    }

    private FormData createResourceTypeLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, -6);
        data.top = new FormAttachment(0, 2);
        return data;
    }

    private FormData createResourceTypeTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 79);
        data.top = new FormAttachment(0, 0);
        data.width = 180;
        return data;
    }

    private String getResourceType(long id) {
        return ServiceFactory.createFactory().createResourceTypeService().getResourceType(id).getName();
    }
}

