/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionClassConfiguration;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionConfigurationManager;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionVariableConfiguration;
import com.tandbergtv.watchpoint.studio.ui.model.AbstractTaskNode;
import com.tandbergtv.watchpoint.studio.ui.properties.template.ArgumentTableItemWrapper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.util.AutoResizeTableLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskNodeActionElementComposite
implements SelectionListener,
FocusListener {
    private AbstractTaskNode taskNode;
    private Composite parent;
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Label classNameLabel;
    private Label argumentsLabel;
    private CCombo classNameCombo;
    private Table argumentsTable;
    private Button addButton;
    private Button removeButton;
    private Map<String, String> arguments;
    private static final String DEFAULT_CLASS_NAME = "";
    private static final String CLASS_NAME_LABEL = "Class Name: ";
    private static final String ARGUMENTS_LABEL = "Arguments: ";
    private static final String[] COLUMN_TITLES = new String[]{"Name", "Value"};

    public TaskNodeActionElementComposite(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        this.parent = parent;
        this.widgetFactory = widgetFactory;
        this.createControls();
    }

    private void createControls() {
        this.arguments = new LinkedHashMap<String, String>();
        this.create();
        this.initializeArgumentsTable();
    }

    private void create() {
        Composite composite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.classNameLabel = new Label(composite, 0);
        this.classNameLabel.setText(CLASS_NAME_LABEL);
        this.classNameLabel.setLayoutData((Object)this.createClassLabelLayoutData());
        this.classNameLabel.setBackground(ColorConstants.white);
        this.classNameLabel.pack();
        this.classNameCombo = this.widgetFactory.createCCombo(this.parent, 4);
        this.classNameCombo.setLayoutData((Object)this.createClassNameLayoutData(0, 85, 320));
        this.classNameCombo.setItems(this.getConfiguredClassNames());
        this.classNameCombo.add(DEFAULT_CLASS_NAME, 0);
        this.classNameCombo.setEditable(true);
        this.classNameCombo.addFocusListener((FocusListener)this);
        this.classNameCombo.pack();
        this.argumentsLabel = new Label(composite, 0);
        this.argumentsLabel.setText(ARGUMENTS_LABEL);
        this.argumentsLabel.setLayoutData((Object)this.createArgumentLabelLayoutData());
        this.argumentsLabel.setBackground(ColorConstants.white);
        this.argumentsLabel.pack();
        this.argumentsTable = this.widgetFactory.createTable(this.parent, 66304);
        this.argumentsTable.setLayoutData((Object)this.createArgumentsTableLayoutData());
        this.argumentsTable.addSelectionListener((SelectionListener)this);
        this.argumentsTable.pack();
        this.addButton = this.widgetFactory.createButton(this.parent, "Add", 8);
        this.removeButton = this.widgetFactory.createButton(this.parent, "Remove", 8);
        this.addButton.setLayoutData((Object)this.createAddButtonLayoutData());
        this.addButton.addSelectionListener((SelectionListener)this);
        this.removeButton.setLayoutData((Object)this.createRemoveButtonLayoutData());
        this.removeButton.addSelectionListener((SelectionListener)this);
    }

    public void setTaskNode(AbstractTaskNode taskNode) {
        if (this.taskNode == taskNode) {
            return;
        }
        this.unhookListeners();
        this.clearControls();
        this.taskNode = taskNode;
        if (this.taskNode != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    public AbstractTaskNode getTaskNode() {
        return this.taskNode;
    }

    private Action getAction() {
        return this.taskNode != null ? this.taskNode.getAction() : null;
    }

    private void hookListeners() {
        this.classNameCombo.addSelectionListener((SelectionListener)this);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.argumentsTable.addSelectionListener((SelectionListener)this);
    }

    private void unhookListeners() {
        this.classNameCombo.removeSelectionListener((SelectionListener)this);
        this.removeButton.removeSelectionListener((SelectionListener)this);
        this.argumentsTable.removeSelectionListener((SelectionListener)this);
    }

    private void updateControls() {
        Action action = this.taskNode.getAction();
        if (action != null) {
            if (action.getClassName() != null) {
                this.classNameCombo.setText(action.getClassName());
            }
            GenericElement[] genericElements = action.getGenericElements();
            this.arguments = new LinkedHashMap<String, String>();
            GenericElement[] genericElementArray = genericElements;
            int n = genericElements.length;
            int n2 = 0;
            while (n2 < n) {
                GenericElement genericElement = genericElementArray[n2];
                this.arguments.put(genericElement.getName(), genericElement.getValue());
                ++n2;
            }
            List<ActionVariableConfiguration> args = this.getArgumentNames(action.getClassName());
            if (args != null && args.size() > 0) {
                this.refreshTable(false);
                this.setAddButtonEnable(false);
                this.setRemoveButtonEnable(false);
            } else {
                this.refreshTable(true);
                this.setAddButtonEnable(true);
            }
        } else {
            action = this.createAction();
            this.taskNode.setAction(action);
        }
    }

    private void clearControls() {
        this.argumentsTable.removeAll();
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    private void refreshTable(boolean isEditable) {
        this.argumentsTable.removeAll();
        this.removeAllGenericElements();
        Set<String> keys = this.arguments.keySet();
        if (keys != null) {
            for (String key : keys) {
                GenericElement genericElement = this.createGenericElement();
                genericElement.setName(key);
                genericElement.setValue(this.arguments.get(key));
                new ArgumentTableItemWrapper(this, this.argumentsTable, genericElement, isEditable);
                this.addGenericElement(genericElement);
            }
        }
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.classNameCombo) {
            Action action = this.getAction();
            if (action != null) {
                if (this.isConfiguredClassName(action.getClassName())) {
                    this.handleClassNameComboSelected();
                } else {
                    this.setAddButtonEnable(true);
                }
            }
            this.updateClassNameText();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    private void updateClassNameText() {
        Action action = this.getAction();
        if (action != null) {
            action.setClassName(this.classNameCombo.getText());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.classNameCombo) {
            this.handleClassNameComboSelected();
        } else if (e.widget == this.addButton) {
            this.handleAddButtonSelected();
        } else if (e.widget == this.removeButton) {
            this.handleRemoveButtonSelected();
        } else {
            Widget cfr_ignored_0 = e.widget;
        }
    }

    public void setRemoveButtonEnable(boolean enable) {
        this.removeButton.setEnabled(enable);
    }

    public void setAddButtonEnable(boolean enable) {
        this.addButton.setEnabled(enable);
    }

    private void handleClassNameComboSelected() {
        String selection = this.classNameCombo.getText();
        Action action = this.getAction();
        if (this.getAction() != null) {
            action.setClassName(selection);
        } else {
            action = this.createAction();
            this.taskNode.setAction(action);
            this.getAction().setClassName(selection);
        }
        this.arguments = new LinkedHashMap<String, String>();
        List<ActionVariableConfiguration> args = this.getArgumentNames(selection);
        if (this.isConfiguredClassName(selection)) {
            for (ActionVariableConfiguration argument : args) {
                this.arguments.put(argument.getName(), DEFAULT_CLASS_NAME);
            }
            this.refreshTable(false);
            this.setAddButtonEnable(false);
            this.setRemoveButtonEnable(false);
        } else {
            this.refreshTable(true);
            this.setAddButtonEnable(true);
        }
    }

    private void initializeTableColumns() {
        TableLayout layout = (TableLayout)this.argumentsTable.getLayout();
        TableColumn nameColumn = new TableColumn(this.argumentsTable, 16384);
        nameColumn.setText(COLUMN_TITLES[0]);
        nameColumn.pack();
        ColumnWeightData nameColumnData = new ColumnWeightData(5);
        layout.addColumnData((ColumnLayoutData)nameColumnData);
        TableColumn valueColumn = new TableColumn(this.argumentsTable, 16384);
        valueColumn.setText(COLUMN_TITLES[1]);
        valueColumn.setAlignment(0x1000000);
        valueColumn.pack();
        ColumnWeightData valueColumnData = new ColumnWeightData(5);
        layout.addColumnData((ColumnLayoutData)valueColumnData);
    }

    private void initializeArgumentsTable() {
        this.argumentsTable.setHeaderVisible(true);
        this.argumentsTable.setLinesVisible(true);
        this.argumentsTable.setLayout((Layout)new AutoResizeTableLayout(this.argumentsTable));
        this.initializeTableColumns();
        this.argumentsTable.pack();
    }

    private FormData createClassLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        return data;
    }

    private FormData createArgumentLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.classNameLabel, 0);
        return data;
    }

    private FormData createClassNameLayoutData(int x, int y, int z) {
        FormData data = new FormData();
        data.left = new FormAttachment(x, y);
        data.top = new FormAttachment(0, 0);
        data.width = z;
        return data;
    }

    private FormData createArgumentsTableLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.top = new FormAttachment((Control)this.classNameCombo, 2);
        data.width = 400;
        data.height = 100;
        return data;
    }

    private FormData createAddButtonLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.argumentsTable, 0);
        result.top.alignment = 128;
        result.left = new FormAttachment((Control)this.removeButton, 0);
        result.left.alignment = 16384;
        result.right = new FormAttachment(75, -5);
        return result;
    }

    private FormData createRemoveButtonLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.addButton, 5);
        result.left = new FormAttachment((Control)this.argumentsTable, 5);
        result.right = new FormAttachment(75, -5);
        return result;
    }

    private void handleAddButtonSelected() {
        int counter = 1;
        String name = "Name" + counter;
        while (this.arguments.containsKey(name)) {
            name = "Name" + ++counter;
        }
        String value = "Value" + counter;
        GenericElement genericElement = this.createGenericElement();
        genericElement.setName(name);
        genericElement.setValue(value);
        this.arguments.put(name, value);
        ArgumentTableItemWrapper wrapper = new ArgumentTableItemWrapper(this, this.argumentsTable, genericElement, true);
        this.argumentsTable.setSelection(wrapper.getTableItem());
        this.removeButton.setEnabled(this.argumentsTable.getSelectionIndex() != -1);
        this.addGenericElement(genericElement);
    }

    private void handleRemoveButtonSelected() {
        TableItem item = this.argumentsTable.getItem(this.argumentsTable.getSelectionIndex());
        ArgumentTableItemWrapper wrapper = (ArgumentTableItemWrapper)item.getData();
        this.arguments.remove(wrapper.getArgumentName());
        this.removeGenericElement(wrapper.getArgumentName(), wrapper.getArgumentValue());
        this.refreshTable(true);
        this.removeButton.setEnabled(this.argumentsTable.getSelectionIndex() != -1);
    }

    private String[] getConfiguredClassNames() {
        ActionConfigurationManager manager = ActionConfigurationManager.getInstance();
        List<ActionClassConfiguration> classes = manager.getAllActionClasses();
        int classCount = classes != null ? classes.size() : 0;
        String[] classNames = new String[classCount];
        int i = 0;
        while (i < classCount) {
            classNames[i] = classes.get(i).getClassName();
            ++i;
        }
        return classNames;
    }

    private boolean isConfiguredClassName(String className) {
        return ActionConfigurationManager.getInstance().getActionClass(className) != null;
    }

    private List<ActionVariableConfiguration> getArgumentNames(String className) {
        ActionConfigurationManager manager = ActionConfigurationManager.getInstance();
        ActionClassConfiguration actionClass = manager.getActionClass(className);
        if (actionClass != null) {
            return actionClass.getVariables();
        }
        return null;
    }

    private void addGenericElement(GenericElement genericElement) {
        Action action = this.getAction();
        if (action != null) {
            action.addGenericElement(genericElement);
        }
    }

    private void removeGenericElement(String argName, String argValue) {
        Action action = this.getAction();
        if (action != null) {
            GenericElement[] genericElements;
            GenericElement[] genericElementArray = genericElements = action.getGenericElements();
            int n = genericElements.length;
            int n2 = 0;
            while (n2 < n) {
                GenericElement genericElement = genericElementArray[n2];
                if (argName != null && argName.equals(genericElement.getName())) {
                    action.removeGenericElement(genericElement);
                }
                ++n2;
            }
        }
    }

    private void removeAllGenericElements() {
        Action action = this.getAction();
        if (action != null) {
            GenericElement[] genericElements;
            GenericElement[] genericElementArray = genericElements = action.getGenericElements();
            int n = genericElements.length;
            int n2 = 0;
            while (n2 < n) {
                GenericElement genericElement = genericElementArray[n2];
                action.removeGenericElement(genericElement);
                ++n2;
            }
        }
    }

    private GenericElement createGenericElement() {
        return (GenericElement)this.taskNode.getFactory().createById("org.jbpm.gd.jpdl.genericElement");
    }

    private Action createAction() {
        return (Action)this.taskNode.getFactory().createById("org.jbpm.gd.jpdl.action");
    }
}

