/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.util.ValidationMessages;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.NodeElementContainer;

public class WPDecisionConfigurationComposite
implements FocusListener,
KeyListener,
IContentProposalListener {
    private static final String EXPRESSION_LABEL = "Expression";
    private static final Logger logger = Logger.getLogger(WPDecisionConfigurationComposite.class);
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Decision decision;
    private Composite expressionComposite;
    private Label expressionLabel;
    private Text expressionText;
    private String keyPressedValue = "";
    private ContentProposalAdapter adapter;
    private AbstractPropertySection parentPropertySection;

    public static WPDecisionConfigurationComposite create(AbstractPropertySection parentSection, TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        WPDecisionConfigurationComposite result = new WPDecisionConfigurationComposite();
        result.parentPropertySection = parentSection;
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    public void setDecision(Decision decision) {
        if (this.decision == decision) {
            return;
        }
        this.unhookListeners();
        this.clearControls();
        this.decision = decision;
        if (decision != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.expressionText.addFocusListener((FocusListener)this);
        this.expressionText.addKeyListener((KeyListener)this);
        this.adapter.addContentProposalListener((IContentProposalListener)this);
    }

    private void unhookListeners() {
        this.expressionText.removeFocusListener((FocusListener)this);
        this.expressionText.removeKeyListener((KeyListener)this);
        this.adapter.removeContentProposalListener((IContentProposalListener)this);
    }

    private void clearControls() {
        this.expressionText.setText("");
    }

    private void updateControls() {
        if (this.decision.getExpression() == null) {
            this.expressionText.setText("");
        } else {
            this.expressionText.setText(this.decision.getExpression());
        }
    }

    private void create() {
        this.createExpression();
        this.adapter = this.createAdapter(this.expressionText, this.getTextProposals(), true);
        this.initializeLayouts();
    }

    private void createExpression() {
        this.expressionComposite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.expressionLabel = this.widgetFactory.createLabel(this.expressionComposite, EXPRESSION_LABEL);
        this.expressionText = this.widgetFactory.createText(this.expressionComposite, "");
    }

    private void initializeLayouts() {
        this.expressionComposite.setLayoutData((Object)this.createExpressionCompositeLayoutData());
        this.expressionLabel.setLayoutData((Object)this.createExpressionLabelLayoutData());
        this.expressionText.setLayoutData((Object)this.createExpressionTextLayoutData());
    }

    private FormData createExpressionLabelLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 0);
        result.left = new FormAttachment(0, 0);
        return result;
    }

    private FormData createExpressionTextLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 0);
        result.left = new FormAttachment((Control)this.expressionLabel, 0);
        result.right = new FormAttachment(100, 0);
        return result;
    }

    private FormData createExpressionCompositeLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(10, 0);
        result.left = new FormAttachment(0, 0);
        result.right = new FormAttachment(100, 0);
        return result;
    }

    private void updateExpressionText() {
        if (this.expressionText.getText().trim().length() == 0) {
            this.decision.setExpression(null);
            return;
        }
        this.decision.setExpression(this.expressionText.getText());
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.expressionText) {
            this.updateExpressionText();
            if (Utility.getNodeElementContainer(this.parentPropertySection.getPart()) != null) {
                this.validate();
            }
        }
    }

    public void focusGained(FocusEvent e) {
        this.adapter.setEnabled(true);
    }

    private ContentProposalAdapter createAdapter(Text text, String[] proposals, boolean propogate) {
        char[] autoActivationCharacters = new char[]{};
        KeyStroke keyStroke = null;
        try {
            keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
        }
        catch (ParseException e1) {
            logger.error((Object)"Error occured while Creating instance of KeyStroke", (Throwable)e1);
            throw new UIException("Error occured while Creating instance of KeyStroke");
        }
        SimpleContentProposalProvider scp = new SimpleContentProposalProvider(proposals);
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)scp, keyStroke, autoActivationCharacters);
        adapter.setProposalAcceptanceStyle(1);
        adapter.setFilterStyle(3);
        adapter.setPropagateKeys(propogate);
        adapter.setEnabled(false);
        return adapter;
    }

    private String[] getTextProposals() {
        List<WPVariable> variables = Utility.getVariables(Utility.getNodeElementContainer(this.parentPropertySection.getPart()));
        HashSet<String> variableNames = new HashSet<String>();
        for (WPVariable variable : variables) {
            String name = variable.getName();
            if (name == null || name.trim().length() <= 0) continue;
            variableNames.add(variable.getName());
        }
        String[] proposals = variableNames.toArray(new String[variableNames.size()]);
        return proposals;
    }

    private void validate() {
        ValidationServiceFactory serviceFactory = ValidationServiceFactory.createFactory();
        IValidationService validationService = serviceFactory.createValidationService();
        NodeElementContainer container = Utility.getNodeElementContainer(this.parentPropertySection.getPart());
        List<ValidationMessage> messages = null;
        if (container instanceof WorkflowTemplate) {
            messages = validationService.validateDecisionExpression(this.decision, (WorkflowTemplate)container);
        } else if (container instanceof NodeDefinition) {
            messages = validationService.validateDecisionExpression(this.decision, (NodeDefinition)container);
        }
        if (messages != null && messages.size() > 0) {
            try {
                String msg = ValidationMessages.getInstance().getMessage(messages.get(0));
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error in Decision Expression", (String)msg);
            }
            catch (InvalidPropertiesFormatException e1) {
                logger.error((Object)"Error occured while opening the Message Dialog", (Throwable)e1);
                throw new UIException("Error occured while opening the Message Dialog");
            }
            catch (IOException e1) {
                logger.error((Object)"Error occured while opening the Message Dialog", (Throwable)e1);
                throw new UIException("Error occured while opening the Message Dialog");
            }
        }
    }

    public void keyPressed(KeyEvent arg0) {
        if (arg0.character == '\u0000') {
            this.keyPressedValue = this.getFilter();
        } else if (arg0.character == '\b' && this.keyPressedValue.length() > 0) {
            this.keyPressedValue = this.keyPressedValue.substring(0, this.keyPressedValue.length() - 1);
        } else if (Character.isLetterOrDigit(arg0.character)) {
            this.keyPressedValue = String.valueOf(this.keyPressedValue) + arg0.character;
        }
        SimpleContentProposalProvider scp = new SimpleContentProposalProvider(this.filterProposals(this.keyPressedValue));
        this.adapter.setContentProposalProvider((IContentProposalProvider)scp);
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void proposalAccepted(IContentProposal arg0) {
        String textValue = this.expressionText.getText();
        String tempValue = String.valueOf(this.keyPressedValue) + arg0.getContent();
        int index = textValue.lastIndexOf(tempValue);
        int cursorPosition = this.expressionText.getCaretPosition();
        StringBuffer newTextValue = new StringBuffer();
        if (index != -1) {
            newTextValue.append(textValue.substring(0, cursorPosition - tempValue.length()));
            newTextValue.append(arg0.getContent());
            newTextValue.append(textValue.substring(cursorPosition));
        } else {
            newTextValue.append(textValue);
            newTextValue.append(arg0.getContent());
        }
        this.expressionText.setText(newTextValue.toString());
        this.expressionText.setSelection(cursorPosition);
        this.keyPressedValue = "";
    }

    private String[] filterProposals(String filter) {
        ArrayList<String> filterProposals = new ArrayList<String>();
        String[] stringArray = this.getTextProposals();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String proposal = stringArray[n2];
            if (proposal.startsWith(filter)) {
                filterProposals.add(proposal);
            }
            ++n2;
        }
        return filterProposals.toArray(new String[filterProposals.size()]);
    }

    private String getFilter() {
        String str = this.expressionText.getText();
        int cursorPosition = this.expressionText.getCaretPosition();
        StringBuffer filterString = new StringBuffer();
        int i = cursorPosition;
        while (i > 0) {
            char c = str.charAt(i - 1);
            if (c == ' ' || c == '|' || c == '&' || c == '=' || c == '(') break;
            filterString.insert(0, c);
            --i;
        }
        return filterString.toString();
    }
}

