/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.WatchPointTemplateEditor;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.common.model.NamedElement;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.jpdl.model.NodeElement;

public class WPNamedElementComposite
implements FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite wrappedComposite;
    private Label nameLabel;
    private Text nameText;
    private NamedElement namedElement;
    private AbstractPropertySection parentPropertySection;

    public WPNamedElementComposite(AbstractPropertySection parentSection, Composite composite, TabbedPropertySheetWidgetFactory toolkit) {
        this.parentPropertySection = parentSection;
        this.wrappedComposite = composite;
        this.widgetFactory = toolkit;
        this.initialize();
    }

    private void initialize() {
        this.nameLabel = this.widgetFactory.createLabel(this.wrappedComposite, "Name");
        this.nameText = this.widgetFactory.createText(this.wrappedComposite, "");
        FormData data = null;
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 2);
        this.nameLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.top = new FormAttachment(0, 0);
        data.width = 300;
        this.nameText.setLayoutData((Object)data);
    }

    public void setNamedElement(NamedElement namedElement) {
        this.unhookListeners();
        this.clearControls();
        this.namedElement = namedElement;
        if (namedElement != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.nameText.addFocusListener((FocusListener)this);
    }

    private void unhookListeners() {
        this.nameText.removeFocusListener((FocusListener)this);
    }

    private void clearControls() {
        this.nameText.setText("");
        this.nameText.setEnabled(true);
        this.nameText.setTextLimit(Text.LIMIT);
    }

    private void updateControls() {
        String name = this.namedElement.getName();
        this.nameText.setText(name == null ? "" : name);
        boolean enabled = true;
        int textLimit = Text.LIMIT;
        IWorkbenchPart part = this.parentPropertySection.getPart();
        if (this.namedElement instanceof WorkflowTemplate) {
            enabled = false;
            textLimit = 50;
        } else if (part instanceof NodeDefinitionEditor && this.isReadOnlyNamedElement((NodeDefinitionEditor)part)) {
            enabled = false;
            textLimit = 50;
        }
        this.nameText.setEnabled(enabled);
        this.nameText.setTextLimit(textLimit);
    }

    private String getNameText() {
        String text = this.nameText.getText();
        if ("".equals(text) && !this.namedElement.isNameMandatory()) {
            text = null;
        }
        return text;
    }

    private boolean isReadOnlyNamedElement(NodeDefinitionEditor editor) {
        boolean isSingleNode;
        NodeDefinition rootElement = editor.getNodeDefinition();
        if (rootElement == null) {
            return false;
        }
        NodeDefinitionType nodeType = rootElement.getNodeType();
        boolean isRootElement = rootElement == this.namedElement;
        boolean bl = isSingleNode = nodeType == NodeDefinitionType.SingleNode && rootElement.getNode() == this.namedElement;
        return isRootElement || isSingleNode;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.nameText) {
            if (this.namedElement == null) {
                return;
            }
            String value = this.nameText.getText().trim();
            if (this.namedElement.isNameMandatory() && "".equals(value)) {
                Shell shell = Display.getCurrent().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"The name cannot be blank.");
                this.nameText.setText(this.namedElement.getName());
                return;
            }
            if (this.namedElement instanceof NodeElement) {
                IWorkbenchPart part = this.parentPropertySection.getPart();
                SemanticElement container = null;
                if (part instanceof WatchPointTemplateEditor) {
                    container = ((WatchPointTemplateEditor)part).getProcessDefinition();
                } else if (part instanceof NodeDefinitionEditor) {
                    container = ((NodeDefinitionEditor)part).getNodeDefinition();
                }
                if (container.getNodeElementByName(value) != null && container.getNodeElementByName(value) != this.namedElement) {
                    Shell shell = Display.getCurrent().getActiveShell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)("There is already a node named " + value + "."));
                    this.nameText.setText(this.namedElement.getName());
                    return;
                }
            }
            if (!value.equals(this.nameText.getText())) {
                this.nameText.setText(value);
            }
            this.namedElement.setName(this.getNameText());
        }
    }
}

