/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractVariableTableItemWrapper;
import com.tandbergtv.watchpoint.studio.ui.properties.DataType;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.Variable;

public class WPVariableTableItemWrapper
extends AbstractVariableTableItemWrapper
implements DisposeListener,
SelectionListener {
    private Button keyButton;
    private Button requiredButton;
    private Button showInUIButton;
    private Button reportingRoleButton;
    private Button readButton;
    private Button writeButton;
    private CCombo typeCombo;
    private CCombo processNameCombo;
    private Text processNameText;
    private Table table;
    private AbstractPropertySection parentPropertySection;

    public WPVariableTableItemWrapper(AbstractPropertySection parentSection, Table table, Variable variable) {
        super(table, variable);
        this.parentPropertySection = parentSection;
        this.mappedNameText.setEditable(true);
        this.table = table;
        this.tableItem.setText(2, this.getName());
        if (table.getColumnCount() == 8) {
            this.initializeNameText(table);
            this.initializeRequiredButton(table);
            this.initializeTypeCombo(table);
            this.initializeKeyButton(table);
            this.initializeShowInUIButton(table);
            this.initializeReportingRoleButton(table);
        } else {
            this.initializeProcessNameCombo(table);
            this.initializeRequiredButton(table);
            this.initializeTypeCombo(table);
            this.initializeReadButton(table);
            this.initializeWriteButton(table);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        super.widgetDisposed(e);
        this.tableItem.removeDisposeListener((DisposeListener)this);
        this.requiredButton.removeSelectionListener((SelectionListener)this);
        this.requiredButton.dispose();
        this.typeCombo.removeSelectionListener((SelectionListener)this);
        this.typeCombo.dispose();
        if (this.keyButton != null) {
            this.keyButton.removeSelectionListener((SelectionListener)this);
            if (!this.keyButton.isDisposed()) {
                this.keyButton.dispose();
            }
        }
        if (this.showInUIButton != null) {
            this.showInUIButton.removeSelectionListener((SelectionListener)this);
            if (!this.showInUIButton.isDisposed()) {
                this.showInUIButton.dispose();
            }
        }
        if (this.reportingRoleButton != null) {
            this.reportingRoleButton.removeSelectionListener((SelectionListener)this);
            if (!this.reportingRoleButton.isDisposed()) {
                this.reportingRoleButton.dispose();
            }
        }
        if (this.readButton != null) {
            this.readButton.removeSelectionListener((SelectionListener)this);
            if (!this.readButton.isDisposed()) {
                this.readButton.dispose();
            }
        }
        if (this.writeButton != null) {
            this.writeButton.removeSelectionListener((SelectionListener)this);
            if (!this.writeButton.isDisposed()) {
                this.writeButton.dispose();
            }
        }
        if (this.processNameCombo != null && !this.processNameCombo.isDisposed()) {
            this.processNameCombo.removeSelectionListener((SelectionListener)this);
            this.processNameCombo.removeFocusListener((FocusListener)this);
            this.processNameCombo.dispose();
        }
        if (this.processNameText != null && !this.processNameText.isDisposed()) {
            this.processNameText.removeSelectionListener((SelectionListener)this);
            this.processNameText.removeFocusListener((FocusListener)this);
            this.processNameText.dispose();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.keyButton || e.widget == this.requiredButton || e.widget == this.showInUIButton || e.widget == this.reportingRoleButton || e.widget == this.readButton || e.widget == this.writeButton) {
            this.variable.setAccess(this.calculateAccessString());
        } else if (e.widget == this.typeCombo) {
            this.variable.setType(this.typeCombo.getText());
        } else if (e.widget == this.processNameCombo) {
            this.variable.setName(this.processNameCombo.getText());
            this.applyName();
        }
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.processNameText) {
            this.variable.setName(this.processNameText.getText());
            this.applyName();
        } else if (e.widget == this.mappedNameText) {
            this.variable.setMappedName(this.mappedNameText.getText());
            this.applyMappedName();
        }
    }

    public void editCell(int column) {
        super.editCell(column);
        if (column == 2) {
            this.editName();
        }
    }

    protected void cancelEditing() {
        this.applyMappedName();
        this.applyName();
    }

    private String getName() {
        return this.variable.getName() == null ? "" : this.variable.getName();
    }

    private String calculateAccessString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.table.getColumnCount() == 8) {
            stringBuffer.append("read,write,");
            if (this.keyButton.getSelection()) {
                stringBuffer.append("woKey,");
            }
            if (this.showInUIButton.getSelection()) {
                stringBuffer.append("showInUI,");
            }
            if (this.reportingRoleButton.getSelection()) {
                stringBuffer.append("reportingRole,");
            }
        } else {
            if (this.readButton.getSelection()) {
                stringBuffer.append("read,");
            }
            if (this.writeButton.getSelection()) {
                stringBuffer.append("write,");
            }
        }
        if (this.requiredButton.getSelection()) {
            stringBuffer.append("required ");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    protected void applyName() {
        if (this.processNameText != null) {
            this.processNameText.setVisible(false);
        }
        this.tableItem.setText(2, this.getName());
    }

    private void initializeNameText(Table table) {
        this.processNameText = this.createText(table, 2);
        this.processNameText.addSelectionListener((SelectionListener)this);
        this.processNameText.addFocusListener((FocusListener)this);
        this.processNameText.setText(this.getName());
        this.processNameText.pack();
    }

    private void initializeRequiredButton(Table table) {
        this.requiredButton = this.createButton(table, 3);
        this.requiredButton.addSelectionListener((SelectionListener)this);
        this.requiredButton.setSelection(this.variable.isRequired());
        this.requiredButton.pack();
    }

    private void initializeKeyButton(Table table) {
        this.keyButton = this.createButton(table, 5);
        this.keyButton.addSelectionListener((SelectionListener)this);
        this.keyButton.setSelection(this.variable.isWOKey());
        this.keyButton.pack();
    }

    private void initializeShowInUIButton(Table table) {
        this.showInUIButton = this.createButton(table, 6);
        this.showInUIButton.addSelectionListener((SelectionListener)this);
        this.showInUIButton.setSelection(this.variable.isUIVariable());
        this.showInUIButton.pack();
    }

    private void initializeReportingRoleButton(Table table) {
        this.reportingRoleButton = this.createButton(table, 7);
        this.reportingRoleButton.addSelectionListener((SelectionListener)this);
        this.reportingRoleButton.setSelection(this.variable.hasReportingRole());
        this.reportingRoleButton.pack();
    }

    private void initializeReadButton(Table table) {
        this.readButton = this.createButton(table, 5);
        this.readButton.addSelectionListener((SelectionListener)this);
        this.readButton.setSelection(this.variable.isReadable());
        this.readButton.pack();
    }

    private void initializeWriteButton(Table table) {
        this.writeButton = this.createButton(table, 6);
        this.writeButton.addSelectionListener((SelectionListener)this);
        this.writeButton.setSelection(this.variable.isWritable());
        this.writeButton.pack();
    }

    private void initializeTypeCombo(Table table) {
        this.typeCombo = this.createCombo(table, 4);
        this.typeCombo.addSelectionListener((SelectionListener)this);
        if (this.variable.getType() == null || this.variable.getType().equals("")) {
            this.variable.setType(DataType.STRING.toString());
        }
        int i = 0;
        while (i < DataType.values().length) {
            String type = DataType.values()[i].toString();
            this.typeCombo.add(type);
            ++i;
        }
        this.typeCombo.setText(this.variable.getType());
        this.typeCombo.pack();
    }

    private void initializeProcessNameCombo(Table table) {
        this.processNameCombo = this.createCombo(table, 2);
        this.processNameCombo.addSelectionListener((SelectionListener)this);
        this.processNameCombo.addFocusListener((FocusListener)this);
        this.fillVariableCombo();
        if (this.processNameCombo.getText().equals("") && this.variable.getName() != null) {
            this.processNameCombo.setText(this.variable.getName());
        }
    }

    private void editName() {
        this.mappedNameText.setVisible(false);
        this.processNameText.setVisible(true);
        this.processNameText.setText(this.getName());
        this.processNameText.selectAll();
        this.processNameText.setFocus();
    }

    private void fillVariableCombo() {
        WorkflowTemplate template = (WorkflowTemplate)Utility.getNodeElementContainer(this.parentPropertySection.getPart());
        StartState startState = template.getStartState();
        if (startState == null || startState.getTask() == null) {
            return;
        }
        Controller controller = startState.getTask().getController();
        int index = 0;
        Variable[] variableArray = controller.getVariables();
        int n = variableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variable var = variableArray[n2];
            if (var.getName() != null) {
                this.processNameCombo.add(var.getName());
                if (this.variable.getName() != null && this.variable.getName().equals(var.getName())) {
                    this.processNameCombo.select(index);
                }
                ++index;
            }
            ++n2;
        }
    }
}

