/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties.nodedefinition;

import com.tandbergtv.watchpoint.studio.ui.model.IMessageNodeContainer;
import com.tandbergtv.watchpoint.studio.ui.util.NameValuePair;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jbpm.gd.jpdl.util.AutoResizeTableLayout;

public class ConstantsComposite {
    private FormToolkit widgetFactory;
    private Composite parent;
    private Label containerLabel;
    private Table constantsTable;
    private IMessageNodeContainer messageNodeContainer;
    private String[] columnTitles = null;

    public static ConstantsComposite create(FormToolkit widgetFactory, Composite parent, String[] columnTitles) {
        ConstantsComposite result = new ConstantsComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.columnTitles = columnTitles;
        result.create();
        return result;
    }

    public static ConstantsComposite create(FormToolkit widgetFactory, Composite parent) {
        return ConstantsComposite.create(widgetFactory, parent, new String[]{"Name", "Value"});
    }

    private ConstantsComposite() {
    }

    public void setMessageNodeContainer(IMessageNodeContainer messageNodeContainer) {
        this.messageNodeContainer = messageNodeContainer;
        this.clearControls();
        if (messageNodeContainer != null) {
            this.updateControls();
        }
    }

    private void clearControls() {
        this.constantsTable.removeAll();
    }

    private void updateControls() {
        this.refreshTable();
    }

    private void create() {
        this.containerLabel = this.widgetFactory.createLabel(this.parent, "Constants :");
        this.constantsTable = this.widgetFactory.createTable(this.parent, 66304);
        this.containerLabel.setLayoutData((Object)this.createMessageLabelLayoutData());
        this.constantsTable.setLayoutData((Object)this.createConstantsTableLayoutData());
        this.initializeConstantsTable();
    }

    private void initializeConstantsTable() {
        this.constantsTable.setHeaderVisible(true);
        this.constantsTable.setLinesVisible(true);
        this.constantsTable.setLayout((Layout)new AutoResizeTableLayout(this.constantsTable));
        this.initializeConstantsTableColumns();
    }

    private void initializeConstantsTableColumns() {
        TableLayout layout = (TableLayout)this.constantsTable.getLayout();
        TableColumn nameColumn = new TableColumn(this.constantsTable, 16384);
        nameColumn.setText(this.columnTitles[0]);
        ColumnWeightData nameColumnData = new ColumnWeightData(15);
        nameColumnData.resizable = false;
        layout.addColumnData((ColumnLayoutData)nameColumnData);
        TableColumn valColumn = new TableColumn(this.constantsTable, 16384);
        valColumn.setText(this.columnTitles[1]);
        ColumnWeightData valColumnData = new ColumnWeightData(15);
        valColumnData.resizable = false;
        layout.addColumnData((ColumnLayoutData)valColumnData);
    }

    private FormData createMessageLabelLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 5);
        result.left = new FormAttachment(0, 5);
        result.right = new FormAttachment(100, -5);
        return result;
    }

    private FormData createConstantsTableLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.containerLabel, 5);
        result.left = new FormAttachment(0, 5);
        result.right = new FormAttachment(100, -10);
        return result;
    }

    private void refreshTable() {
        this.constantsTable.removeAll();
        for (NameValuePair pair : this.messageNodeContainer.getConstants()) {
            TableItem constantTableItem = new TableItem(this.constantsTable, 0);
            constantTableItem.setText(new String[]{pair.getName(), pair.getValue()});
        }
    }
}

