/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties.nodedefinition;

import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.WatchPointTemplateEditor;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageContainer;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageNodeContainer;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractVariableTableItemWrapper;
import com.tandbergtv.watchpoint.studio.ui.properties.DataType;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import java.util.Iterator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.Variable;

public class NodeDefinitionVariableTableItemWrapper
extends AbstractVariableTableItemWrapper {
    private Button keyButton;
    private Button attachmentButton;
    private CCombo typeCombo;
    private CCombo processNameCombo;
    private IMessageNodeContainer messageNodeContainer;
    private AbstractPropertySection parentPropertySection;
    private boolean required = false;

    public NodeDefinitionVariableTableItemWrapper(AbstractPropertySection parentSection, Table table, Variable variable, IMessageNodeContainer messageNodeContainer) {
        this(parentSection, table, variable, messageNodeContainer, false);
    }

    public NodeDefinitionVariableTableItemWrapper(AbstractPropertySection parentSection, Table table, Variable variable, IMessageNodeContainer messageNodeContainer, boolean isRequired) {
        super(table, variable);
        this.parentPropertySection = parentSection;
        this.messageNodeContainer = messageNodeContainer;
        this.required = isRequired;
        this.mappedNameText.setEditable(parentSection.getPart() instanceof NodeDefinitionEditor);
        this.tableItem.setText(2, this.getName());
        this.initializeProcessNameCombo(table);
        this.initializeAttachmentButton(table);
        this.initializeTypeCombo(table);
        this.initializeKeyButton(table);
    }

    public void widgetDisposed(DisposeEvent e) {
        super.widgetDisposed(e);
        this.tableItem.removeDisposeListener((DisposeListener)this);
        this.attachmentButton.removeSelectionListener((SelectionListener)this);
        this.attachmentButton.dispose();
        this.typeCombo.removeSelectionListener((SelectionListener)this);
        this.typeCombo.dispose();
        if (this.keyButton != null) {
            this.keyButton.removeSelectionListener((SelectionListener)this);
            if (!this.keyButton.isDisposed()) {
                this.keyButton.dispose();
            }
        }
        if (this.processNameCombo != null && !this.processNameCombo.isDisposed()) {
            this.processNameCombo.removeSelectionListener((SelectionListener)this);
            this.processNameCombo.removeFocusListener((FocusListener)this);
            this.processNameCombo.dispose();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.typeCombo) {
            this.variable.setType(this.typeCombo.getText());
        } else if (e.widget == this.processNameCombo) {
            if (this.messageNodeContainer.getCompositeKey(this.variable.getMappedName()) != null) {
                this.messageNodeContainer.setCompositeKey(this.variable.getMappedName(), this.processNameCombo.getText());
            }
            this.variable.setName(this.processNameCombo.getText());
        }
        if (e.widget == this.keyButton || e.widget == this.attachmentButton) {
            this.variable.setAccess(this.calculateAccessString());
        }
    }

    private String getName() {
        return this.variable.getName() == null ? "" : this.variable.getName();
    }

    protected String getMappedName() {
        String mappedName = super.getMappedName();
        if (mappedName != null && mappedName.trim().length() > 0 && this.required) {
            mappedName = String.valueOf(mappedName) + " *";
        }
        return mappedName;
    }

    private String calculateAccessString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("read,write,");
        if (this.keyButton.getSelection()) {
            stringBuffer.append(" compositeKey,");
        }
        if (this.attachmentButton.getSelection()) {
            stringBuffer.append("attachment ");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    private void initializeAttachmentButton(Table table) {
        this.attachmentButton = this.createButton(table, 3);
        this.attachmentButton.addSelectionListener((SelectionListener)this);
        this.attachmentButton.setSelection(this.isAttachment(this.variable.getMappedName()));
        this.attachmentButton.setEnabled(false);
        this.attachmentButton.pack();
    }

    private void initializeKeyButton(Table table) {
        this.keyButton = this.createButton(table, 5);
        this.keyButton.addSelectionListener((SelectionListener)this);
        this.keyButton.setSelection(this.isCompositeKey(this.variable.getMappedName()));
        this.keyButton.setEnabled(false);
        this.keyButton.pack();
    }

    private void initializeTypeCombo(Table table) {
        this.typeCombo = this.createCombo(table, 4);
        this.typeCombo.addSelectionListener((SelectionListener)this);
        if (this.parentPropertySection.getPart() instanceof WatchPointTemplateEditor) {
            this.typeCombo.setEnabled(false);
        } else {
            int i = 0;
            while (i < DataType.values().length) {
                this.typeCombo.add(DataType.values()[i].toString());
                ++i;
            }
        }
        if (this.variable.getType() != null) {
            this.typeCombo.setText(this.variable.getType());
        }
        this.typeCombo.pack();
    }

    private void initializeProcessNameCombo(Table table) {
        this.processNameCombo = this.createCombo(table, 2);
        this.processNameCombo.addSelectionListener((SelectionListener)this);
        this.processNameCombo.addFocusListener((FocusListener)this);
        NodeElementContainer container = Utility.getNodeElementContainer(this.parentPropertySection.getPart());
        if (container instanceof NodeDefinition) {
            this.processNameCombo.setEnabled(false);
        } else {
            this.fillVariableCombo();
        }
        if (this.processNameCombo.getText().equals("") && this.variable.getName() != null) {
            this.processNameCombo.setText(this.variable.getName());
        }
    }

    private void fillVariableCombo() {
        StartState startState;
        WorkflowTemplate template = (WorkflowTemplate)Utility.getNodeElementContainer(this.parentPropertySection.getPart());
        if (!this.required) {
            this.processNameCombo.add("");
        }
        if ((startState = template.getStartState()) == null || startState.getTask() == null) {
            return;
        }
        Controller controller = startState.getTask().getController();
        String currentType = this.variable.getType();
        Variable[] variableArray = controller.getVariables();
        int n = variableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variable element = variableArray[n2];
            WPVariable var = (WPVariable)element;
            if (var.getName() != null && (currentType == null || currentType.equals("") || currentType.equals(var.getType()))) {
                this.processNameCombo.add(var.getName());
            }
            ++n2;
        }
    }

    private boolean isCompositeKey(String name) {
        NodeElement[] nodeElementArray = ((NodeElementContainer)this.messageNodeContainer).getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement node = nodeElementArray[n2];
            Iterator<String> iterator = null;
            if (node instanceof IMessageNodeContainer) {
                for (String mappedName : ((IMessageNodeContainer)node).getCompositeKeys().keySet()) {
                    String varName = ((IMessageNodeContainer)node).getCompositeKey(mappedName);
                    if (!varName.equals(name)) continue;
                    return true;
                }
            } else if (node instanceof IMessageContainer) {
                for (String mappedName : ((IMessageContainer)node).getCompositeKeys().keySet()) {
                    if (!name.equals(mappedName)) continue;
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private boolean isAttachment(String name) {
        NodeElement[] nodeElementArray = ((NodeElementContainer)this.messageNodeContainer).getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeElement node = nodeElementArray[n2];
            if (node instanceof IMessageNodeContainer) {
                for (WPVariable var : ((IMessageNodeContainer)node).getVariables()) {
                    if (!var.isAttachment() || var.getName() == null || !var.getName().equals(name)) continue;
                    return true;
                }
            } else if (node instanceof IMessageContainer) {
                for (WPVariable var : ((IMessageContainer)node).getOutgoingVariables()) {
                    if (!var.isAttachment() || var.getMappedName() == null || !var.getMappedName().equals(name)) continue;
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }
}

