/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties.nodedefinition;

import com.tandbergtv.watchpoint.studio.ui.editor.WatchPointTemplateEditor;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageNodeContainer;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractVariableTableItemWrapper;
import com.tandbergtv.watchpoint.studio.ui.properties.DataType;
import com.tandbergtv.watchpoint.studio.ui.properties.WPVariableTableCellClickedResolver;
import com.tandbergtv.watchpoint.studio.ui.properties.nodedefinition.NodeDefinitionVariableTableItemWrapper;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.nodedefinition.TemplateRequiredVariableFinder;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.jpdl.util.AutoResizeTableLayout;

public class NodeDefinitionVariablesComposite
implements SelectionListener {
    private FormToolkit widgetFactory;
    private Composite parent;
    private Label messageLabel;
    private Table variablesTable;
    private Button addButton;
    private Button removeButton;
    private IMessageNodeContainer messageNodeContainer;
    private WPVariableTableCellClickedResolver resolver;
    private String variableDefaultName = "variable";
    private String[] columnTitles = null;
    private AbstractPropertySection parentPropertySection;

    public static NodeDefinitionVariablesComposite create(AbstractPropertySection parentPropertySection, FormToolkit widgetFactory, Composite parent, boolean nameOnly, String[] columnTitles) {
        NodeDefinitionVariablesComposite result = new NodeDefinitionVariablesComposite();
        result.parentPropertySection = parentPropertySection;
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.columnTitles = columnTitles;
        result.create();
        return result;
    }

    public static NodeDefinitionVariablesComposite create(AbstractPropertySection parentPropertySection, FormToolkit widgetFactory, Composite parent) {
        return NodeDefinitionVariablesComposite.create(parentPropertySection, widgetFactory, parent, false, new String[]{"Name", "Process Variable", "Attachment", "Type", "Composite Key"});
    }

    private NodeDefinitionVariablesComposite() {
    }

    public void setMessageNodeContainer(IMessageNodeContainer variableContainer) {
        this.unhookListeners();
        this.messageNodeContainer = variableContainer;
        this.clearControls();
        if (variableContainer != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.addButton) {
            this.handleAddButtonSelected();
        } else if (e.widget == this.removeButton) {
            this.handleRemoveButtonSelected();
        }
    }

    public IMessageNodeContainer getVariableContainer() {
        return this.messageNodeContainer;
    }

    private void hookListeners() {
        this.addButton.addSelectionListener((SelectionListener)this);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.variablesTable.addSelectionListener((SelectionListener)this);
        this.variablesTable.addMouseListener((MouseListener)this.resolver);
    }

    private void unhookListeners() {
        this.addButton.removeSelectionListener((SelectionListener)this);
        this.removeButton.removeSelectionListener((SelectionListener)this);
        this.variablesTable.removeSelectionListener((SelectionListener)this);
        this.variablesTable.removeMouseListener((MouseListener)this.resolver);
    }

    private void clearControls() {
        this.variablesTable.removeAll();
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    private void updateControls() {
        this.addButton.setEnabled(true);
        this.refreshTable();
    }

    private void create() {
        this.messageLabel = this.widgetFactory.createLabel(this.parent, "Define the used variables :");
        this.variablesTable = this.widgetFactory.createTable(this.parent, 66304);
        this.addButton = this.widgetFactory.createButton(this.parent, "Add", 8);
        this.removeButton = this.widgetFactory.createButton(this.parent, "Remove", 8);
        this.resolver = new WPVariableTableCellClickedResolver(this.variablesTable);
        this.removeButton.setEnabled(false);
        this.messageLabel.setLayoutData((Object)this.createMessageLabelLayoutData());
        this.variablesTable.setLayoutData((Object)this.createVariablesTableLayoutData());
        this.addButton.setLayoutData((Object)this.createAddButtonLayoutData());
        this.removeButton.setLayoutData((Object)this.createRemoveButtonLayoutData());
        this.initializeVariablesTable();
    }

    private void initializeVariablesTable() {
        this.variablesTable.setHeaderVisible(true);
        this.variablesTable.setLinesVisible(true);
        this.variablesTable.setLayout((Layout)new AutoResizeTableLayout(this.variablesTable));
        this.initializeStartTableColumns();
    }

    private void initializeStartTableColumns() {
        TableLayout layout = (TableLayout)this.variablesTable.getLayout();
        TableColumn dummyColumn = new TableColumn(this.variablesTable, 0x1000000);
        dummyColumn.setText("");
        ColumnWeightData dummyColumnData = new ColumnWeightData(0);
        layout.addColumnData((ColumnLayoutData)dummyColumnData);
        TableColumn nameColumn = new TableColumn(this.variablesTable, 16384);
        nameColumn.setText(this.columnTitles[0]);
        ColumnWeightData nameColumnData = new ColumnWeightData(10);
        layout.addColumnData((ColumnLayoutData)nameColumnData);
        TableColumn mappedNameColumn = new TableColumn(this.variablesTable, 16384);
        mappedNameColumn.setText(this.columnTitles[1]);
        ColumnWeightData mappedNameColumnData = new ColumnWeightData(10);
        layout.addColumnData((ColumnLayoutData)mappedNameColumnData);
        TableColumn attachmentColumn = new TableColumn(this.variablesTable, 0x1000000);
        attachmentColumn.setText(this.columnTitles[2]);
        ColumnWeightData attachmentColumnData = new ColumnWeightData(10);
        layout.addColumnData((ColumnLayoutData)attachmentColumnData);
        TableColumn typeColumn = new TableColumn(this.variablesTable, 0x1000000);
        typeColumn.setText(this.columnTitles[3]);
        ColumnWeightData typeColumnData = new ColumnWeightData(10);
        layout.addColumnData((ColumnLayoutData)typeColumnData);
        TableColumn keyColumn = new TableColumn(this.variablesTable, 0x1000000);
        keyColumn.setText(this.columnTitles[4]);
        ColumnWeightData keyColumnData = new ColumnWeightData(15);
        layout.addColumnData((ColumnLayoutData)keyColumnData);
    }

    private FormData createMessageLabelLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 5);
        result.left = new FormAttachment(0, 5);
        result.right = new FormAttachment(100, -5);
        return result;
    }

    private FormData createVariablesTableLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.messageLabel, 5);
        result.left = new FormAttachment(0, 5);
        result.bottom = new FormAttachment(100, -5);
        result.right = new FormAttachment((Control)this.removeButton, -5);
        result.width = 500;
        return result;
    }

    private FormData createAddButtonLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.variablesTable, 0);
        result.top.alignment = 128;
        result.left = new FormAttachment((Control)this.removeButton, 0);
        result.left.alignment = 16384;
        result.right = new FormAttachment(100, -5);
        return result;
    }

    private FormData createRemoveButtonLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.addButton, 5);
        result.right = new FormAttachment(100, -5);
        return result;
    }

    private void handleAddButtonSelected() {
        SemanticElementFactory factory = null;
        if (this.messageNodeContainer instanceof SemanticElement) {
            factory = this.messageNodeContainer.getFactory();
        }
        WPVariable variable = this.createVariable(factory);
        variable.setMappedName(this.getNextAvailableVariableName());
        variable.setAccess("read,write");
        variable.setType(DataType.STRING.toString());
        this.messageNodeContainer.addVariable(variable);
        NodeDefinitionVariableTableItemWrapper wrapper = new NodeDefinitionVariableTableItemWrapper(this.parentPropertySection, this.variablesTable, variable, this.messageNodeContainer);
        this.variablesTable.setSelection(wrapper.getTableItem());
        wrapper.editCell(1);
        this.removeButton.setEnabled(this.variablesTable.getSelectionIndex() != -1);
    }

    private String getNextAvailableVariableName() {
        String result = this.variableDefaultName;
        int runner = 1;
        while (this.hasTableVariableWithName(String.valueOf(result) + runner)) {
            ++runner;
        }
        return String.valueOf(result) + runner;
    }

    private boolean hasTableVariableWithName(String name) {
        boolean result = false;
        int max = this.variablesTable.getItemCount();
        int i = 0;
        while (i < max) {
            AbstractVariableTableItemWrapper wrapper = (AbstractVariableTableItemWrapper)this.variablesTable.getItem(i).getData();
            if (name.equals(wrapper.getVariable().getMappedName())) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private void handleRemoveButtonSelected() {
        TableItem item = this.variablesTable.getItem(this.variablesTable.getSelectionIndex());
        AbstractVariableTableItemWrapper wrapper = (AbstractVariableTableItemWrapper)item.getData();
        this.messageNodeContainer.removeVariable(wrapper.getVariable().getMappedName());
        this.refreshTable();
        this.removeButton.setEnabled(this.variablesTable.getSelectionIndex() != -1);
    }

    private void refreshTable() {
        IWorkbenchPart part;
        this.variablesTable.removeAll();
        List variables = this.messageNodeContainer.getVariables();
        Set<String> requiredNames = null;
        if (this.parentPropertySection.getPart() instanceof WatchPointTemplateEditor) {
            TemplateRequiredVariableFinder variableFinder = new TemplateRequiredVariableFinder();
            NodeDefinition definition = (NodeDefinition)this.messageNodeContainer;
            requiredNames = variableFinder.getRequiredVariableNames(definition);
        }
        if (variables != null) {
            for (WPVariable var : variables) {
                boolean required = requiredNames != null && requiredNames.contains(var.getMappedName());
                NodeDefinitionVariableTableItemWrapper wrapper = new NodeDefinitionVariableTableItemWrapper(this.parentPropertySection, this.variablesTable, var, this.messageNodeContainer, required);
                this.variablesTable.setSelection(wrapper.getTableItem());
                wrapper.editCell(1);
            }
        }
        if ((part = this.parentPropertySection.getPart()) instanceof WatchPointTemplateEditor) {
            this.removeButton.setEnabled(false);
            this.addButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(this.variablesTable.getSelectionIndex() != -1);
        }
    }

    private WPVariable createVariable(SemanticElementFactory delegateFactory) {
        if (delegateFactory == null) {
            return new WPVariable();
        }
        return (WPVariable)delegateFactory.createById("org.jbpm.gd.jpdl.variable");
    }
}

