/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties.nodedefinition;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionEditor;
import com.tandbergtv.watchpoint.studio.ui.model.IMessageNodeContainer;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.common.model.NamedElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;

public class UidConfigurationComposite
implements SelectionListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private CCombo uidCombo;
    private Label uidLabel;
    private IMessageNodeContainer messageContainerNode;
    private List<Message> messages;
    private AbstractPropertySection parentPropertySection;

    private UidConfigurationComposite() {
    }

    public static UidConfigurationComposite create(AbstractPropertySection parentSection, TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        UidConfigurationComposite result = new UidConfigurationComposite();
        result.parentPropertySection = parentSection;
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    public void setUidElement(IMessageNodeContainer uidElement) {
        this.clearControls();
        this.messageContainerNode = uidElement;
        if (uidElement != null) {
            if (this.uidCombo.isEnabled()) {
                this.fillUidCombo();
            }
            this.updateControls();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.uidCombo && this.messageContainerNode != null) {
            String uid = this.getUID(this.uidCombo.getText());
            if (!Utility.isOutgoingMessage(uid) && this.hasAttachment()) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"This is an incoming message and can not have an attachment. Please remove the attachment variable first before selecting this message.");
                this.uidCombo.setText(this.getMessageName(this.messageContainerNode.getUid()));
                return;
            }
            this.messageContainerNode.setUid(uid);
        }
    }

    private String getUID(String messageName) {
        for (Message message : this.messages) {
            if (!message.getName().equals(messageName)) continue;
            return message.getUid();
        }
        return "";
    }

    private String getMessageName(String uid) {
        for (Message message : this.messages) {
            if (!message.getUid().equals(uid)) continue;
            return message.getName();
        }
        return "";
    }

    private void clearControls() {
        this.uidCombo.setText("");
    }

    private void updateControls() {
        IWorkbenchPart part = this.parentPropertySection.getPart();
        NodeElementContainer container = Utility.getNodeElementContainer(part);
        if (container == null) {
            throw new UIException("Current editor does not have a node element container associated with it.");
        }
        boolean enable = ((NodeElementContainer)this.messageContainerNode).getElementId().equals(container.getElementId()) && this.messageContainerNode instanceof NamedElement && container instanceof NodeDefinition && ((NamedElement)this.messageContainerNode).getName().equals(((NamedElement)container).getName());
        this.uidCombo.setEnabled(enable);
        String uid = this.messageContainerNode.getUid();
        if (uid != null) {
            this.setUIDInCombo();
        }
    }

    private void create() {
        Composite composite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.uidLabel = new Label(composite, 0);
        this.uidLabel.setLayoutData((Object)this.createUidpLabelLayoutData());
        this.uidLabel.setText("Message Name");
        this.uidLabel.pack();
        this.uidCombo = this.widgetFactory.createCCombo(this.parent, 780);
        this.uidCombo.setLayoutData((Object)this.createUidComboLayoutData());
        this.uidCombo.addSelectionListener((SelectionListener)this);
        this.uidCombo.pack();
    }

    private FormData createUidpLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        return data;
    }

    private FormData createUidComboLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.uidLabel, 95);
        data.top = new FormAttachment(0, 0);
        data.width = 150;
        return data;
    }

    private void fillUidCombo() {
        this.uidCombo.removeAll();
        IResourceTypeService rtService = ServiceFactory.createFactory().createResourceTypeService();
        long id = this.messageContainerNode.getResourceType();
        long definitionId = this.getNodeDefinitionId();
        this.messages = definitionId == 0L ? rtService.getUnusedResourceTypeMessages(id) : rtService.getUnusedResourceTypeMessages(id, definitionId);
        if (this.messageContainerNode != null && this.messageContainerNode.getUid() != null && this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
        Collections.sort(this.messages, new Comparator<Message>(){

            @Override
            public int compare(Message m1, Message m2) {
                if (m1.getName() == null && m2.getName() == null) {
                    return 0;
                }
                if (m1.getName() == null) {
                    return -1;
                }
                if (m2.getName() == null) {
                    return 1;
                }
                return m1.getName().compareToIgnoreCase(m2.getName());
            }
        });
        for (Message message : this.messages) {
            this.uidCombo.add(message.getName());
        }
    }

    private void setUIDInCombo() {
        if (this.messageContainerNode == null || this.messageContainerNode.getUid() == null) {
            return;
        }
        IResourceTypeService rtService = ServiceFactory.createFactory().createResourceTypeService();
        Message msg = rtService.findMessageByUID(((NodeDefinition)this.messageContainerNode).getUid());
        this.uidCombo.setText(msg.getName());
    }

    private long getNodeDefinitionId() {
        if (this.parentPropertySection.getPart() instanceof NodeDefinitionEditor) {
            return ((NodeDefinitionEditor)this.parentPropertySection.getPart()).getNodeDefinitionDTOId();
        }
        return 0L;
    }

    private boolean hasAttachment() {
        List<WPVariable> vars = this.messageContainerNode.getOutgoingVariables();
        for (WPVariable var : vars) {
            if (!var.isAttachment()) continue;
            return true;
        }
        return false;
    }
}

