/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties.template;

import com.tandbergtv.watchpoint.studio.application.ApplicationProperties;
import com.tandbergtv.watchpoint.studio.ui.model.ManualTaskNode;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Action;

public class ActionHandlerConfigurationComposite
implements FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Text handlerText;
    private Label handlerLabel;
    private ManualTaskNode manualTaskNode;

    private ActionHandlerConfigurationComposite() {
    }

    public static ActionHandlerConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        ActionHandlerConfigurationComposite result = new ActionHandlerConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    public void setManualTaskNode(ManualTaskNode manualNode) {
        if (this.manualTaskNode == manualNode) {
            return;
        }
        this.clearControls();
        this.manualTaskNode = manualNode;
        if (manualNode != null) {
            if (this.manualTaskNode.getAction() == null) {
                this.manualTaskNode.setAction(this.createAction());
            }
            this.updateControls();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.handlerText && this.manualTaskNode.getAction() != null) {
            this.manualTaskNode.getAction().setClassName(this.handlerText.getText());
        }
    }

    private void clearControls() {
        this.handlerText.setText("");
    }

    private void updateControls() {
        String handler = this.manualTaskNode.getAction().getClassName();
        if (handler != null && !handler.equals("")) {
            this.handlerText.setText(handler);
        } else {
            ApplicationProperties properties = ApplicationProperties.getInstance();
            String defaultHandler = properties.getProperty("ManualTask.Handler");
            this.handlerText.setText(defaultHandler);
            this.manualTaskNode.getAction().setClassName(defaultHandler);
        }
    }

    private void create() {
        Composite composite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.handlerLabel = new Label(composite, 0);
        this.handlerLabel.setText("Action Handler");
        this.handlerLabel.setLayoutData((Object)this.createHandlerLabelLayoutData());
        this.handlerLabel.setBackground(ColorConstants.white);
        this.handlerLabel.pack();
        this.handlerText = this.widgetFactory.createText(this.parent, "");
        this.handlerText.setLayoutData((Object)this.createHandlerTextLayoutData());
        this.handlerText.addFocusListener((FocusListener)this);
        this.handlerText.pack();
    }

    private FormData createHandlerLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        return data;
    }

    private FormData createHandlerTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.top = new FormAttachment(1, 0);
        data.right = new FormAttachment(100, 0);
        return data;
    }

    private Action createAction() {
        return (Action)this.manualTaskNode.getFactory().createById("org.jbpm.gd.jpdl.action");
    }
}

