/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties.template;

import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.model.AbstractTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.properties.TaskNodeActionElementComposite;
import com.tandbergtv.watchpoint.studio.ui.util.ValidationMessages;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jbpm.gd.common.model.GenericElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentTableItemWrapper
implements DisposeListener,
FocusListener {
    private TableItem tableItem;
    private Text nameText;
    private Text valueText;
    private TaskNodeActionElementComposite parent;
    private GenericElement genericElement;
    private IValidationService validationService;

    public ArgumentTableItemWrapper(TaskNodeActionElementComposite parent, Table table, GenericElement genericElement, boolean isEditable) {
        this.parent = parent;
        this.genericElement = genericElement;
        this.validationService = ValidationServiceFactory.createFactory().createValidationService();
        this.initializeTableItem(table);
        this.initializeNameText(table);
        this.initializeValueText(table);
        this.nameText.setEnabled(isEditable);
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.nameText) {
            if (this.genericElement.getName().equals(this.nameText.getText())) {
                return;
            }
            if (this.isNameValid()) {
                this.genericElement.setName(this.nameText.getText());
            } else {
                this.nameText.setText(this.genericElement.getName());
            }
        } else if (e.widget == this.valueText) {
            if (this.genericElement.getValue().equals(this.valueText.getText())) {
                return;
            }
            if (this.isValueValid()) {
                this.genericElement.setValue(this.valueText.getText());
            } else {
                this.valueText.setText(this.genericElement.getValue());
            }
        }
    }

    public void focusGained(FocusEvent e) {
        if (e.widget == this.nameText || e.widget == this.valueText) {
            this.tableItem.getParent().setSelection(this.tableItem);
            if (this.nameText.isEnabled()) {
                this.parent.setRemoveButtonEnable(true);
            }
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.nameText == null || this.nameText.isDisposed()) {
            return;
        }
        if (this.valueText == null || this.valueText.isDisposed()) {
            return;
        }
        this.nameText.removeFocusListener((FocusListener)this);
        this.nameText.dispose();
        this.valueText.removeFocusListener((FocusListener)this);
        this.valueText.dispose();
    }

    public TableItem getTableItem() {
        return this.tableItem;
    }

    protected void initializeTableItem(Table table) {
        this.tableItem = new TableItem(table, 0);
        this.tableItem.addDisposeListener((DisposeListener)this);
        this.tableItem.setData((Object)this);
    }

    protected void initializeNameText(Table table) {
        this.nameText = this.createText(table, 0);
        FormData data = new FormData();
        this.nameText.setLayoutData((Object)data);
        this.nameText.addFocusListener((FocusListener)this);
        this.nameText.setText(this.getArgumentName());
        this.nameText.setEditable(true);
    }

    protected void initializeValueText(Table table) {
        this.valueText = this.createText(table, 1);
        FormData data = new FormData();
        this.valueText.setLayoutData((Object)data);
        this.valueText.addFocusListener((FocusListener)this);
        this.valueText.setText(this.getArgumentValue());
        this.valueText.setEditable(true);
    }

    protected Text createText(Table table, int index) {
        TableEditor textEditor = new TableEditor(table);
        Text result = new Text((Composite)table, 0);
        result.setVisible(true);
        result.pack();
        textEditor.minimumWidth = result.getSize().x;
        textEditor.horizontalAlignment = 16384;
        textEditor.grabHorizontal = true;
        textEditor.setEditor((Control)result, this.tableItem, index);
        return result;
    }

    public String getArgumentName() {
        return this.genericElement.getName();
    }

    public String getArgumentValue() {
        return this.genericElement.getValue();
    }

    private boolean isNameValid() {
        String variableName = this.nameText.getText();
        GenericElement element = new GenericElement();
        element.setName(variableName);
        List<ValidationMessage> messages = null;
        messages = this.validationService.validateActionVariableName(element);
        boolean valid = this.isValid(messages);
        boolean duplicate = false;
        if (!valid) {
            this.displayValidationErrors(messages);
        } else {
            duplicate = this.checkDuplicateName(variableName);
            if (duplicate) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)(String.valueOf(variableName) + " is a duplicate name. Duplicate names are not allowed."));
            }
        }
        return valid && !duplicate;
    }

    private boolean isValueValid() {
        boolean valid = true;
        AbstractTaskNode node = this.parent.getTaskNode();
        if (!(node instanceof AutomaticTaskNode)) {
            return valid;
        }
        AutomaticTaskNode automaticTaskNode = (AutomaticTaskNode)node;
        GenericElement element = new GenericElement();
        element.setName(this.nameText.getText());
        element.setValue(this.valueText.getText());
        List<ValidationMessage> messages = null;
        messages = this.validationService.validateActionVariableValue(automaticTaskNode, element);
        valid = this.isValid(messages);
        if (!valid) {
            this.displayValidationErrors(messages);
        }
        return valid;
    }

    private boolean isValid(List<ValidationMessage> messages) {
        return messages == null || messages.size() == 0;
    }

    private void displayValidationErrors(List<ValidationMessage> messages) {
        Shell shell = Display.getCurrent().getActiveShell();
        StringBuilder buf = new StringBuilder();
        ValidationMessages validationMessages = null;
        try {
            validationMessages = ValidationMessages.getInstance();
        }
        catch (Exception e) {
            throw new UIException("Could not load the validation messages.", e);
        }
        boolean first = true;
        for (ValidationMessage message : messages) {
            if (!first) {
                buf.append(System.getProperty("line.separator"));
            } else {
                first = false;
            }
            buf.append(validationMessages.getMessage(message));
        }
        MessageDialog.openError((Shell)shell, (String)"Error", (String)buf.toString());
    }

    private boolean checkDuplicateName(String name) {
        GenericElement[] genericElementArray = this.parent.getTaskNode().getAction().getGenericElements();
        int n = genericElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericElement element = genericElementArray[n2];
            if (element.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

