/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties.template;

import com.tandbergtv.watchpoint.studio.ui.model.IProtectionKeyElement;
import com.tandbergtv.watchpoint.studio.ui.model.ProtectionKey;
import com.tandbergtv.watchpoint.studio.ui.properties.template.ProtectionKeyTableItemWrapper;
import java.util.Set;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.jbpm.gd.jpdl.util.AutoResizeTableLayout;

public class PKContainerConfigurationComposite
implements SelectionListener {
    private FormToolkit widgetFactory;
    private Composite parent;
    private Label pkLabel;
    private Table pkTable;
    private Button addButton;
    private Button removeButton;
    private IProtectionKeyElement protectionKeyElement;
    private String[] columnTitles = null;
    private AbstractPropertySection parentPropertySection;

    public static PKContainerConfigurationComposite create(AbstractPropertySection parentPropertySection, FormToolkit widgetFactory, Composite parent, String[] columnTitles) {
        PKContainerConfigurationComposite result = new PKContainerConfigurationComposite();
        result.parentPropertySection = parentPropertySection;
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.columnTitles = columnTitles;
        result.create();
        return result;
    }

    public static PKContainerConfigurationComposite create(AbstractPropertySection parentPropertySection, FormToolkit widgetFactory, Composite parent) {
        return PKContainerConfigurationComposite.create(parentPropertySection, widgetFactory, parent, new String[]{"Name"});
    }

    private PKContainerConfigurationComposite() {
    }

    public void setProtectionKeyElement(IProtectionKeyElement protectionKeyElement) {
        this.unhookListeners();
        this.protectionKeyElement = protectionKeyElement;
        this.clearControls();
        if (protectionKeyElement != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.addButton) {
            this.handleAddButtonSelected();
        } else if (e.widget == this.removeButton) {
            this.handleRemoveButtonSelected();
        } else if (e.widget == this.pkTable) {
            this.handlePKTableSelected(e);
        }
    }

    public void setRemoveButtonEnable(boolean enable) {
        this.removeButton.setEnabled(enable);
    }

    private void hookListeners() {
        this.addButton.addSelectionListener((SelectionListener)this);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.pkTable.addSelectionListener((SelectionListener)this);
    }

    private void unhookListeners() {
        this.addButton.removeSelectionListener((SelectionListener)this);
        this.removeButton.removeSelectionListener((SelectionListener)this);
        this.pkTable.removeSelectionListener((SelectionListener)this);
    }

    private void clearControls() {
        this.pkTable.removeAll();
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    private void updateControls() {
        this.addButton.setEnabled(true);
        this.refreshTable();
    }

    private void create() {
        this.pkLabel = this.widgetFactory.createLabel(this.parent, "Define the protection keys :");
        this.pkTable = this.widgetFactory.createTable(this.parent, 66304);
        this.addButton = this.widgetFactory.createButton(this.parent, "Add", 8);
        this.removeButton = this.widgetFactory.createButton(this.parent, "Remove", 8);
        this.removeButton.setEnabled(false);
        this.pkLabel.setLayoutData((Object)this.createMessageLabelLayoutData());
        this.pkTable.setLayoutData((Object)this.createPKTableLayoutData());
        this.addButton.setLayoutData((Object)this.createAddButtonLayoutData());
        this.removeButton.setLayoutData((Object)this.createRemoveButtonLayoutData());
        this.initializePKTable();
    }

    private void initializePKTable() {
        this.pkTable.setHeaderVisible(true);
        this.pkTable.setLinesVisible(true);
        this.pkTable.setLayout((Layout)new AutoResizeTableLayout(this.pkTable));
        this.initializeTaskTableColumns();
    }

    private void initializeTaskTableColumns() {
        TableLayout layout = (TableLayout)this.pkTable.getLayout();
        TableColumn dummyColumn = new TableColumn(this.pkTable, 0x1000000);
        dummyColumn.setText("");
        ColumnWeightData dummyColumnData = new ColumnWeightData(0);
        layout.addColumnData((ColumnLayoutData)dummyColumnData);
        TableColumn nameColumn = new TableColumn(this.pkTable, 16384);
        nameColumn.setText(this.columnTitles[0]);
        ColumnWeightData nameColumnData = new ColumnWeightData(15);
        nameColumnData.resizable = false;
        layout.addColumnData((ColumnLayoutData)nameColumnData);
    }

    private FormData createMessageLabelLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 5);
        result.left = new FormAttachment(0, 0);
        result.right = new FormAttachment(100, -5);
        return result;
    }

    private FormData createPKTableLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.pkLabel, 5);
        result.left = new FormAttachment(0, 85);
        result.bottom = new FormAttachment(100, -5);
        result.right = new FormAttachment((Control)this.removeButton, -5);
        return result;
    }

    private FormData createAddButtonLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.pkTable, 0);
        result.top.alignment = 128;
        result.left = new FormAttachment((Control)this.removeButton, 0);
        result.left.alignment = 16384;
        result.right = new FormAttachment(90, -5);
        return result;
    }

    private FormData createRemoveButtonLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.addButton, 5);
        result.right = new FormAttachment(90, -5);
        return result;
    }

    private void handleAddButtonSelected() {
        ProtectionKey key = this.createProtectionKey();
        this.protectionKeyElement.addProtectionKey(key);
        ProtectionKeyTableItemWrapper wrapper = new ProtectionKeyTableItemWrapper(this.parentPropertySection, this, this.pkTable, key);
        this.pkTable.setSelection(wrapper.getTableItem());
        wrapper.editCell(1);
        this.removeButton.setEnabled(this.pkTable.getSelectionIndex() != -1);
    }

    private void handleRemoveButtonSelected() {
        TableItem item = this.pkTable.getItem(this.pkTable.getSelectionIndex());
        ProtectionKeyTableItemWrapper wrapper = (ProtectionKeyTableItemWrapper)item.getData();
        this.protectionKeyElement.removeProtectionKey(wrapper.getProtectionKey());
        this.refreshTable();
        this.removeButton.setEnabled(this.pkTable.getSelectionIndex() != -1);
    }

    private void refreshTable() {
        this.pkTable.removeAll();
        Set<ProtectionKey> keys = this.protectionKeyElement.getProtectionKeys();
        if (keys != null) {
            for (ProtectionKey key : keys) {
                new ProtectionKeyTableItemWrapper(this.parentPropertySection, this, this.pkTable, key);
            }
        }
    }

    private void handlePKTableSelected(SelectionEvent e) {
        this.removeButton.setEnabled(this.pkTable.getSelectionIndex() != -1);
    }

    private ProtectionKey createProtectionKey() {
        return (ProtectionKey)this.protectionKeyElement.getFactory().createById("org.jbpm.gd.jpdl.protectionKey");
    }
}

