/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties.template;

import com.tandbergtv.watchpoint.studio.service.IResourceGroupService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.model.IResourceGroupElement;
import com.tandbergtv.watchpoint.studio.ui.model.ProtectionKey;
import com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup;
import com.tandbergtv.watchpoint.studio.ui.properties.template.PKContainerConfigurationComposite;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectionKeyTableItemWrapper
implements DisposeListener,
SelectionListener,
FocusListener {
    protected TableItem tableItem;
    protected CCombo nameCombo;
    protected ProtectionKey protectionKey;
    protected PKContainerConfigurationComposite parent;
    private AbstractPropertySection parentPropertySection;

    public ProtectionKeyTableItemWrapper(AbstractPropertySection parentSection, PKContainerConfigurationComposite parent, Table table, ProtectionKey variable) {
        this.protectionKey = variable;
        this.parent = parent;
        this.parentPropertySection = parentSection;
        this.initializeTableItem(table);
        this.initializeNameCombo(table);
    }

    public void focusLost(FocusEvent e) {
        this.cancelEditing();
        if (e.widget == this.nameCombo) {
            String upper = this.nameCombo.getText().toUpperCase();
            this.protectionKey.setName(upper);
            this.nameCombo.setText(upper);
        }
    }

    public void focusGained(FocusEvent e) {
        if (e.widget == this.nameCombo) {
            this.tableItem.getParent().setSelection(this.tableItem);
            this.parent.setRemoveButtonEnable(true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.nameCombo) {
            this.protectionKey.setName(this.nameCombo.getText());
            this.applyName();
        }
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.nameCombo == null || this.nameCombo.isDisposed()) {
            return;
        }
        this.nameCombo.removeSelectionListener((SelectionListener)this);
        this.nameCombo.removeFocusListener((FocusListener)this);
        this.nameCombo.dispose();
    }

    public TableItem getTableItem() {
        return this.tableItem;
    }

    public ProtectionKey getProtectionKey() {
        return this.protectionKey;
    }

    public void editCell(int column) {
        if (column == 1) {
            this.editName();
        }
    }

    protected void initializeTableItem(Table table) {
        this.tableItem = new TableItem(table, 0);
        this.tableItem.addDisposeListener((DisposeListener)this);
        this.tableItem.setData((Object)this);
    }

    protected void initializeNameCombo(Table table) {
        this.nameCombo = this.createCombo(table, 1);
        this.nameCombo.setTextLimit(50);
        FormData data = new FormData();
        data.width = 85;
        this.nameCombo.setLayoutData((Object)data);
        this.nameCombo.addSelectionListener((SelectionListener)this);
        this.nameCombo.addFocusListener((FocusListener)this);
        this.nameCombo.setText(this.getName());
        this.nameCombo.setEditable(true);
        this.fillProtectionKeyCombo();
        if (this.nameCombo.getSelectionIndex() == -1) {
            this.nameCombo.setText(this.getName());
        }
    }

    protected CCombo createCombo(Table table, int index) {
        TableEditor textEditor = new TableEditor(table);
        CCombo result = new CCombo((Composite)table, 780);
        result.pack();
        textEditor.horizontalAlignment = 16384;
        textEditor.grabHorizontal = true;
        textEditor.setEditor((Control)result, this.tableItem, index);
        return result;
    }

    protected void editName() {
        this.nameCombo.setVisible(true);
        this.nameCombo.setText(this.getName());
        this.nameCombo.setFocus();
    }

    protected void cancelEditing() {
        this.applyName();
    }

    protected void applyName() {
        if (this.nameCombo == null) {
            return;
        }
        this.tableItem.setText(1, this.getName());
    }

    protected String getName() {
        return this.protectionKey.getName() == null ? "" : this.protectionKey.getName();
    }

    private void fillProtectionKeyCombo() {
        IResourceGroupService service = ServiceFactory.createFactory().createResourceGroupService();
        int index = 0;
        for (String groupName : this.getResourceGroups()) {
            String pk = service.getProtectionKeyByResourceGroupName(groupName).getName();
            if (this.arrayContains(this.nameCombo.getItems(), pk)) continue;
            this.nameCombo.add(pk);
            if (pk.equals(this.protectionKey.getName())) {
                this.nameCombo.select(index);
            }
            ++index;
        }
    }

    private Set<String> getResourceGroups() {
        HashSet<String> resourceGroups = new HashSet<String>();
        IWorkbenchPart part = this.parentPropertySection.getPart();
        NodeElementContainer nodeContainer = Utility.getNodeElementContainer(part);
        if (nodeContainer == null) {
            throw new UIException("Current editor does not have a node element container associated with it.");
        }
        NodeElement[] nodeElementArray = nodeContainer.getNodeElements();
        int n = nodeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceGroup resourceGroup;
            NodeElement nodeElement = nodeElementArray[n2];
            if (nodeElement instanceof IResourceGroupElement && (resourceGroup = ((IResourceGroupElement)nodeElement).getResourceGroup()) != null && resourceGroup.getName() != null && !resourceGroup.getName().trim().equals("")) {
                resourceGroups.add(((IResourceGroupElement)nodeElement).getResourceGroup().getName());
            }
            ++n2;
        }
        return resourceGroups;
    }

    private boolean arrayContains(String[] strArray, String val) {
        String[] stringArray = strArray;
        int n = strArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.equals(val)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

