/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.util;

import com.tandbergtv.watchpoint.studio.application.ApplicationProperties;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.service.ServiceErrorCode;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.WatchPointTemplateEditor;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.ServiceErrors;
import com.tandbergtv.watchpoint.studio.ui.util.ValidationMessages;
import com.tandbergtv.watchpoint.studio.ui.view.ValidationErrorsView;
import com.tandbergtv.watchpoint.studio.usermgmt.UserManagementException;
import com.tandbergtv.watchpoint.studio.usermgmt.UserManager;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.sse.core.internal.model.ModelManagerImpl;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.common.xml.XmlAdapterFactory;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.model.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utility {
    private static final Logger logger = Logger.getLogger(Utility.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String PLUGIN_ID = "org.jbpm.gd.jpdl";
    private static final String ICONS_PATH = "icons/";
    public static final String TEMPLATE_EDITOR_ID = "org.jbpm.gd.jpdl.editor";
    public static final String NODEDEF_EDITOR_ID = "com.tandbergtv.jpdl.nodedefinitioneditor";
    public static final String RESOURCE_TYPE_EDITOR_ID = "com.tandbergtv.watchpoint.studio.ui.editor.ResourceTypeEditor";
    public static final String TEMPLATE_EXPLORER_ID = "com.tandbergtv.gd.TemplateExplorer";
    public static final String NODEDEF_EXPLORER_ID = "com.tandbergtv.gd.NodeDefinitionExplorer";
    public static final String VALIDATION_ERRORS_ID = "com.tandbergtv.gd.ValidationErrors";
    private static IWorkbenchWindow window;

    private Utility() {
    }

    public static boolean closeEditor(String editorId, boolean save) {
        if (window == null || window.getActivePage() == null) {
            return true;
        }
        IEditorPart editor = Utility.getEditor(editorId);
        if (editor == null) {
            return true;
        }
        return window.getActivePage().closeEditor(editor, save);
    }

    public static IEditorPart getEditor(String editorId) {
        if (window == null || window.getActivePage() == null) {
            return null;
        }
        IEditorReference[] iEditorReferenceArray = window.getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart editor = ref.getEditor(false);
            if (editor != null && editor.getEditorSite().getId().equals(editorId) && editor.getSite().getWorkbenchWindow().getActivePage() != null) {
                return editor;
            }
            ++n2;
        }
        return null;
    }

    public static NodeElementContainer getNodeElementContainer(IWorkbenchPart part) {
        SemanticElement container = null;
        if (part instanceof WatchPointTemplateEditor) {
            container = ((WatchPointTemplateEditor)part).getProcessDefinition();
        } else if (part instanceof NodeDefinitionEditor) {
            container = ((NodeDefinitionEditor)part).getNodeDefinition();
        }
        return container;
    }

    public static WorkflowTemplateDTO createTemplateDTO(long id, int version, String name, String xml, String gpdXml) {
        WorkflowTemplateDTO templateDTO = new WorkflowTemplateDTO();
        templateDTO.setId(id);
        templateDTO.setVersion(version);
        templateDTO.setName(name);
        templateDTO.setGpd(gpdXml);
        templateDTO.setXml(xml);
        return templateDTO;
    }

    public static NodeDefinitionDTO createNodeDefinitionDTO(long id, String name, String xml, String gpdXml) {
        NodeDefinitionDTO nodeDefinitionDTO = new NodeDefinitionDTO();
        nodeDefinitionDTO.setId(id);
        nodeDefinitionDTO.setName(name);
        nodeDefinitionDTO.setGpd(gpdXml);
        nodeDefinitionDTO.setXml(xml);
        return nodeDefinitionDTO;
    }

    public static String getUserName() {
        String userId = null;
        try {
            userId = UserManager.getInstance().getCurrentUserId();
        }
        catch (UserManagementException userManagementException) {
            logger.error((Object)"Failed to get the current User Id.");
        }
        return userId;
    }

    public static Document getDOMDocumentFromString(String xmlString) {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(new ByteArrayInputStream(xmlString.getBytes()));
        }
        catch (SAXException ex) {
            throw new UIException("Could not parse DOM document.", ex);
        }
        catch (IOException ex) {
            throw new UIException("Could not read from xml.", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new UIException("Error in parser configuration.", ex);
        }
        return doc;
    }

    public static String getXMLFromDocument(Document doc) {
        StringWriter stringWriter = new StringWriter();
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(doc.getDocumentElement());
            StreamResult result = new StreamResult(stringWriter);
            transformer.transform(source, result);
        }
        catch (TransformerException ex) {
            throw new UIException("Could not transform DOM document.", ex);
        }
        return stringWriter.getBuffer().toString().replaceAll("&#13;", "");
    }

    public static boolean isOutgoingMessage(String uid) {
        String workflowSystemId = ApplicationProperties.getInstance().get("WFS.ResourceType.SystemId").toString();
        return !uid.substring(2, 4).equals(workflowSystemId);
    }

    public static IWorkbenchWindow getWindow() {
        return window;
    }

    public static synchronized void setWindow(IWorkbenchWindow window) {
        Utility.window = window;
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        try {
            URL installURL = Platform.getBundle((String)PLUGIN_ID).getEntry("/");
            URL url = new URL(installURL, ICONS_PATH + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            throw new UIException("Could not open image at path icons/" + relativePath, e);
        }
    }

    public static void handleException(String errorMessage, Throwable e) {
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)errorMessage);
    }

    public static void updateValidationErrors(IWorkbenchPartSite site, List<ValidationMessage> messages) {
        IWorkbenchPage page = site.getWorkbenchWindow().getActivePage();
        if (page != null) {
            IViewPart view = null;
            try {
                view = messages != null && messages.size() > 0 ? page.showView(VALIDATION_ERRORS_ID) : page.findView(VALIDATION_ERRORS_ID);
            }
            catch (PartInitException e) {
                throw new UIException("Error opening validation errors view.", e);
            }
            if (view instanceof ValidationErrorsView) {
                ((ValidationErrorsView)view).updateValidationMessages(messages);
            }
        }
    }

    public static SemanticElement getContainedSemanticElement(Object object) {
        EditPart editPart;
        Object modelElement;
        SemanticElement containedElement = null;
        if (object instanceof NotationElementGraphicalEditPart) {
            NotationElementGraphicalEditPart editPart2 = (NotationElementGraphicalEditPart)object;
            containedElement = editPart2.getNotationElement().getSemanticElement();
        } else if (object instanceof EditPart && (modelElement = (editPart = (EditPart)object).getModel()) instanceof SemanticElement) {
            containedElement = (SemanticElement)modelElement;
        }
        return containedElement;
    }

    public static synchronized XmlAdapter getAdapterFromStream(String fileName, InputStream xmlStream, SemanticElementFactory elementFactory) {
        IStructuredModel model = null;
        try {
            XmlAdapter xmlAdapter;
            model = ModelManagerImpl.getInstance().getModelForRead("adapter", xmlStream, null);
            IDOMModel domModel = null;
            domModel = (IDOMModel)model;
            XmlAdapterFactory factory = new XmlAdapterFactory((Document)domModel.getDocument(), elementFactory);
            XmlAdapter xmlAdapter2 = xmlAdapter = factory.adapt((Node)domModel.getDocument().getDocumentElement());
            return xmlAdapter2;
        }
        catch (UnsupportedEncodingException e) {
            throw new UIException("Invalid encoding in xml file " + fileName + ".", e);
        }
        catch (IOException e) {
            throw new UIException("Could not read from xml file " + fileName + " to create model.", e);
        }
        finally {
            model.releaseFromRead();
        }
    }

    public static synchronized XmlAdapter getAdapterFromString(String xmlString, SemanticElementFactory elementFactory) {
        IStructuredModel model = null;
        try {
            XmlAdapter xmlAdapter;
            ByteArrayInputStream xmlStream = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
            model = ModelManagerImpl.getInstance().getModelForRead("adapter", (InputStream)xmlStream, null);
            IDOMModel domModel = null;
            domModel = (IDOMModel)model;
            XmlAdapterFactory factory = new XmlAdapterFactory((Document)domModel.getDocument(), elementFactory);
            XmlAdapter xmlAdapter2 = xmlAdapter = factory.adapt((Node)domModel.getDocument().getDocumentElement());
            return xmlAdapter2;
        }
        catch (UnsupportedEncodingException e) {
            throw new UIException("Invalid encoding in xml.", e);
        }
        catch (IOException e) {
            throw new UIException("Could not read from xml to create model.", e);
        }
        finally {
            model.releaseFromRead();
        }
    }

    public static void reportError(String headerMessage, Exception e) {
        String errorMessage = String.valueOf(headerMessage) + LINE_SEPARATOR + LINE_SEPARATOR + "Reason(s):" + LINE_SEPARATOR;
        if (e instanceof ServiceValidationException) {
            List<ValidationMessage> validationMessages = ((ServiceValidationException)e).getValidationMessages();
            if (validationMessages != null && !validationMessages.isEmpty()) {
                StringBuffer errorMessageStrBuf = new StringBuffer();
                for (ValidationMessage validationMessage : validationMessages) {
                    try {
                        errorMessageStrBuf.append(ValidationMessages.getInstance().getMessage(validationMessage));
                        errorMessageStrBuf.append(LINE_SEPARATOR);
                    }
                    catch (Exception exception) {
                        String subExceptionErrorMessage = "Could not read validation message " + validationMessage.getCode() + " from property file.";
                        errorMessageStrBuf.append(subExceptionErrorMessage);
                        errorMessageStrBuf.append(LINE_SEPARATOR);
                    }
                }
                errorMessage = String.valueOf(errorMessage) + errorMessageStrBuf.toString();
            } else {
                errorMessage = String.valueOf(errorMessage) + e.getMessage();
            }
        } else if (e instanceof ServiceException) {
            ServiceException se = (ServiceException)e;
            ServiceErrorCode code = se.getServiceErrorCode();
            errorMessage = ServiceErrors.getInstance().getProperty(code.getCode());
        } else {
            errorMessage = String.valueOf(errorMessage) + e.getMessage();
        }
        logger.error((Object)("Failure in UI: " + errorMessage), (Throwable)e);
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)errorMessage);
    }

    public static List<WPVariable> getVariables(NodeElementContainer container) {
        ArrayList<WPVariable> wpVariables;
        block4: {
            block3: {
                Variable[] variables;
                Task task;
                wpVariables = new ArrayList<WPVariable>();
                if (!(container instanceof WorkflowTemplate)) break block3;
                WorkflowTemplate temp = (WorkflowTemplate)container;
                StartState startState = temp.getStartState();
                if (startState == null || (task = startState.getTask()) == null) break block4;
                Variable[] variableArray = variables = task.getController().getVariables();
                int n = variables.length;
                int n2 = 0;
                while (n2 < n) {
                    Variable variable = variableArray[n2];
                    wpVariables.add((WPVariable)variable);
                    ++n2;
                }
                break block4;
            }
            if (container instanceof NodeDefinition) {
                NodeDefinition nodeDefinition = (NodeDefinition)container;
                for (WPVariable var : nodeDefinition.getVariables()) {
                    WPVariable tempVar = new WPVariable();
                    tempVar.setName(var.getMappedName());
                    wpVariables.add(tempVar);
                }
            }
        }
        return wpVariables;
    }

    public static IEditorPart getActiveEditor() {
        if (window == null || window.getActivePage() == null) {
            return null;
        }
        return window.getActivePage().getActiveEditor();
    }
}

