/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.util;

import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;

public class ValidationMessages
extends Properties {
    private static final String PARAM_START = "<![";
    private static final String PARAM_END = "]>";
    private static final long serialVersionUID = -9033237554511674020L;
    private static final String RESOURCE_PATH = "/ValidationMessages.properties";
    private static ValidationMessages instance;

    private ValidationMessages() throws InvalidPropertiesFormatException, IOException {
        this.loadProperties();
    }

    public static synchronized ValidationMessages getInstance() throws InvalidPropertiesFormatException, IOException {
        if (instance == null) {
            instance = new ValidationMessages();
        }
        return instance;
    }

    public String getMessage(ValidationMessage validationMessage) {
        String code = validationMessage.getCode();
        String message = this.getProperty(code);
        if (message == null) {
            return "";
        }
        int index = 0;
        StringBuilder buf = new StringBuilder();
        while (index < message.length()) {
            int endIndex;
            int startIndex = message.indexOf(PARAM_START, index);
            int n = endIndex = startIndex != -1 ? message.indexOf(PARAM_END, startIndex) : -1;
            if (startIndex != -1) {
                buf.append(message.substring(index, startIndex));
                if (endIndex != -1) {
                    String parameter = message.substring(startIndex + PARAM_START.length(), endIndex);
                    String value = this.getReplacementParameterValue(parameter, validationMessage);
                    buf.append(value);
                    index = endIndex + PARAM_END.length();
                    continue;
                }
                index = startIndex + PARAM_START.length();
                continue;
            }
            buf.append(message.substring(index, message.length()));
            index = message.length();
        }
        return buf.toString();
    }

    private String getReplacementParameterValue(String parameter, ValidationMessage message) {
        List<String> values = message.getParameterValues();
        if (values == null || parameter == null) {
            return "";
        }
        String value = parameter;
        int index = -1;
        try {
            index = Integer.parseInt(parameter);
        }
        catch (NumberFormatException numberFormatException) {
            return value;
        }
        if (index >= 0 && index < values.size()) {
            value = values.get(index);
            if (value == null) {
                value = "";
            }
        } else {
            value = "";
        }
        return value;
    }

    private void loadProperties() throws InvalidPropertiesFormatException, IOException {
        this.load(ValidationMessages.class.getResourceAsStream(RESOURCE_PATH));
    }
}

