/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.ViewAction;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeViewExplorer
extends ViewPart
implements IDoubleClickListener,
ISelectionChangedListener {
    private TreeViewer treeViewer;
    protected Action createAction;
    protected Action viewAction;
    protected Action editAction;
    protected Action deleteAction;
    protected Action refreshAction;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)this.getLayoutData());
        Composite treePanel = new Composite(parent, 2048);
        treePanel.setLayout((Layout)new GridLayout(1, true));
        treePanel.setLayoutData((Object)this.getTreePanelData());
        treePanel.pack();
        this.treeViewer = this.createTreeViewer(treePanel);
        parent.pack();
        this.createActions();
        this.createContextMenu();
        this.createToolbar();
        this.hookGlobalActions();
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void doubleClick(DoubleClickEvent event) {
        this.edit();
    }

    public void refresh() {
        this.treeViewer.getTree().setRedraw(false);
        try {
            Object[] expandedItems = this.getTreeViewer().getExpandedElements();
            this.treeViewer.setInput(this.getInput());
            this.getTreeViewer().setExpandedElements(expandedItems);
        }
        finally {
            this.treeViewer.getTree().setRedraw(true);
        }
    }

    protected void createToolbar() {
        IToolBarManager tbManager = this.getViewSite().getActionBars().getToolBarManager();
        tbManager.add((IAction)this.createAction);
        tbManager.add((IAction)this.viewAction);
        tbManager.add((IAction)this.editAction);
        tbManager.add((IAction)this.deleteAction);
        tbManager.add((IAction)this.refreshAction);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.viewAction);
        mgr.add((IAction)this.editAction);
        mgr.add((IAction)this.deleteAction);
    }

    protected void createActions() {
        this.createAction = new ViewAction(this, "Create"){

            public void performAction() {
                AbstractTreeViewExplorer.this.create();
            }
        };
        this.createAction.setImageDescriptor(Utility.getImageDescriptor("create.png"));
        this.viewAction = new ViewAction(this, "View"){

            public void performAction() {
                AbstractTreeViewExplorer.this.view();
            }
        };
        this.viewAction.setImageDescriptor(Utility.getImageDescriptor("view.png"));
        this.editAction = new ViewAction(this, "Edit"){

            public void performAction() {
                AbstractTreeViewExplorer.this.edit();
            }
        };
        this.editAction.setImageDescriptor(Utility.getImageDescriptor("edit.png"));
        this.deleteAction = new ViewAction(this, "Delete"){

            public void performAction() {
                AbstractTreeViewExplorer.this.delete();
            }
        };
        this.deleteAction.setImageDescriptor(Utility.getImageDescriptor("delete.png"));
        this.refreshAction = new ViewAction(this, "Refresh"){

            public void performAction() {
                AbstractTreeViewExplorer.this.refresh();
            }
        };
        this.refreshAction.setImageDescriptor(Utility.getImageDescriptor("refresh.png"));
    }

    protected ITreeSelection getSelection() {
        return (ITreeSelection)this.treeViewer.getSelection();
    }

    protected abstract List<? extends IWatchPointDTO> getInput();

    protected abstract void create();

    protected abstract void view();

    protected abstract void edit();

    protected abstract void delete();

    protected abstract IContentProvider getContentProvider();

    protected abstract IBaseLabelProvider getLabelProvider();

    private GridData getLayoutData() {
        GridData data = new GridData(4, 4, true, true, 5, 5);
        data.minimumHeight = 300;
        return data;
    }

    private GridData getTreePanelData() {
        GridData data = new GridData(4, 4, true, true);
        return data;
    }

    protected void hookGlobalActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
    }

    protected TreeViewer createTreeViewer(Composite treePanel) {
        TreeViewer viewer = new TreeViewer(treePanel, 4);
        viewer.setContentProvider(this.getContentProvider());
        viewer.setLabelProvider(this.getLabelProvider());
        viewer.setInput(this.getInput());
        viewer.getTree().setLayout((Layout)new GridLayout());
        viewer.getTree().setLayoutData((Object)new GridData(1808));
        viewer.addDoubleClickListener((IDoubleClickListener)this);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        viewer.setComparator(new ViewerComparator());
        return viewer;
    }

    protected void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AbstractTreeViewExplorer.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
    }
}

