/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view;

import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractValidationProvider {
    protected List<ValidationMessage> validationErrors = new ArrayList<ValidationMessage>();
    protected List<ValidationMessage> validationWarnings = new ArrayList<ValidationMessage>();
    protected List<ValidationMessage> validationNotifications = new ArrayList<ValidationMessage>();
    protected String errorString;
    protected String warningString;
    protected String notificationString;

    public AbstractValidationProvider(List<ValidationMessage> validationMessages, String errorColumn, String warningColumn, String notificationColumn) {
        this.errorString = errorColumn;
        this.warningString = warningColumn;
        this.notificationString = notificationColumn;
        this.setInput(validationMessages);
    }

    protected void setInput(List<ValidationMessage> validationMessages) {
        this.validationErrors.clear();
        this.validationWarnings.clear();
        this.validationNotifications.clear();
        for (ValidationMessage message : validationMessages) {
            if (message.getType() == ValidationMessageType.Error) {
                this.validationErrors.add(message);
                continue;
            }
            if (message.getType() == ValidationMessageType.Warning) {
                this.validationWarnings.add(message);
                continue;
            }
            if (message.getType() != ValidationMessageType.Notification) continue;
            this.validationNotifications.add(message);
        }
    }

    protected int getListCount(String listName) {
        if (listName.equals(this.errorString)) {
            return this.validationErrors.size();
        }
        if (listName.equals(this.warningString)) {
            return this.validationWarnings.size();
        }
        if (listName.equals(this.notificationString)) {
            return this.validationNotifications.size();
        }
        return 0;
    }
}

