/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.WatchPointTemplateEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditor;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.ValidationContentProvider;
import com.tandbergtv.watchpoint.studio.ui.view.ValidationLabelProvider;
import com.tandbergtv.watchpoint.studio.ui.view.ViewAction;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationErrorsView
extends ViewPart
implements IPartListener2 {
    private static final String ELEMENT_TYPE_COLUMN = "Element Type";
    private static final String ELEMENT_NAME_COLUMN = "Element Name";
    private static final String DESCRIPTION_COLUMN = "Description";
    private TreeViewer treeViewer;
    private Action validateAction;
    private IValidationService validationService = ValidationServiceFactory.createFactory().createValidationService();
    private ValidationContentProvider contentProvider;

    public void createPartControl(Composite parent) {
        this.setPartName("Validation Errors");
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)this.getLayoutData());
        Composite treePanel = new Composite(parent, 2048);
        treePanel.setLayout((Layout)new GridLayout(1, true));
        treePanel.setLayoutData((Object)this.getTreePanelData());
        treePanel.pack();
        this.createTreeViewer(treePanel);
        parent.pack();
        this.createActions();
        this.createToolbar();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void updateValidationMessages(List<ValidationMessage> messages) {
        ArrayList<ValidationMessage> inputMessages = new ArrayList<ValidationMessage>();
        if (messages != null) {
            inputMessages.addAll(messages);
        }
        this.treeViewer.getTree().setRedraw(false);
        try {
            this.treeViewer.setInput(inputMessages);
            this.treeViewer.expandToLevel(2);
        }
        finally {
            this.treeViewer.getTree().setRedraw(true);
        }
    }

    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this);
    }

    private GridData getTreePanelData() {
        GridData data = new GridData(4, 4, true, true);
        return data;
    }

    private GridData getLayoutData() {
        GridData data = new GridData(4, 4, true, true, 5, 5);
        data.minimumHeight = 300;
        return data;
    }

    private void createTreeViewer(Composite treePanel) {
        this.treeViewer = new TreeViewer(treePanel, 4);
        this.treeViewer.getTree().setHeaderVisible(true);
        Tree tree = this.treeViewer.getTree();
        TreeColumn column = new TreeColumn(tree, 16384);
        column.setText(DESCRIPTION_COLUMN);
        column.setWidth(400);
        column = new TreeColumn(tree, 16384);
        column.setText(ELEMENT_NAME_COLUMN);
        column.setWidth(200);
        column = new TreeColumn(tree, 16384);
        column.setText(ELEMENT_TYPE_COLUMN);
        column.setWidth(200);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.getTree().setLayout((Layout)new GridLayout());
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.contentProvider = new ValidationContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ValidationLabelProvider());
        this.treeViewer.setInput(new ArrayList());
        this.treeViewer.expandAll();
    }

    private void validate() {
        this.updateValidationMessages(null);
        IEditorPart editor = Utility.getActiveEditor();
        if (editor == null) {
            return;
        }
        List<ValidationMessage> messages = null;
        if (editor instanceof WatchPointTemplateEditor) {
            WorkflowTemplate template = ((WatchPointTemplateEditor)editor).getProcessDefinition();
            if (template == null) {
                return;
            }
            messages = this.validationService.validateTemplate(template);
        } else if (editor instanceof NodeDefinitionEditor) {
            NodeDefinition nodeDefinition = ((NodeDefinitionEditor)editor).getNodeDefinition();
            if (nodeDefinition == null) {
                return;
            }
            messages = this.validationService.validateNodeDefinition(nodeDefinition);
        } else if (editor instanceof ResourceTypeEditor) {
            ResourceType resourceType = ((ResourceTypeEditor)editor).getResourceType();
            if (resourceType == null) {
                return;
            }
            messages = this.validationService.validateResourceType(resourceType);
        }
        this.updateValidationMessages(messages);
    }

    private void createActions() {
        this.validateAction = new ViewAction(this, "Validate"){

            public void performAction() {
                ValidationErrorsView.this.validate();
            }
        };
        this.validateAction.setImageDescriptor(Utility.getImageDescriptor("validate.png"));
        this.validateAction.setToolTipText("Validate");
    }

    private void createToolbar() {
        IToolBarManager tbManager = this.getViewSite().getActionBars().getToolBarManager();
        tbManager.add((IAction)this.validateAction);
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }
}

