/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.util.ValidationMessages;
import com.tandbergtv.watchpoint.studio.ui.view.DTONameDecorator;
import com.tandbergtv.watchpoint.studio.ui.view.ValidationMessageGroup;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.jbpm.gd.common.model.NamedElement;

public class ValidationLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String ERROR_IMAGE = "validation_error.png";
    private static final String WARNING_IMAGE = "validation_warning.png";
    private static final String NOTIFICATION_IMAGE = "validation_notification.png";
    private ImageRegistry imageRegistry = new ImageRegistry();

    public ValidationLabelProvider() {
        String key = ValidationMessageType.Error.name();
        this.imageRegistry.put(key, Utility.getImageDescriptor(ERROR_IMAGE));
        key = ValidationMessageType.Warning.name();
        this.imageRegistry.put(key, Utility.getImageDescriptor(WARNING_IMAGE));
        key = ValidationMessageType.Notification.name();
        this.imageRegistry.put(key, Utility.getImageDescriptor(NOTIFICATION_IMAGE));
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0 || !(element instanceof ValidationMessage)) {
            return null;
        }
        ValidationMessage message = (ValidationMessage)element;
        return this.getMessageImage(message.getType());
    }

    private Image getMessageImage(ValidationMessageType messageType) {
        if (messageType == null) {
            return null;
        }
        return this.imageRegistry.get(messageType.name());
    }

    public String getColumnText(Object element, int columnIndex) {
        String columnText;
        block15: {
            block14: {
                columnText = "";
                if (!(element instanceof ValidationMessage)) break block14;
                ValidationMessage message = (ValidationMessage)element;
                switch (columnIndex) {
                    case 0: {
                        try {
                            columnText = ValidationMessages.getInstance().getMessage(message);
                            break;
                        }
                        catch (Exception e) {
                            throw new UIException("Could not read validation message " + message.getCode() + " from property file.", e);
                        }
                    }
                    case 1: {
                        if (message.getElement() instanceof NamedElement) {
                            columnText = ((NamedElement)message.getElement()).getName();
                            break;
                        }
                        if (message.getElement() instanceof IWatchPointDTO) {
                            columnText = new DTONameDecorator((IWatchPointDTO)message.getElement()).getName();
                            break;
                        }
                        break block15;
                    }
                    case 2: {
                        if (message.getElement() instanceof NamedElement) {
                            columnText = ((NamedElement)message.getElement()).getLabel();
                            break;
                        }
                        if (!(message.getElement() instanceof IWatchPointDTO)) break block15;
                        columnText = new DTONameDecorator((IWatchPointDTO)message.getElement()).getType();
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block15;
            }
            if (element instanceof ValidationMessageGroup && columnIndex == 0) {
                ValidationMessageGroup group = (ValidationMessageGroup)element;
                int count = group.getMessages() != null ? group.getMessages().size() : 0;
                columnText = String.valueOf(this.getDisplayText(group.getMessageType())) + " (" + count + " items)";
            }
        }
        return columnText;
    }

    private String getDisplayText(ValidationMessageType messageType) {
        String text = "Undefined";
        if (messageType == null) {
            return text;
        }
        switch (messageType) {
            case Error: {
                text = "Errors";
                break;
            }
            case Warning: {
                text = "Warnings";
                break;
            }
            case Notification: {
                text = "Notifications";
            }
        }
        return text;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void dispose() {
        super.dispose();
        if (this.imageRegistry != null) {
            this.imageRegistry.dispose();
            this.imageRegistry = null;
        }
    }
}

