/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view.nodedefinition;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.lock.ILockable;
import com.tandbergtv.watchpoint.studio.service.INodeDefinitionService;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.LockFailureException;
import com.tandbergtv.watchpoint.studio.service.ReferenceDeletionException;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.TemplateResourcesUtility;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.NonPersistableFileEditorInput;
import com.tandbergtv.watchpoint.studio.ui.util.ServiceErrors;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.AbstractTreeViewExplorer;
import com.tandbergtv.watchpoint.studio.ui.view.DefaultContentProvider;
import com.tandbergtv.watchpoint.studio.ui.view.nodedefinition.NodeDefinitionLabelProvider;
import com.tandbergtv.watchpoint.studio.ui.wizard.NewNodeDefinitionWizard;
import com.tandbergtv.watchpoint.studio.usermgmt.User;
import com.tandbergtv.watchpoint.studio.usermgmt.UserManagementException;
import com.tandbergtv.watchpoint.studio.usermgmt.UserManager;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDefinitionExplorer
extends AbstractTreeViewExplorer {
    private static final Logger logger = Logger.getLogger(NodeDefinitionExplorer.class);
    private static final String LINE_SEPRATOR = "line.separator";
    INodeDefinitionService nodeDefinitionService;
    private IResourceTypeService rtService;
    private Map<ResourceType, List<NodeDefinitionDTO>> resourceTypeNodeDefinitions = new HashMap<ResourceType, List<NodeDefinitionDTO>>();
    private NodeDefinitionContentProvider contentProvider = new NodeDefinitionContentProvider();

    public NodeDefinitionExplorer() {
        this.nodeDefinitionService = ServiceFactory.createFactory().createNodeDefinitionService();
        this.rtService = ServiceFactory.createFactory().createResourceTypeService();
    }

    @Override
    protected void create() {
        if (!Utility.closeEditor("com.tandbergtv.jpdl.nodedefinitioneditor", true)) {
            return;
        }
        this.openCreateWizard();
        this.refresh();
    }

    @Override
    protected void delete() {
        boolean response;
        ITreeSelection sel = this.getSelection();
        NodeDefinitionDTO nodeDefSelected = (NodeDefinitionDTO)((TreeSelection)sel).getFirstElement();
        if (nodeDefSelected == null) {
            return;
        }
        String message = "Are you sure you want to delete node definition '" + nodeDefSelected.getName() + "'?";
        NodeDefinitionEditor editor = (NodeDefinitionEditor)Utility.getEditor("com.tandbergtv.jpdl.nodedefinitioneditor");
        if (editor != null && nodeDefSelected.getName().equals(editor.getNodeDefinitionDTOName())) {
            message = String.valueOf(message) + " Any changes to the node definition will be lost.";
        }
        if (!(response = MessageDialog.openConfirm((Shell)super.getSite().getShell(), (String)"Confirm Delete", (String)message))) {
            return;
        }
        try {
            this.nodeDefinitionService.deleteNodeDefinition(nodeDefSelected.getId(), Utility.getUserName(), false);
        }
        catch (ReferenceDeletionException e) {
            String msg = this.buildReferenceDeletionErrorMsg(e.getReferences());
            boolean removeReferences = MessageDialog.openConfirm((Shell)super.getSite().getShell(), (String)"Remove References?", (String)msg);
            if (!removeReferences) {
                return;
            }
            this.nodeDefinitionService.deleteNodeDefinition(nodeDefSelected.getId(), Utility.getUserName(), true);
        }
        catch (ServiceException e) {
            Utility.handleException(ServiceErrors.getInstance().getProperty(e.getServiceErrorCode().getCode()), e);
        }
        if (editor == null || nodeDefSelected.getName().equals(editor.getNodeDefinitionDTOName())) {
            Utility.closeEditor("com.tandbergtv.jpdl.nodedefinitioneditor", false);
        }
        this.refresh();
    }

    @Override
    protected void edit() {
        boolean outOfBox;
        ITreeSelection sel = this.getSelection();
        Object element = ((TreeSelection)this.getSelection()).getFirstElement();
        if (element instanceof NodeDefinitionDTO && (outOfBox = ((NodeDefinitionDTO)element).getResourceType().isOutOfTheBox())) {
            return;
        }
        this.openNodeDefinition((ISelection)sel, true);
        this.refresh();
        Utility.updateValidationErrors(this.getSite(), new ArrayList<ValidationMessage>());
    }

    @Override
    protected void view() {
        ITreeSelection sel = this.getSelection();
        this.openNodeDefinition((ISelection)sel, false);
    }

    @Override
    protected List<? extends IWatchPointDTO> getInput() {
        this.resourceTypeNodeDefinitions = this.getNodeDefinitionsByResourceType();
        List<ResourceType> resourceTypeList = this.rtService.getViewableResourceTypeList();
        return resourceTypeList;
    }

    @Override
    protected IContentProvider getContentProvider() {
        return this.contentProvider;
    }

    @Override
    protected IBaseLabelProvider getLabelProvider() {
        return new NodeDefinitionLabelProvider();
    }

    private void openNodeDefinition(ISelection sel, boolean edit) {
        Object element = ((TreeSelection)this.getSelection()).getFirstElement();
        if (element instanceof NodeDefinitionDTO) {
            if (!Utility.closeEditor("com.tandbergtv.jpdl.nodedefinitioneditor", true)) {
                return;
            }
            NodeDefinitionDTO nodeDefinitionSelected = (NodeDefinitionDTO)((TreeSelection)sel).getFirstElement();
            if (nodeDefinitionSelected == null) {
                return;
            }
            NodeDefinitionDTO nodeDefinition = null;
            try {
                if (edit) {
                    if (!this.requestEditConfirmation(nodeDefinitionSelected)) {
                        return;
                    }
                    try {
                        nodeDefinition = this.nodeDefinitionService.getNodeDefinitionForEdit(nodeDefinitionSelected.getId(), Utility.getUserName(), false);
                    }
                    catch (LockFailureException e) {
                        ILockable lockableEntity = e.getLockableEntity();
                        String userId = lockableEntity.getLock().getOwnerId();
                        String userDisplayMessage = this.getUserDisplayMessage(userId);
                        boolean override = MessageDialog.openConfirm((Shell)super.getSite().getShell(), (String)"Override Lock?", (String)("The node definition " + nodeDefinitionSelected.getName() + " is locked by " + userDisplayMessage + ", do you wish to override the lock?"));
                        if (!override) {
                            return;
                        }
                        nodeDefinition = this.nodeDefinitionService.getNodeDefinitionForEdit(nodeDefinitionSelected.getId(), Utility.getUserName(), true);
                    }
                } else {
                    nodeDefinition = this.nodeDefinitionService.getNodeDefinitionForView(nodeDefinitionSelected.getId());
                }
            }
            catch (ServiceException e) {
                Utility.handleException(ServiceErrors.getInstance().getProperty(e.getServiceErrorCode().getCode()), e);
                return;
            }
            IFile gpdFile = TemplateResourcesUtility.createNodeDefinitionFile(nodeDefinition.getXml(), nodeDefinition.getGpd());
            try {
                IDE.openEditor((IWorkbenchPage)this.getSite().getPage(), (IEditorInput)new NonPersistableFileEditorInput(gpdFile, nodeDefinition), (String)"com.tandbergtv.jpdl.nodedefinitioneditor");
            }
            catch (PartInitException e) {
                throw new UIException("Error opening WatchPoint Node Definition Editor.", e);
            }
        }
    }

    private boolean requestEditConfirmation(NodeDefinitionDTO nodeDefinition) {
        long id = nodeDefinition.getId();
        boolean usedByNodeDefinition = false;
        boolean usedByTemplate = false;
        try {
            usedByNodeDefinition = this.nodeDefinitionService.isUsedByNodeDefinition(id);
            usedByTemplate = this.nodeDefinitionService.isUsedByTemplate(id);
        }
        catch (Exception ex) {
            Utility.reportError("Failed to get the Node Definition.", ex);
            return false;
        }
        if (!usedByNodeDefinition && !usedByTemplate) {
            return true;
        }
        String lineSeparator = System.getProperty(LINE_SEPRATOR);
        StringBuilder buf = new StringBuilder();
        buf.append("The Node Definition is being used by existing ");
        if (usedByNodeDefinition) {
            buf.append("Node Definition(s)");
        }
        if (usedByNodeDefinition && usedByTemplate) {
            buf.append(" and ");
        }
        if (usedByTemplate) {
            buf.append("Template(s)");
        }
        buf.append(".");
        buf.append(" Changes made to this Node Definition will not be reflected.");
        buf.append(lineSeparator);
        buf.append(lineSeparator);
        buf.append("Are you sure you wish to edit this Node Definition?");
        Shell parent = this.getSite().getShell();
        return MessageDialog.openConfirm((Shell)parent, (String)this.getTitle(), (String)buf.toString());
    }

    private String getUserDisplayMessage(String userId) {
        String msg = null;
        try {
            User user = UserManager.getInstance().getUser(userId);
            msg = String.valueOf(user.getUserName()) + " from machine " + user.getIpAddress();
        }
        catch (UserManagementException e) {
            logger.error((Object)"Failed to get the User object.", (Throwable)e);
            msg = userId;
        }
        return msg;
    }

    private void openCreateWizard() {
        IWorkbench workbench = super.getSite().getWorkbenchWindow().getWorkbench();
        NewNodeDefinitionWizard wizard = new NewNodeDefinitionWizard();
        wizard.init(workbench, (IStructuredSelection)new StructuredSelection());
        WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.open();
    }

    private String buildReferenceDeletionErrorMsg(List<IWatchPointDTO> references) {
        String message = "";
        HashSet<String> templateSet = new HashSet<String>();
        HashSet<String> nodeDefSet = new HashSet<String>();
        for (IWatchPointDTO dto : references) {
            if (dto instanceof NodeDefinitionDTO) {
                nodeDefSet.add(((NodeDefinitionDTO)dto).getName());
                continue;
            }
            if (!(dto instanceof WorkflowTemplateDTO)) continue;
            templateSet.add(((WorkflowTemplateDTO)dto).getName());
        }
        if (templateSet.size() > 0) {
            message = String.valueOf(message) + "The node definition is being used by the following templates: " + templateSet + "." + System.getProperty(LINE_SEPRATOR);
        }
        if (nodeDefSet.size() > 0) {
            message = String.valueOf(message) + "The node definition is being used by the following node definitions: " + nodeDefSet + "." + System.getProperty(LINE_SEPRATOR);
        }
        message = String.valueOf(message) + "Are you sure you want to delete this node definition?";
        return message;
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        Object element = ((TreeSelection)selection).getFirstElement();
        if (element instanceof ResourceType) {
            ResourceType rtSelected = (ResourceType)element;
            if (rtSelected != null) {
                this.deleteAction.setEnabled(false);
                this.editAction.setEnabled(false);
                this.viewAction.setEnabled(false);
            }
        } else {
            NodeDefinitionDTO ndSelected = (NodeDefinitionDTO)element;
            if (ndSelected != null) {
                this.deleteAction.setEnabled(!ndSelected.getResourceType().isOutOfTheBox());
                this.editAction.setEnabled(!ndSelected.getResourceType().isOutOfTheBox());
                this.viewAction.setEnabled(true);
            }
        }
    }

    private Map<ResourceType, List<NodeDefinitionDTO>> getNodeDefinitionsByResourceType() {
        List<NodeDefinitionDTO> nodeDefinitions = this.nodeDefinitionService.getAllNodeDefinitions();
        HashMap<ResourceType, List<NodeDefinitionDTO>> resourceTypeNodeDefinitions = new HashMap<ResourceType, List<NodeDefinitionDTO>>();
        for (NodeDefinitionDTO nodeDefinition : nodeDefinitions) {
            if (nodeDefinition.getResourceType() == null) continue;
            ResourceType resourceType = nodeDefinition.getResourceType();
            ArrayList<NodeDefinitionDTO> tempNodeDefinitionList = (ArrayList<NodeDefinitionDTO>)resourceTypeNodeDefinitions.get(resourceType);
            if (tempNodeDefinitionList == null) {
                tempNodeDefinitionList = new ArrayList<NodeDefinitionDTO>();
                tempNodeDefinitionList.add(nodeDefinition);
                resourceTypeNodeDefinitions.put(resourceType, tempNodeDefinitionList);
                continue;
            }
            tempNodeDefinitionList.add(nodeDefinition);
            resourceTypeNodeDefinitions.put(resourceType, tempNodeDefinitionList);
        }
        return resourceTypeNodeDefinitions;
    }

    private class NodeDefinitionContentProvider
    extends DefaultContentProvider {
        private NodeDefinitionContentProvider() {
        }

        public Object[] getChildren(Object element) {
            Object[] result = null;
            if (element instanceof ResourceType) {
                ResourceType resourceType = (ResourceType)element;
                List nodeDefinitions = (List)NodeDefinitionExplorer.this.resourceTypeNodeDefinitions.get(resourceType);
                if (nodeDefinitions != null) {
                    result = nodeDefinitions.toArray();
                }
            } else {
                result = super.getChildren(element);
            }
            return result;
        }

        public Object getParent(Object element) {
            Object parent = null;
            if (element instanceof NodeDefinitionDTO) {
                NodeDefinitionDTO nodeDefinition = (NodeDefinitionDTO)element;
                parent = nodeDefinition.getResourceType();
            } else {
                parent = super.getParent(element);
            }
            return parent;
        }

        public boolean hasChildren(Object element) {
            boolean result = false;
            if (element instanceof ResourceType) {
                ResourceType resourceType = (ResourceType)element;
                List nodeDefinitions = (List)NodeDefinitionExplorer.this.resourceTypeNodeDefinitions.get(resourceType);
                result = nodeDefinitions != null && nodeDefinitions.size() > 0;
            } else {
                result = super.hasChildren(element);
            }
            return result;
        }
    }
}

