/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view.nodedefinition;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class NodeDefinitionLabelProvider
extends LabelProvider
implements ILabelProvider {
    private static final String NODE_DEFINITION_IMAGE_PATH = "icon_node.png";
    private static final String RESOURCE_TYPE_IMAGE_PATH = "resource_type.png";
    private static final String LOCKED_IMAGE_PATH = "node_locked_else.png";
    private static final String LOCKEDBYME_IMAGE_PATH = "node_locked_self.png";

    public String getText(Object element) {
        String name = null;
        if (element instanceof ResourceType) {
            ResourceType resourceType = (ResourceType)element;
            name = String.valueOf(resourceType.getName()) + " [" + resourceType.getSystemId() + "]";
        } else {
            name = element instanceof NodeDefinitionDTO ? ((NodeDefinitionDTO)element).getName() : super.getText(element);
        }
        return name;
    }

    public Image getImage(Object element) {
        Image image = null;
        String imagePath = null;
        if (element instanceof ResourceType) {
            imagePath = RESOURCE_TYPE_IMAGE_PATH;
            image = this.createImage(imagePath);
        } else if (element instanceof NodeDefinitionDTO) {
            NodeDefinitionDTO nodeDefinition = (NodeDefinitionDTO)element;
            imagePath = nodeDefinition.getLock() == null ? NODE_DEFINITION_IMAGE_PATH : (nodeDefinition.getLock().getOwnerId().equals(Utility.getUserName()) ? LOCKEDBYME_IMAGE_PATH : LOCKED_IMAGE_PATH);
            image = this.createImage(imagePath);
        } else {
            image = super.getImage(element);
        }
        return image;
    }

    private Image createImage(String path) {
        if (path == null) {
            return null;
        }
        ImageDescriptor descriptor = Utility.getImageDescriptor(path);
        return new Image((Device)Display.getCurrent(), descriptor.getImageData());
    }
}

