/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view.resourcegroup;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceGroupService;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.AbstractTreeViewExplorer;
import com.tandbergtv.watchpoint.studio.ui.view.DefaultContentProvider;
import com.tandbergtv.watchpoint.studio.ui.view.ViewAction;
import com.tandbergtv.watchpoint.studio.ui.view.resourcegroup.ResourceGroupLabelProvider;
import com.tandbergtv.watchpoint.studio.ui.wizard.ResourceGroupExportWizard;
import com.tandbergtv.watchpoint.studio.ui.wizard.ResourceGroupWizard;
import com.tandbergtv.watchpoint.studio.ui.wizard.ResourceGroupWizardPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceGroupExplorer
extends AbstractTreeViewExplorer {
    private IResourceGroupService rgService;
    private Action exportAction;
    private IResourceTypeService rtService;
    private ResourceGroupContentProvider contentProvider = new ResourceGroupContentProvider();
    private Map<ResourceType, List<ResourceGroup>> resourceTypeGroups = new HashMap<ResourceType, List<ResourceGroup>>();

    public ResourceGroupExplorer() {
        ServiceFactory serviceFactory = ServiceFactory.createFactory();
        this.rgService = serviceFactory.createResourceGroupService();
        this.rtService = serviceFactory.createResourceTypeService();
    }

    @Override
    protected List<? extends IWatchPointDTO> getInput() {
        this.resourceTypeGroups = this.getResourceGroupsByResourceType();
        List<ResourceType> resourceTypeList = this.rtService.getViewableResourceTypeList();
        return resourceTypeList;
    }

    @Override
    protected IContentProvider getContentProvider() {
        return this.contentProvider;
    }

    @Override
    protected IBaseLabelProvider getLabelProvider() {
        return new ResourceGroupLabelProvider();
    }

    @Override
    protected void create() {
        if (this.openWizard((IWizard)new ResourceGroupWizard(ResourceGroupWizardPage.Mode.CREATE, null))) {
            this.refresh();
        }
    }

    @Override
    protected void view() {
        ResourceGroup rgSelected = (ResourceGroup)((TreeSelection)this.getSelection()).getFirstElement();
        if (rgSelected == null) {
            MessageDialog.openInformation((Shell)super.getSite().getShell(), (String)"Select Resource Group", (String)"Please select a Resource Group to view.");
            return;
        }
        this.openWizard((IWizard)new ResourceGroupWizard(ResourceGroupWizardPage.Mode.VIEW, rgSelected));
    }

    @Override
    protected void edit() {
        Object element = ((TreeSelection)this.getSelection()).getFirstElement();
        if (element instanceof ResourceGroup) {
            ResourceGroup rgSelected = (ResourceGroup)element;
            if (rgSelected == null) {
                MessageDialog.openInformation((Shell)super.getSite().getShell(), (String)"Select Resource Group", (String)"Please select a Resource Group to edit.");
                return;
            }
            if (this.openWizard((IWizard)new ResourceGroupWizard(ResourceGroupWizardPage.Mode.EDIT, rgSelected))) {
                this.refresh();
            }
        }
    }

    @Override
    protected void delete() {
        ResourceGroup rgSelected = (ResourceGroup)((TreeSelection)this.getSelection()).getFirstElement();
        if (rgSelected == null) {
            MessageDialog.openInformation((Shell)super.getSite().getShell(), (String)"Select Resource Group", (String)"Please select a Resource Group to delete.");
            return;
        }
        String message = "Are you sure you want to delete the resource group '" + rgSelected.getName() + "'?";
        boolean response = MessageDialog.openConfirm((Shell)super.getSite().getShell(), (String)"Confirm Delete", (String)message);
        if (!response) {
            return;
        }
        try {
            this.rgService.deleteResourceGroup(rgSelected);
        }
        catch (Exception e) {
            Utility.reportError("Resource Group Deletion Failed", e);
        }
        this.refresh();
    }

    @Override
    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        mgr.add((IAction)this.exportAction);
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        IToolBarManager tbManager = this.getViewSite().getActionBars().getToolBarManager();
        tbManager.add((IAction)this.exportAction);
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.exportAction = new ViewAction(this, "Export"){

            public void performAction() {
                ResourceGroup rgSelected = (ResourceGroup)((TreeSelection)ResourceGroupExplorer.this.getSelection()).getFirstElement();
                if (rgSelected == null) {
                    MessageDialog.openInformation((Shell)ResourceGroupExplorer.this.getSite().getShell(), (String)"Select Resource Group", (String)"Please select a Resource Group to export.");
                    return;
                }
                ResourceGroupExplorer.this.openWizard((IWizard)new ResourceGroupExportWizard(rgSelected));
            }
        };
        this.exportAction.setImageDescriptor(Utility.getImageDescriptor("export.png"));
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        Object element = ((TreeSelection)selection).getFirstElement();
        if (element instanceof ResourceType) {
            ResourceType rgSelected = (ResourceType)element;
            if (rgSelected != null) {
                this.deleteAction.setEnabled(false);
                this.createAction.setEnabled(true);
                this.editAction.setEnabled(false);
                this.viewAction.setEnabled(false);
                this.exportAction.setEnabled(false);
            }
        } else {
            ResourceGroup rgSelected = (ResourceGroup)element;
            if (rgSelected != null) {
                this.createAction.setEnabled(true);
                this.editAction.setEnabled(true);
                this.viewAction.setEnabled(true);
                this.exportAction.setEnabled(true);
                this.deleteAction.setEnabled(rgSelected.getVersion() == 1 && rgSelected.isDirty());
            }
        }
    }

    private boolean openWizard(IWizard wizard) {
        WizardDialog dialog;
        IWorkbench workbench = super.getSite().getWorkbenchWindow().getWorkbench();
        if (wizard instanceof INewWizard) {
            ((INewWizard)wizard).init(workbench, (IStructuredSelection)new StructuredSelection());
        }
        return (dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), wizard)).open() == 0;
    }

    private Map<ResourceType, List<ResourceGroup>> getResourceGroupsByResourceType() {
        List<ResourceGroup> resourceGroups = this.rgService.getAllResourceGroups();
        HashMap<ResourceType, List<ResourceGroup>> resourceTypeGroups = new HashMap<ResourceType, List<ResourceGroup>>();
        for (ResourceGroup resourceGroup : resourceGroups) {
            if (resourceGroup.getResourceType() == null) continue;
            ResourceType resourceType = resourceGroup.getResourceType();
            ArrayList<ResourceGroup> resourceGroupList = (ArrayList<ResourceGroup>)resourceTypeGroups.get(resourceType);
            if (resourceGroupList == null) {
                resourceGroupList = new ArrayList<ResourceGroup>();
                resourceGroupList.add(resourceGroup);
                resourceTypeGroups.put(resourceType, resourceGroupList);
                continue;
            }
            resourceGroupList.add(resourceGroup);
            resourceTypeGroups.put(resourceType, resourceGroupList);
        }
        return resourceTypeGroups;
    }

    private class ResourceGroupContentProvider
    extends DefaultContentProvider {
        private ResourceGroupContentProvider() {
        }

        public Object[] getChildren(Object element) {
            Object[] result = null;
            if (element instanceof ResourceType) {
                ResourceType resourceType = (ResourceType)element;
                List resourceGroups = (List)ResourceGroupExplorer.this.resourceTypeGroups.get(resourceType);
                if (resourceGroups != null) {
                    result = resourceGroups.toArray();
                }
            } else {
                result = super.getChildren(element);
            }
            return result;
        }

        public Object getParent(Object element) {
            Object parent = null;
            if (element instanceof ResourceGroup) {
                ResourceGroup resourceGroup = (ResourceGroup)element;
                parent = resourceGroup.getResourceType();
            } else {
                parent = super.getParent(element);
            }
            return parent;
        }

        public boolean hasChildren(Object element) {
            boolean result = false;
            if (element instanceof ResourceType) {
                ResourceType resourceType = (ResourceType)element;
                List resourceGroups = (List)ResourceGroupExplorer.this.resourceTypeGroups.get(resourceType);
                result = resourceGroups != null && resourceGroups.size() > 0;
            } else {
                result = super.hasChildren(element);
            }
            return result;
        }
    }
}

