/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view.resourcegroup;

import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ResourceGroupLabelProvider
extends LabelProvider {
    private static final String RESOURCE_TYPE_IMAGE_PATH = "resource_type.png";
    private static final String RESOURCE_GROUP_IMAGE_PATH = "resource_group.png";

    public String getText(Object element) {
        String name = null;
        if (element instanceof ResourceType) {
            ResourceType resourceType = (ResourceType)element;
            name = String.valueOf(resourceType.getName()) + " [" + resourceType.getSystemId() + "]";
        } else {
            name = element instanceof ResourceGroup ? ((ResourceGroup)element).getName() : super.getText(element);
        }
        return name;
    }

    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof ResourceType) {
            String imagePath = RESOURCE_TYPE_IMAGE_PATH;
            image = this.createImage(imagePath);
        } else if (element instanceof ResourceGroup) {
            String imagePath = RESOURCE_GROUP_IMAGE_PATH;
            image = this.createImage(imagePath);
        } else {
            image = super.getImage(element);
        }
        return image;
    }

    private Image createImage(String path) {
        if (path == null) {
            return null;
        }
        ImageDescriptor descriptor = Utility.getImageDescriptor(path);
        return new Image((Device)Display.getCurrent(), descriptor.getImageData());
    }
}

