/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view.resourcetype;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.editor.input.IInputChangedListener;
import com.tandbergtv.watchpoint.studio.ui.editor.input.IWatchPointEditorInput;
import com.tandbergtv.watchpoint.studio.ui.editor.input.InputChangedEvent;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditorInput;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.AbstractTreeViewExplorer;
import com.tandbergtv.watchpoint.studio.ui.view.DefaultContentProvider;
import com.tandbergtv.watchpoint.studio.ui.view.ViewAction;
import com.tandbergtv.watchpoint.studio.ui.wizard.ResourceTypeExportWizard;
import com.tandbergtv.watchpoint.studio.ui.wizard.ResourceTypeWizard;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTypeExplorer
extends AbstractTreeViewExplorer {
    private static final String RESOURCE_TYPE_IMAGE_PATH = "resource_type.png";
    private static final String INCOMING_MESSAGE_IMAGE_PATH = "message_incoming.png";
    private static final String OUTGOING_MESSAGE_IMAGE_PATH = "message_outgoing.png";
    private ServiceFactory serviceFactory;
    private IResourceTypeService service;
    private ResourceTypeContentProvider contentProvider = new ResourceTypeContentProvider();
    private Action exportAction;

    public ResourceTypeExplorer() {
        this.serviceFactory = ServiceFactory.createFactory();
        this.service = this.serviceFactory.createResourceTypeService();
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        IToolBarManager tbManager = this.getViewSite().getActionBars().getToolBarManager();
        tbManager.add((IAction)this.exportAction);
    }

    @Override
    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.createAction);
        Object selectedObject = this.getSelectedObject();
        if (selectedObject instanceof ResourceType || selectedObject instanceof Message) {
            mgr.add((IAction)this.viewAction);
            mgr.add((IAction)this.editAction);
            mgr.add((IAction)this.deleteAction);
            mgr.add((IAction)this.exportAction);
        }
        mgr.add((IAction)this.refreshAction);
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.exportAction = new ViewAction(this, "Export", Utility.getImageDescriptor("export.png")){

            public void performAction() {
                ResourceTypeExplorer.this.export();
            }
        };
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        Object element = this.getSelectedObject();
        if (element == null) {
            return;
        }
        ResourceType resourceType = element instanceof ResourceType ? (ResourceType)element : ((Message)element).getResourceType();
        this.editAction.setEnabled(!resourceType.isOutOfTheBox());
        this.deleteAction.setEnabled(!resourceType.isOutOfTheBox());
        this.exportAction.setEnabled(!resourceType.isOutOfTheBox());
    }

    @Override
    protected void create() {
        Shell shell = this.getSite().getShell();
        ResourceTypeWizard resourceTypeWizard = new ResourceTypeWizard();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)resourceTypeWizard);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.showBusy(true);
            try {
                ResourceType resourceType = resourceTypeWizard.getResourceType();
                this.addResourceTypeToTree(resourceType);
                ResourceTypeEditorInput input = new ResourceTypeEditorInput(resourceType);
                input.addInputChangedListener(new ResourceTypeEditorInputChangedListener());
                this.showResourceTypeEditor(input);
            }
            finally {
                this.showBusy(false);
            }
        }
    }

    @Override
    protected void view() {
        this.openSelectedResourceTypeInEditor(false);
    }

    @Override
    protected void edit() {
        this.openSelectedResourceTypeInEditor(true);
    }

    @Override
    protected void delete() {
        long resourceTypeId;
        ResourceType resourceType = this.getSelectedResourceType();
        long l = resourceTypeId = resourceType != null ? resourceType.getId() : -1L;
        if (resourceTypeId == -1L) {
            return;
        }
        if (!this.requestDeleteConfirmation(resourceType)) {
            return;
        }
        this.showBusy(true);
        try {
            if (this.deleteResourceType(resourceTypeId)) {
                this.removeResourceTypeFromTree(resourceType);
                IWorkbenchPage page = this.getSite().getPage();
                ResourceType editedType = new ResourceType(resourceTypeId);
                IEditorPart editorPart = page.findEditor((IEditorInput)new ResourceTypeEditorInput(editedType));
                if (editorPart != null) {
                    page.closeEditor(editorPart, false);
                }
            }
        }
        finally {
            this.showBusy(false);
        }
    }

    protected void export() {
        long resourceTypeId;
        ResourceType resourceType = this.getSelectedResourceType();
        long l = resourceTypeId = resourceType != null ? resourceType.getId() : -1L;
        if (resourceTypeId == -1L) {
            return;
        }
        Shell shell = this.getSite().getShell();
        ResourceType resourceTypeForExport = new ResourceType();
        resourceTypeForExport.setId(resourceTypeId);
        ResourceTypeExportWizard exportWizard = new ResourceTypeExportWizard(resourceTypeForExport);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)exportWizard);
        dialog.open();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void openSelectedResourceTypeInEditor(boolean editable) {
        ResourceType resourceType = this.getSelectedResourceType();
        if (resourceType == null) return;
        long l = resourceType.getId();
        long resourceTypeId = l;
        if (resourceTypeId == -1L) {
            return;
        }
        this.showBusy(true);
        try {
            resourceType = this.getLatestResourceType(resourceTypeId);
            if (resourceType == null) {
                return;
            }
            if (editable && resourceType.isOutOfTheBox()) {
                MessageDialog.openInformation((Shell)super.getSite().getShell(), (String)"Error", (String)"The Reource Type is out-of-the-box, cannot edit.");
                return;
            }
            Message message = this.getSelectedMessage();
            ResourceTypeEditorInput input = null;
            input = new ResourceTypeEditorInput(resourceType, message, editable);
            input.addInputChangedListener(new ResourceTypeEditorInputChangedListener());
            this.showResourceTypeEditor(input);
            return;
        }
        finally {
            this.showBusy(false);
        }
    }

    private boolean requestDeleteConfirmation(ResourceType resourceType) {
        String msg = "Are you sure you wish to delete Resource Type: " + resourceType.getName() + "?";
        Shell parent = this.getSite().getShell();
        return MessageDialog.openConfirm((Shell)parent, (String)this.getTitle(), (String)msg);
    }

    private IEditorPart showResourceTypeEditor(IEditorInput input) {
        IEditorPart editorPart = null;
        try {
            IWorkbenchPage workbenchPage = this.getSite().getPage();
            editorPart = IDE.openEditor((IWorkbenchPage)workbenchPage, (IEditorInput)input, (String)"com.tandbergtv.watchpoint.studio.ui.editor.ResourceTypeEditor", (boolean)true);
        }
        catch (PartInitException ex) {
            this.showBusy(false);
            Utility.reportError("Failed to open the Resource Type Editor.", (Exception)((Object)ex));
        }
        return editorPart;
    }

    private ResourceType getLatestResourceType(long resourceTypeId) {
        ResourceType resourceType = null;
        try {
            resourceType = this.service.getResourceType(resourceTypeId);
        }
        catch (Exception ex) {
            this.showBusy(false);
            Utility.reportError("Failed to get the Resource Type.", ex);
        }
        return resourceType;
    }

    private boolean deleteResourceType(long resourceTypeId) {
        boolean result = true;
        try {
            this.service.deleteResourceType(resourceTypeId);
        }
        catch (Exception ex) {
            result = false;
            this.showBusy(false);
            Utility.reportError("Failed to delete the Resource Type.", ex);
        }
        return result;
    }

    private ResourceType getSelectedResourceType() {
        ResourceType selectedResourceType = null;
        Object selectedObject = this.getSelectedObject();
        if (selectedObject instanceof ResourceType) {
            selectedResourceType = (ResourceType)selectedObject;
        } else if (selectedObject instanceof Message) {
            Message message = (Message)selectedObject;
            selectedResourceType = message.getResourceType();
        }
        return selectedResourceType;
    }

    private Message getSelectedMessage() {
        Message selectedMessage = null;
        Object selectedObject = this.getSelectedObject();
        if (selectedObject instanceof Message) {
            selectedMessage = (Message)selectedObject;
        }
        return selectedMessage;
    }

    private Object getSelectedObject() {
        Object selectedObject = null;
        ITreeSelection selection = this.getSelection();
        if (selection != null) {
            selectedObject = selection.getFirstElement();
        }
        return selectedObject;
    }

    @Override
    protected IContentProvider getContentProvider() {
        return this.contentProvider;
    }

    @Override
    protected IBaseLabelProvider getLabelProvider() {
        return new ResourceTypeLabelProvider();
    }

    @Override
    protected List<? extends IWatchPointDTO> getInput() {
        List<ResourceType> resourceTypes = null;
        try {
            resourceTypes = this.service.getResourceTypeList();
        }
        catch (Exception ex) {
            Utility.reportError("Failed to get the list of Resource Types.", ex);
        }
        return resourceTypes;
    }

    private void addResourceTypeToTree(ResourceType resourceType) {
        this.contentProvider.addResourceType(resourceType);
        StructuredSelection selection = new StructuredSelection((Object)resourceType);
        this.getTreeViewer().setSelection((ISelection)selection, true);
    }

    private void updateResourceTypeInTree(ResourceType resourceType) {
        ITreeSelection selection = this.getSelection();
        boolean expandedState = this.getTreeViewer().getExpandedState((Object)resourceType);
        this.getTreeViewer().getTree().setRedraw(false);
        try {
            this.contentProvider.replaceResourceType(resourceType);
            this.getTreeViewer().setExpandedState((Object)resourceType, expandedState);
            this.getTreeViewer().setSelection((ISelection)selection);
        }
        finally {
            this.getTreeViewer().getTree().setRedraw(true);
        }
    }

    private void removeResourceTypeFromTree(ResourceType resourceType) {
        this.contentProvider.removeResourceType(resourceType);
    }

    private class ResourceTypeContentProvider
    extends DefaultContentProvider {
        private Collection<ResourceType> input = null;

        private ResourceTypeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            this.input = (Collection)inputElement;
            List resourceTypeList = (List)inputElement;
            return super.getElements((Object)resourceTypeList);
        }

        public Object[] getChildren(Object element) {
            Object[] result = null;
            if (element instanceof ResourceType) {
                ResourceType resourceType = (ResourceType)element;
                Set<Message> messages = resourceType.getMessages();
                if (messages != null) {
                    result = messages.toArray();
                }
            } else {
                result = super.getChildren(element);
            }
            return result;
        }

        public Object getParent(Object element) {
            Object parent = null;
            if (element instanceof Message) {
                Message message = (Message)element;
                parent = message.getResourceType();
            } else {
                parent = super.getParent(element);
            }
            return parent;
        }

        public boolean hasChildren(Object element) {
            ResourceType resourceType;
            Set<Message> messages;
            boolean result = false;
            result = element instanceof ResourceType ? (messages = (resourceType = (ResourceType)element).getMessages()) != null && messages.size() > 0 : super.hasChildren(element);
            return result;
        }

        public void addResourceType(ResourceType resourceType) {
            if (this.input == null) {
                return;
            }
            this.input.add(resourceType);
            ResourceTypeExplorer.this.getTreeViewer().add(this.input, (Object)resourceType);
        }

        public void removeResourceType(ResourceType resourceType) {
            if (this.input == null) {
                return;
            }
            if (this.input.contains(resourceType)) {
                this.input.remove(resourceType);
                ResourceTypeExplorer.this.getTreeViewer().remove((Object)resourceType);
            }
        }

        public void replaceResourceType(ResourceType resourceType) {
            if (this.input == null) {
                return;
            }
            if (this.input.contains(resourceType)) {
                this.input.remove(resourceType);
                ResourceTypeExplorer.this.getTreeViewer().remove((Object)resourceType);
            }
            this.input.add(resourceType);
            ResourceTypeExplorer.this.getTreeViewer().add(this.input, (Object)resourceType);
        }
    }

    private class ResourceTypeEditorInputChangedListener
    implements IInputChangedListener {
        private ResourceTypeEditorInputChangedListener() {
        }

        public void inputChanged(InputChangedEvent event) {
            IWatchPointEditorInput editorInput = event.getSource();
            ResourceTypeEditorInput adapter = (ResourceTypeEditorInput)editorInput.getAdapter(ResourceTypeEditorInput.class);
            if (adapter != null) {
                ResourceType resourceType = adapter.getPersistedResourceType();
                ResourceTypeExplorer.this.updateResourceTypeInTree(resourceType);
            }
        }
    }

    private class ResourceTypeLabelProvider
    extends LabelProvider {
        private ResourceTypeLabelProvider() {
        }

        public String getText(Object element) {
            String text = null;
            if (element instanceof ResourceType) {
                ResourceType resourceType = (ResourceType)element;
                text = String.valueOf(resourceType.getName()) + " [" + resourceType.getSystemId() + "]";
            } else if (element instanceof Message) {
                Message message = (Message)element;
                text = message.getName();
                if (!message.isUIDGenerationRequired()) {
                    text = String.valueOf(text) + " [" + message.getUid() + "]";
                }
            } else {
                text = super.getText(element);
            }
            return text;
        }

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof ResourceType) {
                image = this.createImage(ResourceTypeExplorer.RESOURCE_TYPE_IMAGE_PATH);
                String imagePath = ResourceTypeExplorer.RESOURCE_TYPE_IMAGE_PATH;
                if (imagePath != null) {
                    ImageDescriptor descriptor = Utility.getImageDescriptor(imagePath);
                    image = new Image((Device)Display.getCurrent(), descriptor.getImageData());
                }
            } else if (element instanceof Message) {
                Message message = (Message)element;
                String imagePath = message.isIncoming() ? ResourceTypeExplorer.INCOMING_MESSAGE_IMAGE_PATH : ResourceTypeExplorer.OUTGOING_MESSAGE_IMAGE_PATH;
                image = this.createImage(imagePath);
            } else {
                image = super.getImage(element);
            }
            return image;
        }

        private Image createImage(String path) {
            if (path == null) {
                return null;
            }
            ImageDescriptor descriptor = Utility.getImageDescriptor(path);
            return new Image((Device)Display.getCurrent(), descriptor.getImageData());
        }
    }
}

