/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view.template;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.lock.ILockable;
import com.tandbergtv.watchpoint.studio.service.IWorkflowTemplateService;
import com.tandbergtv.watchpoint.studio.service.LockFailureException;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.ui.TemplateResourcesUtility;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.NonPersistableFileEditorInput;
import com.tandbergtv.watchpoint.studio.ui.editor.WatchPointTemplateEditor;
import com.tandbergtv.watchpoint.studio.ui.util.ServiceErrors;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.AbstractTreeViewExplorer;
import com.tandbergtv.watchpoint.studio.ui.view.DefaultContentProvider;
import com.tandbergtv.watchpoint.studio.ui.view.ViewAction;
import com.tandbergtv.watchpoint.studio.ui.view.template.TemplateLabelProvider;
import com.tandbergtv.watchpoint.studio.ui.wizard.AbstractWatchPointWizard;
import com.tandbergtv.watchpoint.studio.ui.wizard.NewWatchPointTemplateWizard;
import com.tandbergtv.watchpoint.studio.usermgmt.User;
import com.tandbergtv.watchpoint.studio.usermgmt.UserManagementException;
import com.tandbergtv.watchpoint.studio.usermgmt.UserManager;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateExplorer
extends AbstractTreeViewExplorer {
    private static final Logger logger = Logger.getLogger(TemplateExplorer.class);
    private Action copyAction;
    private Action publishAction;
    private Action unPublishAction;
    private Action exportAction;
    private IWorkflowTemplateService templateService = ServiceFactory.createFactory().createWorkflowTemplateService();

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        WorkflowTemplateDTO templateSelected = (WorkflowTemplateDTO)((TreeSelection)selection).getFirstElement();
        this.updateActions(templateSelected);
    }

    @Override
    protected List<? extends IWatchPointDTO> getInput() {
        return this.templateService.getTemplateList();
    }

    @Override
    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        mgr.add((IAction)this.copyAction);
        mgr.add((IAction)this.publishAction);
        mgr.add((IAction)this.unPublishAction);
        mgr.add((IAction)this.exportAction);
    }

    private void updateActions(WorkflowTemplateDTO templateSelected) {
        boolean isSelected = templateSelected != null;
        boolean isPublished = isSelected ? templateSelected.isExportable() : false;
        this.editAction.setEnabled(isSelected && !isPublished);
        this.publishAction.setEnabled(isSelected && !isPublished);
        this.unPublishAction.setEnabled(isSelected && isPublished);
        this.exportAction.setEnabled(isSelected && isPublished);
        this.viewAction.setEnabled(isSelected);
        this.deleteAction.setEnabled(isSelected);
        this.copyAction.setEnabled(isSelected);
    }

    @Override
    protected void create() {
        if (!Utility.closeEditor("org.jbpm.gd.jpdl.editor", true)) {
            return;
        }
        this.openCreateWizard();
        this.refresh();
    }

    @Override
    protected void view() {
        ITreeSelection sel = this.getSelection();
        this.openTemplate((ISelection)sel, false);
    }

    @Override
    protected void edit() {
        ITreeSelection sel = this.getSelection();
        this.openTemplate((ISelection)sel, true);
        this.refresh();
        Utility.updateValidationErrors(this.getSite(), new ArrayList<ValidationMessage>());
    }

    @Override
    protected void delete() {
        boolean response;
        ITreeSelection sel = this.getSelection();
        WorkflowTemplateDTO templateSelected = (WorkflowTemplateDTO)((TreeSelection)sel).getFirstElement();
        if (templateSelected == null) {
            return;
        }
        String message = "Are you sure you want to delete template '" + templateSelected.getName() + "'?";
        WatchPointTemplateEditor editor = (WatchPointTemplateEditor)Utility.getEditor("org.jbpm.gd.jpdl.editor");
        if (editor != null && templateSelected.getName().equals(editor.getTemplateDTOName())) {
            message = String.valueOf(message) + " Any changes to the template will be lost.";
        }
        if (!(response = MessageDialog.openConfirm((Shell)super.getSite().getShell(), (String)"Confirm Delete", (String)message))) {
            return;
        }
        try {
            this.templateService.deleteTemplate(templateSelected.getName(), Utility.getUserName());
        }
        catch (ServiceException e) {
            Utility.handleException(ServiceErrors.getInstance().getProperty(e.getServiceErrorCode().getCode()), e);
        }
        if (editor == null || templateSelected.getName().equals(editor.getTemplateDTOName())) {
            Utility.closeEditor("org.jbpm.gd.jpdl.editor", false);
        }
        this.refresh();
    }

    @Override
    protected IContentProvider getContentProvider() {
        return new DefaultContentProvider();
    }

    @Override
    protected IBaseLabelProvider getLabelProvider() {
        return new TemplateLabelProvider();
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        IToolBarManager tbManager = this.getViewSite().getActionBars().getToolBarManager();
        tbManager.add((IAction)this.copyAction);
        tbManager.add((IAction)this.publishAction);
        tbManager.add((IAction)this.unPublishAction);
        tbManager.add((IAction)this.exportAction);
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.copyAction = new ViewAction(this, "Copy"){

            public void performAction() {
                TemplateExplorer.this.copyTemplate();
            }
        };
        this.copyAction.setImageDescriptor(Utility.getImageDescriptor("copy.png"));
        this.publishAction = new ViewAction(this, "Publish"){

            public void performAction() {
                TemplateExplorer.this.publishTemplate();
            }
        };
        this.publishAction.setImageDescriptor(Utility.getImageDescriptor("publish.png"));
        this.unPublishAction = new ViewAction(this, "UnPublish"){

            public void performAction() {
                TemplateExplorer.this.unPublishTemplate();
            }
        };
        this.unPublishAction.setImageDescriptor(Utility.getImageDescriptor("unpublish.png"));
        this.exportAction = new ViewAction(this, "Export"){

            public void performAction() {
                TemplateExplorer.this.exportTemplate();
            }
        };
        this.exportAction.setImageDescriptor(Utility.getImageDescriptor("export.png"));
        this.updateActions(null);
    }

    private void refresh(WorkflowTemplateDTO template) {
        this.updateActions(template);
        this.refresh();
    }

    private void copyTemplate() {
        ITreeSelection sel = this.getSelection();
        WorkflowTemplateDTO templateSelected = (WorkflowTemplateDTO)((TreeSelection)sel).getFirstElement();
        if (templateSelected == null) {
            return;
        }
        IEditorPart editorPart = this.getTemplateEditor(templateSelected);
        if (editorPart != null && (!this.getSite().getPage().saveEditor(editorPart, true) || editorPart.isDirty())) {
            return;
        }
        try {
            templateSelected = this.templateService.getTemplateForView(templateSelected.getName());
            IWorkbench workbench = super.getSite().getWorkbenchWindow().getWorkbench();
            NewWatchPointTemplateWizard wizard = new NewWatchPointTemplateWizard();
            wizard.init(workbench, (IStructuredSelection)new StructuredSelection(), templateSelected);
            WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            dialog.open();
        }
        catch (ServiceValidationException e) {
            Utility.updateValidationErrors(this.getSite(), e.getValidationMessages());
            throw new UIException("The template is invalid, can not save.", e);
        }
        catch (ServiceException e) {
            throw new UIException(ServiceErrors.getInstance().getProperty(e.getServiceErrorCode().getCode()), e);
        }
        this.refresh();
    }

    private void publishTemplate() {
        ITreeSelection sel = this.getSelection();
        WorkflowTemplateDTO templateSelected = (WorkflowTemplateDTO)((TreeSelection)sel).getFirstElement();
        if (templateSelected == null) {
            return;
        }
        IEditorPart editorPart = this.getTemplateEditor(templateSelected);
        if (editorPart != null && !this.getSite().getPage().saveEditor(editorPart, true)) {
            return;
        }
        try {
            String currentUser = Utility.getUserName();
            String templateName = templateSelected.getName();
            templateSelected = this.templateService.publishTemplate(templateName, currentUser);
        }
        catch (ServiceValidationException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Invalid Template", (String)"The template is invalid, can not publish.");
            Utility.updateValidationErrors(this.getSite(), e.getValidationMessages());
        }
        catch (ServiceException e) {
            Utility.handleException(ServiceErrors.getInstance().getProperty(e.getServiceErrorCode().getCode()), e);
        }
        this.refresh(templateSelected);
    }

    private void unPublishTemplate() {
        ITreeSelection sel = this.getSelection();
        WorkflowTemplateDTO templateSelected = (WorkflowTemplateDTO)((TreeSelection)sel).getFirstElement();
        try {
            templateSelected = this.templateService.unpublishTemplate(templateSelected.getName());
        }
        catch (ServiceException e) {
            Utility.handleException(ServiceErrors.getInstance().getProperty(e.getServiceErrorCode().getCode()), e);
        }
        this.refresh(templateSelected);
    }

    private void exportTemplate() {
        ITreeSelection sel = this.getSelection();
        WorkflowTemplateDTO templateSelected = (WorkflowTemplateDTO)((TreeSelection)sel).getFirstElement();
        HashMap<String, Object> params = new HashMap<String, Object>();
        String path = this.getPathFromUser();
        if (path == null) {
            return;
        }
        params.put("exportFilePath", path);
        try {
            templateSelected = this.templateService.exportTemplate(templateSelected.getName(), params);
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Template Exported", (String)"Template was exported successfully.");
            this.refresh(templateSelected);
        }
        catch (ExportFailureException e) {
            Utility.handleException("Error exporting template.", e);
            logger.error((Object)"Error exporting template.", (Throwable)e);
        }
    }

    private void openTemplate(ISelection sel, boolean edit) {
        if (!Utility.closeEditor("org.jbpm.gd.jpdl.editor", true)) {
            return;
        }
        WorkflowTemplateDTO templateSelected = (WorkflowTemplateDTO)((TreeSelection)sel).getFirstElement();
        WorkflowTemplateDTO template = null;
        try {
            if (edit) {
                try {
                    template = this.templateService.getTemplateForEdit(templateSelected.getName(), Utility.getUserName(), false);
                }
                catch (LockFailureException e) {
                    ILockable lockableEntity = e.getLockableEntity();
                    String userId = lockableEntity.getLock().getOwnerId();
                    String userDisplayMessage = this.getUserDisplayMessage(userId);
                    boolean override = MessageDialog.openConfirm((Shell)super.getSite().getShell(), (String)"Override Lock?", (String)("The template " + templateSelected.getName() + " is locked by " + userDisplayMessage + ", do you wish to override the lock?"));
                    if (!override) {
                        return;
                    }
                    template = this.templateService.getTemplateForEdit(templateSelected.getName(), Utility.getUserName(), true);
                }
            } else {
                template = this.templateService.getTemplateForView(templateSelected.getName());
            }
            IFile gpdFile = TemplateResourcesUtility.createTemplateFile(template.getXml(), template.getGpd());
            try {
                IDE.openEditor((IWorkbenchPage)super.getSite().getWorkbenchWindow().getActivePage(), (IEditorInput)new NonPersistableFileEditorInput(gpdFile, template), (String)"org.jbpm.gd.jpdl.editor");
            }
            catch (PartInitException e) {
                Utility.handleException("Error opening WatchPoint Template Editor.", e);
            }
        }
        catch (ServiceException e) {
            Utility.handleException(ServiceErrors.getInstance().getProperty(e.getServiceErrorCode().getCode()), e);
        }
    }

    private String getUserDisplayMessage(String userId) {
        String msg = null;
        try {
            User user = UserManager.getInstance().getUser(userId);
            msg = String.valueOf(user.getUserName()) + " from machine " + user.getIpAddress();
        }
        catch (UserManagementException e) {
            logger.error((Object)"Failed to get the User object.", (Throwable)e);
            msg = userId;
        }
        return msg;
    }

    private void openCreateWizard() {
        IWorkbench workbench = super.getSite().getWorkbenchWindow().getWorkbench();
        NewWatchPointTemplateWizard wizard = new NewWatchPointTemplateWizard();
        ((AbstractWatchPointWizard)wizard).init(workbench, (IStructuredSelection)new StructuredSelection());
        WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.open();
    }

    private String getPathFromUser() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 131072);
        fileDialog.setText("Please select the file to export template to.");
        fileDialog.setFilterExtensions(new String[]{"*.xml"});
        String path = fileDialog.open();
        if (path != null && !path.endsWith(".xml")) {
            path = String.valueOf(path) + ".xml";
        }
        return path;
    }

    private IEditorPart getTemplateEditor(WorkflowTemplateDTO template) {
        IEditorReference[] editorReferences;
        WatchPointTemplateEditor result = null;
        IWorkbenchPage currentPage = this.getSite().getPage();
        IEditorReference[] iEditorReferenceArray = editorReferences = currentPage.findEditors(null, "org.jbpm.gd.jpdl.editor", 2);
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            WatchPointTemplateEditor templateEditor;
            WorkflowTemplateDTO editedTemplate;
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editorPart = editorReference.getEditor(false);
            if (editorPart instanceof WatchPointTemplateEditor && (editedTemplate = (templateEditor = (WatchPointTemplateEditor)editorPart).getTemplateDTO()) != null && editedTemplate.equals(template)) {
                result = templateEditor;
                break;
            }
            ++n2;
        }
        return result;
    }
}

