/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.ui.UIException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractWatchPointWizard
extends Wizard
implements INewWizard {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String objType;

    public AbstractWatchPointWizard(String objectType) {
        this.objType = objectType;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
    }

    public boolean performFinish() {
        if (this.isNameDuplicate(this.getObjectName())) {
            this.getCurrentPage().setErrorMessage("A " + this.objType + " with this name already exists.");
            return false;
        }
        this.openViews();
        this.closeEditor();
        return this.setupEditor();
    }

    public boolean canFinish() {
        return this.getCurrentPage().getErrorMessage() == null && this.getObjectName().length() > 0;
    }

    protected void closeEditor() {
    }

    protected IWorkbenchPage getActivePage() {
        return this.getActiveWorkbenchWindow().getActivePage();
    }

    protected void openViews() {
        this.openPropertiesView();
        this.openTemplateExplorerView();
        this.openNodeDefinitionExplorerView();
    }

    protected IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    protected abstract boolean setupEditor();

    protected abstract WizardPage getCurrentPage();

    protected abstract boolean isNameDuplicate(String var1);

    protected abstract String getObjectName();

    private void openPropertiesView() {
        try {
            if (this.getActivePage().findView("org.eclipse.ui.views.PropertySheet") == null) {
                this.getActivePage().showView("org.eclipse.ui.views.PropertySheet");
            }
        }
        catch (PartInitException e) {
            throw new UIException("Error opening properties view.", e);
        }
    }

    private void openTemplateExplorerView() {
        try {
            if (this.getActivePage().findView("com.tandbergtv.gd.TemplateExplorer") == null) {
                this.getActivePage().showView("com.tandbergtv.gd.TemplateExplorer");
            }
        }
        catch (PartInitException e) {
            throw new UIException("Error opening Template Explorer view.", e);
        }
    }

    private void openNodeDefinitionExplorerView() {
        try {
            if (this.getActivePage().findView("com.tandbergtv.gd.NodeDefinitionExplorer") == null) {
                this.getActivePage().showView("com.tandbergtv.gd.NodeDefinitionExplorer");
            }
        }
        catch (PartInitException e) {
            throw new UIException("Error opening Node Definition Explorer view.", e);
        }
    }
}

