/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExportSelectDirPage
extends WizardPage {
    private static final String EMPTY_STRING = "";
    private String labelText;
    private Text dirText;
    private Button deleteCheckButton;

    public ExportSelectDirPage(String pageName) {
        super(pageName);
        this.setLabel(EMPTY_STRING);
    }

    public void setLabel(String label) {
        this.labelText = label != null ? label : EMPTY_STRING;
    }

    public String getLabel() {
        return this.labelText;
    }

    public String getSelectedDir() {
        return this.dirText.getText();
    }

    public boolean isDeleteContents() {
        return this.deleteCheckButton.isEnabled() && this.deleteCheckButton.getSelection();
    }

    public boolean isPageComplete() {
        return this.getErrorMessage() == null && this.getSelectedDir().length() > 0;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = this.createClientArea(parent);
        this.createDirSelectionControl(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private Composite createClientArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void createDirSelectionControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.labelText);
        this.dirText = new Text(parent, 2048);
        this.dirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportSelectDirPage.this.validate();
            }
        });
        Button browseButton = null;
        browseButton = new Button(parent, 8);
        browseButton.setText("Browse");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dirPath = ExportSelectDirPage.this.getDirPathFormUser();
                if (dirPath != null) {
                    ExportSelectDirPage.this.dirText.setText(dirPath);
                }
            }
        });
        this.deleteCheckButton = new Button(parent, 32);
        this.deleteCheckButton.setText("Delete contents");
        this.deleteCheckButton.setEnabled(false);
        this.deleteCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportSelectDirPage.this.validate();
            }
        });
        FormData labelFD = new FormData();
        labelFD.left = new FormAttachment(0);
        label.setLayoutData((Object)labelFD);
        FormData textFD = new FormData();
        textFD.left = new FormAttachment((Control)label, 10);
        textFD.right = new FormAttachment((Control)browseButton, -10);
        this.dirText.setLayoutData((Object)textFD);
        FormData browseButtonFD = new FormData();
        browseButtonFD.right = new FormAttachment(100, -10);
        browseButton.setLayoutData((Object)browseButtonFD);
        FormData deleteCheckButtonFD = new FormData();
        deleteCheckButtonFD.top = new FormAttachment((Control)this.dirText, 10);
        deleteCheckButtonFD.left = new FormAttachment((Control)label, 10);
        this.deleteCheckButton.setLayoutData((Object)deleteCheckButtonFD);
    }

    private void validate() {
        if (this.dirText.getText().trim().length() < this.dirText.getText().length()) {
            this.setErrorMessage("Folder entry cannot start or end with spaces");
        } else {
            File dirFile = new File(this.dirText.getText());
            if (dirFile.exists()) {
                if (dirFile.isDirectory()) {
                    String[] contents = dirFile.list();
                    if (contents == null || contents.length == 0) {
                        this.deleteCheckButton.setSelection(false);
                        this.deleteCheckButton.setEnabled(false);
                        this.setErrorMessage(null);
                    } else {
                        this.deleteCheckButton.setEnabled(true);
                        if (!this.deleteCheckButton.getSelection()) {
                            this.setErrorMessage("Selected Folder is not empty");
                        } else {
                            this.setErrorMessage(null);
                        }
                    }
                } else {
                    this.setErrorMessage("Specified entry is not a folder");
                }
            } else {
                this.setErrorMessage("Specified Folder does not exist");
            }
        }
        this.getContainer().updateButtons();
    }

    private String getDirPathFormUser() {
        DirectoryDialog dirDialog = new DirectoryDialog(Display.getCurrent().getActiveShell(), 131072);
        dirDialog.setText("Select Folder");
        return dirDialog.open();
    }
}

