/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.ui.util.UIValidator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MessageWizardPage
extends WizardPage {
    private Text nameText;
    private Text uidManualEntryText;
    private Text descriptionText;
    private Group uidGroup;
    private Group typeGroup;
    private Button uidAutoGenerateButton;
    private Button uidManualEntryButton;
    private Button typeIncomingButton;
    private Button typeOutgoingButton;
    private ModifyListener validationListener;

    public MessageWizardPage() {
        super("Message");
        this.setTitle("Create Message");
        this.setDescription("Create a new Message");
        this.validationListener = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MessageWizardPage.this.validate();
            }
        };
    }

    public String getMessageName() {
        return this.convertEmptyToNull(this.nameText.getText());
    }

    public Message getMessageObject() {
        Message message = new Message();
        message.setName(this.convertEmptyToNull(this.nameText.getText()));
        message.setUIDGenerationRequired(this.uidAutoGenerateButton.getSelection());
        message.setUid(this.convertEmptyToNull(this.uidManualEntryText.getText()));
        message.setIncoming(this.typeIncomingButton.getSelection());
        message.setProtocol(null);
        message.setDescription(this.convertEmptyToNull(this.descriptionText.getText()));
        return message;
    }

    public boolean isPageComplete() {
        return this.getErrorMessage() == null && this.nameText.getText().length() > 0;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = this.createClientArea(parent);
        this.createCustomControls(composite);
        this.setValuesAndState();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private Composite createClientArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void createCustomControls(Composite parent) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText("Name : ");
        this.nameText = new Text(parent, 2048);
        this.nameText.setTextLimit(50);
        this.nameText.addModifyListener(this.validationListener);
        Label uidLabel = new Label(parent, 0);
        uidLabel.setText("UID : ");
        this.uidGroup = new Group(parent, 0);
        this.uidAutoGenerateButton = new Button((Composite)this.uidGroup, 16);
        this.uidAutoGenerateButton.setText("Auto Generate");
        SelectionAdapter uidSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageWizardPage.this.uidManualEntryText.setEnabled(MessageWizardPage.this.uidManualEntryButton.getSelection());
                if (!MessageWizardPage.this.uidManualEntryButton.getSelection()) {
                    MessageWizardPage.this.uidManualEntryText.setText("");
                }
                MessageWizardPage.this.validate();
            }
        };
        this.uidAutoGenerateButton.addSelectionListener((SelectionListener)uidSelectionListener);
        this.uidManualEntryButton = new Button((Composite)this.uidGroup, 16);
        this.uidManualEntryButton.setText("Manual Entry");
        this.uidManualEntryButton.addSelectionListener((SelectionListener)uidSelectionListener);
        this.uidManualEntryText = new Text((Composite)this.uidGroup, 2048);
        this.uidManualEntryText.setTextLimit(10);
        this.uidManualEntryText.addModifyListener(this.validationListener);
        Label typeLabel = new Label(parent, 0);
        typeLabel.setText("Type : ");
        this.typeGroup = new Group(parent, 0);
        this.typeIncomingButton = new Button((Composite)this.typeGroup, 16);
        this.typeIncomingButton.setText("Incoming");
        SelectionAdapter typeSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageWizardPage.this.validate();
            }
        };
        this.typeIncomingButton.addSelectionListener((SelectionListener)typeSelectionListener);
        this.typeOutgoingButton = new Button((Composite)this.typeGroup, 16);
        this.typeOutgoingButton.setText("Outgoing");
        this.typeOutgoingButton.addSelectionListener((SelectionListener)typeSelectionListener);
        Label descriptionLabel = new Label(parent, 0);
        descriptionLabel.setText("Description : ");
        this.descriptionText = new Text(parent, 2818);
        this.descriptionText.setTextLimit(256);
        this.descriptionText.addModifyListener(this.validationListener);
        FormData nameTextFD = new FormData();
        nameTextFD.left = new FormAttachment(30, 2);
        nameTextFD.right = new FormAttachment(100, -10);
        this.nameText.setLayoutData((Object)nameTextFD);
        FormData uidLabelFD = new FormData();
        uidLabelFD.top = new FormAttachment((Control)this.nameText, 10);
        uidLabel.setLayoutData((Object)uidLabelFD);
        FormData uidGroupFD = new FormData();
        uidGroupFD.left = new FormAttachment(30, 2);
        uidGroupFD.right = new FormAttachment(100, -10);
        uidGroupFD.top = new FormAttachment((Control)this.nameText, 10);
        this.uidGroup.setLayoutData((Object)uidGroupFD);
        this.uidGroup.setLayout((Layout)new FormLayout());
        FormData uidManualEntryButtonFD = new FormData();
        uidManualEntryButtonFD.top = new FormAttachment((Control)this.uidAutoGenerateButton, 10);
        this.uidManualEntryButton.setLayoutData((Object)uidManualEntryButtonFD);
        FormData uidManualEntryTextFD = new FormData();
        uidManualEntryTextFD.top = new FormAttachment((Control)this.uidAutoGenerateButton, 10);
        uidManualEntryTextFD.left = new FormAttachment((Control)this.uidManualEntryButton, 10);
        uidManualEntryTextFD.right = new FormAttachment(100, -5);
        this.uidManualEntryText.setLayoutData((Object)uidManualEntryTextFD);
        FormData typeLabelFD = new FormData();
        typeLabelFD.top = new FormAttachment((Control)this.uidGroup, 10);
        typeLabel.setLayoutData((Object)typeLabelFD);
        FormData typeGroupFD = new FormData();
        typeGroupFD.left = new FormAttachment(30, 2);
        typeGroupFD.right = new FormAttachment(100, -10);
        typeGroupFD.top = new FormAttachment((Control)this.uidGroup, 10);
        this.typeGroup.setLayoutData((Object)typeGroupFD);
        this.typeGroup.setLayout((Layout)new FormLayout());
        FormData typeOutgoingButtonFD = new FormData();
        typeOutgoingButtonFD.left = new FormAttachment((Control)this.typeIncomingButton, 10);
        this.typeOutgoingButton.setLayoutData((Object)typeOutgoingButtonFD);
        FormData descriptionLabelFD = new FormData();
        descriptionLabelFD.height = 70;
        descriptionLabelFD.top = new FormAttachment((Control)this.typeGroup, 10);
        descriptionLabel.setLayoutData((Object)descriptionLabelFD);
        FormData descriptionTextFD = new FormData();
        descriptionTextFD.top = new FormAttachment((Control)this.typeGroup, 10);
        descriptionTextFD.left = new FormAttachment(30, 2);
        descriptionTextFD.right = new FormAttachment(100, -10);
        descriptionTextFD.bottom = new FormAttachment(100, -10);
        this.descriptionText.setLayoutData((Object)descriptionTextFD);
    }

    private void setValuesAndState() {
        this.uidAutoGenerateButton.setSelection(true);
        this.uidManualEntryText.setEnabled(false);
        this.typeOutgoingButton.setSelection(true);
    }

    private void validate() {
        String errorMessage = null;
        errorMessage = UIValidator.validateValue("Name", this.nameText.getText(), UIValidator.Validation.NOT_BLANK, UIValidator.Validation.TRIMMED);
        if (errorMessage != null) {
            this.updateErrorMessage(errorMessage);
            return;
        }
        if (this.uidManualEntryButton.getSelection() && (errorMessage = UIValidator.validateValue("UID", this.uidManualEntryText.getText(), UIValidator.Validation.NOT_BLANK, UIValidator.Validation.TRIMMED)) != null) {
            this.updateErrorMessage(errorMessage);
            return;
        }
        errorMessage = UIValidator.validateValue("Description", this.descriptionText.getText(), UIValidator.Validation.TRIMMED);
        if (errorMessage != null) {
            this.updateErrorMessage(errorMessage);
            return;
        }
        this.updateErrorMessage(null);
    }

    private void updateErrorMessage(String errorMessage) {
        this.setErrorMessage(errorMessage);
        this.getContainer().updateButtons();
    }

    private String convertEmptyToNull(String str) {
        return str.length() == 0 ? null : str;
    }
}

