/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.ui.TemplateResourcesUtility;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.NonPersistableFileEditorInput;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.util.ServiceErrors;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.wizard.AbstractWatchPointWizard;
import com.tandbergtv.watchpoint.studio.ui.wizard.NewNodeDefinitionWizardPage;
import com.tandbergtv.watchpoint.studio.ui.xml.NodeDefinitionDomAdapter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NewNodeDefinitionWizard
extends AbstractWatchPointWizard {
    private static final String INITIAL_GPD_XML = "initialGPD.xml";
    private static final String INITIAL_NODE_DEFINITION_XML = "initialNodeDefinition.xml";
    private static final String INITIAL_SUPERSTATE_NODE_DEFINITION_XML = "initialSuperStateNodeDefinition.xml";
    private static final String INITIAL_SINGLE_NODE_GPD_XML = "initialSingleNodeGPD.xml";
    private static final String AUTO_TASK_NODE_NAME = "//node[1]/@name";
    private NewNodeDefinitionWizardPage page;

    public NewNodeDefinitionWizard() {
        super("Node Definition");
        this.setWindowTitle("New WatchPoint Node Definition");
    }

    public void addPages() {
        this.page = new NewNodeDefinitionWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    protected boolean isNameDuplicate(String name) {
        return ServiceFactory.createFactory().createNodeDefinitionService().nameExists(name);
    }

    protected void closeEditor() {
        Utility.closeEditor("com.tandbergtv.jpdl.nodedefinitioneditor", true);
    }

    protected WizardPage getCurrentPage() {
        return this.page;
    }

    protected boolean setupEditor() {
        NodeDefinitionDTO nodeDefinitionDTO;
        if (Utility.getWindow() == null) {
            Utility.setWindow(this.getActiveWorkbenchWindow());
        }
        try {
            nodeDefinitionDTO = this.createInitialDTO();
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error initializing WatchPoint node definition editor.");
            return false;
        }
        nodeDefinitionDTO.setType(NodeDefinitionType.valueOf(this.page.getType()));
        nodeDefinitionDTO.setResourceType(this.page.getResourceType());
        this.saveNodeDefinition(nodeDefinitionDTO);
        IFile gpdFile = TemplateResourcesUtility.createNodeDefinitionFile(nodeDefinitionDTO.getXml(), nodeDefinitionDTO.getGpd());
        try {
            IDE.openEditor((IWorkbenchPage)this.getActivePage(), (IEditorInput)new NonPersistableFileEditorInput(gpdFile, nodeDefinitionDTO), (String)"com.tandbergtv.jpdl.nodedefinitioneditor");
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error initializing WatchPoint node definition editor.");
            return false;
        }
        BasicNewResourceWizard.selectAndReveal((IResource)gpdFile, (IWorkbenchWindow)this.getActiveWorkbenchWindow());
        return true;
    }

    protected String getObjectName() {
        return this.page.getNodeDefinitionName();
    }

    private String createInitialNodeDefinition(String nodeDefName, long resTypeID) {
        String xmlFileName = NodeDefinitionType.valueOf(this.page.getType()) == NodeDefinitionType.SingleNode ? INITIAL_NODE_DEFINITION_XML : INITIAL_SUPERSTATE_NODE_DEFINITION_XML;
        SemanticElementFactory elementFactory = new SemanticElementFactory("com.tandbergtv.jpdl.nodedefinitioneditor");
        NodeDefinition nodeDefinition = (NodeDefinition)elementFactory.createById("com.tandbergtv.watchpoint.studio.nodeDefinition");
        NodeDefinitionDomAdapter nodeDefinitionDomAdapter = (NodeDefinitionDomAdapter)Utility.getAdapterFromStream(xmlFileName, ((Object)((Object)this)).getClass().getResourceAsStream(xmlFileName), elementFactory);
        nodeDefinitionDomAdapter.initialize(nodeDefinition);
        nodeDefinition.setName(nodeDefName);
        nodeDefinition.setResourceType(resTypeID);
        return Utility.getXMLFromDocument(nodeDefinitionDomAdapter.getNode().getOwnerDocument());
    }

    private String createInitialGpdInfo(String nodeDefName) throws Exception {
        XPath xpath;
        XPathExpression expr;
        Node nameAttribute;
        String gpdFileName = NodeDefinitionType.valueOf(this.page.getType()) == NodeDefinitionType.SingleNode ? INITIAL_SINGLE_NODE_GPD_XML : INITIAL_GPD_XML;
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document doc = builder.parse(((Object)((Object)this)).getClass().getResourceAsStream(gpdFileName));
        if (NodeDefinitionType.valueOf(this.page.getType()) == NodeDefinitionType.SingleNode && (nameAttribute = (Node)(expr = (xpath = XPathFactory.newInstance().newXPath()).compile(AUTO_TASK_NODE_NAME)).evaluate(doc, XPathConstants.NODE)) != null) {
            nameAttribute.setNodeValue(nodeDefName);
        }
        return Utility.getXMLFromDocument(doc);
    }

    private NodeDefinitionDTO createInitialDTO() throws Exception {
        return Utility.createNodeDefinitionDTO(-1L, this.getObjectName(), this.createInitialNodeDefinition(this.getObjectName(), this.page.getResourceType().getId()), this.createInitialGpdInfo(this.getObjectName()));
    }

    private void saveNodeDefinition(NodeDefinitionDTO nodeDefinitionDTO) {
        try {
            ServiceFactory.createFactory().createNodeDefinitionService().createNodeDefinition(nodeDefinitionDTO, Utility.getUserName(), true);
        }
        catch (ServiceValidationException e) {
            Utility.updateValidationErrors(this.getActivePage().getActivePart().getSite(), e.getValidationMessages());
            throw new UIException("The node definition is invalid, can not save.", e);
        }
        catch (ServiceException e) {
            throw new UIException(ServiceErrors.getInstance().getProperty(e.getServiceErrorCode().getCode()), e);
        }
    }
}

