/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewNodeDefinitionWizardPage
extends WizardPage {
    private Text nameText;
    private Combo typeCombo;
    private Combo resourceTypeCombo;
    private ResourceType[] resourceTypeArray = null;

    protected NewNodeDefinitionWizardPage() {
        super("Node Definition");
        this.setTitle("Create Node Definition");
        this.setDescription("Create a new Node Definition");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = this.createClientArea(parent);
        this.createNameText(composite);
        this.createTypeCombo(composite);
        this.createResourceTypeCombo(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public String getNodeDefinitionName() {
        return this.nameText.getText();
    }

    public String getType() {
        return this.typeCombo.getText();
    }

    public ResourceType getResourceType() {
        return this.resourceTypeArray[this.resourceTypeCombo.getSelectionIndex()];
    }

    private Composite createClientArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void createNameText(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Name : ");
        this.nameText = new Text(parent, 2048);
        this.nameText.setTextLimit(50);
        FormData fd = new FormData();
        fd.left = new FormAttachment(30, 2);
        fd.right = new FormAttachment(90, 0);
        this.nameText.setLayoutData((Object)fd);
        this.nameText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                this.checkNodeDefinitionName();
                NewNodeDefinitionWizardPage.this.getContainer().updateButtons();
            }

            private void checkNodeDefinitionName() {
                String errorMessage = null;
                if (NewNodeDefinitionWizardPage.this.nameText.getText().equals("")) {
                    errorMessage = "Node Definition name can not be empty.";
                } else if (NewNodeDefinitionWizardPage.this.nameText.getText().startsWith(" ") || NewNodeDefinitionWizardPage.this.nameText.getText().endsWith(" ")) {
                    errorMessage = "Node Definition name is not valid. A Node Definition name must not start or end with a blank.";
                }
                if (errorMessage != null) {
                    NewNodeDefinitionWizardPage.this.setErrorMessage(errorMessage);
                } else {
                    NewNodeDefinitionWizardPage.this.setErrorMessage(null);
                }
            }
        });
    }

    private void createTypeCombo(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Type : ");
        FormData fd = new FormData();
        fd.top = new FormAttachment((Control)this.nameText, 10);
        label.setLayoutData((Object)fd);
        this.typeCombo = new Combo(composite, 780);
        fd = new FormData();
        fd.left = new FormAttachment(30, 2);
        fd.right = new FormAttachment(90, 0);
        fd.top = new FormAttachment((Control)this.nameText, 10);
        this.typeCombo.setLayoutData((Object)fd);
        this.fillTypeCombo();
    }

    private void createResourceTypeCombo(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Resource Type : ");
        FormData fd = new FormData();
        fd.top = new FormAttachment((Control)this.typeCombo, 10);
        label.setLayoutData((Object)fd);
        this.resourceTypeCombo = new Combo(composite, 780);
        fd = new FormData();
        fd.left = new FormAttachment(30, 2);
        fd.right = new FormAttachment(90, 0);
        fd.top = new FormAttachment((Control)this.typeCombo, 10);
        this.resourceTypeCombo.setLayoutData((Object)fd);
        this.fillResourceTypeCombo();
    }

    private void fillTypeCombo() {
        this.typeCombo.add(NodeDefinitionType.SingleNode.toString());
        this.typeCombo.add(NodeDefinitionType.SuperState.toString());
        this.typeCombo.select(0);
    }

    private void fillResourceTypeCombo() {
        this.resourceTypeCombo.removeAll();
        List<ResourceType> resourceTypes = ServiceFactory.createFactory().createResourceTypeService().getViewableNonOOBResourceTypeList();
        this.resourceTypeArray = new ResourceType[resourceTypes.size()];
        this.resourceTypeArray = resourceTypes.toArray(this.resourceTypeArray);
        Arrays.sort(this.resourceTypeArray, new Comparator<ResourceType>(){

            @Override
            public int compare(ResourceType r1, ResourceType r2) {
                return r1.getName().compareTo(r2.getName());
            }
        });
        ResourceType[] resourceTypeArray = this.resourceTypeArray;
        int n = this.resourceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceType resourceType = resourceTypeArray[n2];
            this.resourceTypeCombo.add(resourceType.getName());
            ++n2;
        }
        if (this.resourceTypeCombo.getItemCount() > 0) {
            this.resourceTypeCombo.select(0);
        }
    }
}

