/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.ui.TemplateResourcesUtility;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.NonPersistableFileEditorInput;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.ServiceErrors;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.wizard.AbstractWatchPointWizard;
import com.tandbergtv.watchpoint.studio.ui.wizard.NewWatchPointTemplateWizardPage;
import com.tandbergtv.watchpoint.studio.ui.xml.WorkflowTemplateDomAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jbpm.gd.common.model.SemanticElementFactory;

public class NewWatchPointTemplateWizard
extends AbstractWatchPointWizard {
    private static final String INITIAL_GPD_XML = "initialGPD.xml";
    private static final String INITIAL_TEMPLATE_XML = "initialTemplate.xml";
    private WorkflowTemplateDTO initialDTO;
    private String pageTitle;
    private String pageDescription;
    protected NewWatchPointTemplateWizardPage page;

    public NewWatchPointTemplateWizard() {
        super("Template");
        this.setWindowTitle("New WatchPoint Template");
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.initialDTO = this.createInitialTemplateDTO("");
        this.pageTitle = "Create WatchPoint Template";
        this.pageDescription = "Create a new WatchPoint template";
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection, WorkflowTemplateDTO templateToCopy) {
        super.init(workbench, currentSelection);
        this.initialDTO = Utility.createTemplateDTO(-1L, 1, "", templateToCopy.getXml(), templateToCopy.getGpd());
        this.setWindowTitle("Copy Template " + templateToCopy.getName());
        this.pageTitle = "Copy WatchPoint Template";
        this.pageDescription = "Create a new WatchPoint template from an existing template";
    }

    public void addPages() {
        this.page = new NewWatchPointTemplateWizardPage(this.pageTitle, this.pageDescription);
        this.addPage((IWizardPage)this.page);
    }

    protected boolean setupEditor() {
        try {
            if (Utility.getWindow() == null) {
                Utility.setWindow(this.getActiveWorkbenchWindow());
            }
            String xml = this.setNameForProcessDefinition(this.getObjectName(), this.initialDTO.getXml());
            this.initialDTO.setXml(xml);
            this.initialDTO.setName(this.getObjectName());
            this.saveTemplate();
            IFile gpdFile = TemplateResourcesUtility.createTemplateFile(this.initialDTO.getXml(), this.initialDTO.getGpd());
            IDE.openEditor((IWorkbenchPage)this.getActivePage(), (IEditorInput)new NonPersistableFileEditorInput(gpdFile, this.initialDTO), (String)"org.jbpm.gd.jpdl.editor");
            BasicNewResourceWizard.selectAndReveal((IResource)gpdFile, (IWorkbenchWindow)this.getActiveWorkbenchWindow());
        }
        catch (UIException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)e.getMessage());
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error initializing WatchPoint editor.");
        }
        return true;
    }

    protected boolean isNameDuplicate(String name) {
        return ServiceFactory.createFactory().createWorkflowTemplateService().nameExists(name);
    }

    protected String getObjectName() {
        return this.page.getProcessName();
    }

    protected WizardPage getCurrentPage() {
        return this.page;
    }

    protected void closeEditor() {
        Utility.closeEditor("org.jbpm.gd.jpdl.editor", true);
    }

    private String createInitialProcessDefinition(String name) {
        SemanticElementFactory elementFactory = new SemanticElementFactory("org.jbpm.gd.jpdl.editor");
        WorkflowTemplate template = (WorkflowTemplate)elementFactory.createById("org.jbpm.gd.jpdl.processDefinition");
        WorkflowTemplateDomAdapter workflowTemplateDomAdapter = (WorkflowTemplateDomAdapter)Utility.getAdapterFromStream(INITIAL_TEMPLATE_XML, ((Object)((Object)this)).getClass().getResourceAsStream(INITIAL_TEMPLATE_XML), elementFactory);
        workflowTemplateDomAdapter.initialize(template);
        template.setName(name);
        return Utility.getXMLFromDocument(workflowTemplateDomAdapter.getNode().getOwnerDocument());
    }

    private String setNameForProcessDefinition(String name, String processDefinitionXml) {
        SemanticElementFactory elementFactory = new SemanticElementFactory("org.jbpm.gd.jpdl.editor");
        WorkflowTemplate template = (WorkflowTemplate)elementFactory.createById("org.jbpm.gd.jpdl.processDefinition");
        WorkflowTemplateDomAdapter workflowTemplateDomAdapter = (WorkflowTemplateDomAdapter)Utility.getAdapterFromString(processDefinitionXml, elementFactory);
        workflowTemplateDomAdapter.initialize(template);
        template.setName(name);
        return Utility.getXMLFromDocument(workflowTemplateDomAdapter.getNode().getOwnerDocument());
    }

    private String createInitialGpdInfo() {
        StringBuffer initialGPD = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(INITIAL_GPD_XML)));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                initialGPD.append(String.valueOf(line) + LINE_SEPARATOR);
            }
        }
        catch (IOException e) {
            throw new UIException("Could not read from initialGPD.xml to get the initial gpd xml.", e);
        }
        return initialGPD.toString();
    }

    private WorkflowTemplateDTO createInitialTemplateDTO(String name) {
        return Utility.createTemplateDTO(-1L, 1, name, this.createInitialProcessDefinition(name), this.createInitialGpdInfo());
    }

    private void saveTemplate() {
        try {
            this.initialDTO = ServiceFactory.createFactory().createWorkflowTemplateService().createTemplate(this.initialDTO, Utility.getUserName(), true);
        }
        catch (ServiceValidationException e) {
            Utility.updateValidationErrors(this.getActivePage().getActivePart().getSite(), e.getValidationMessages());
            throw new UIException("The template is invalid, can not save.", e);
        }
        catch (ServiceException e) {
            throw new UIException(ServiceErrors.getInstance().getProperty(e.getServiceErrorCode().getCode()), e);
        }
    }
}

