/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewWatchPointTemplateWizardPage
extends WizardPage {
    private Text processText;

    public NewWatchPointTemplateWizardPage(String title, String description) {
        super("WatchPoint Template");
        this.setTitle(title);
        this.setDescription(description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = this.createClientArea(parent);
        this.createLabel(composite);
        this.createProcessField(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public String getProcessName() {
        return this.processText.getText();
    }

    private Composite createClientArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void createLabel(Composite composite) {
        Label label = new Label(composite, 64);
        label.setText("Choose a template name.");
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
    }

    private void createProcessField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Process name : ");
        this.processText = new Text(parent, 2048);
        this.processText.setTextLimit(50);
        this.processText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                this.checkNodeDefinitionName();
                NewWatchPointTemplateWizardPage.this.getContainer().updateButtons();
            }

            private void checkNodeDefinitionName() {
                String errorMessage = null;
                if (NewWatchPointTemplateWizardPage.this.processText.getText().equals("")) {
                    errorMessage = "Template name can not be empty.";
                } else if (NewWatchPointTemplateWizardPage.this.processText.getText().startsWith(" ") || NewWatchPointTemplateWizardPage.this.processText.getText().endsWith(" ")) {
                    errorMessage = "Template name is not valid. The Template name must not start or end with a blank.";
                }
                if (errorMessage != null) {
                    NewWatchPointTemplateWizardPage.this.setErrorMessage(errorMessage);
                } else {
                    NewWatchPointTemplateWizardPage.this.setErrorMessage(null);
                }
            }
        });
        GridData gd = new GridData(768);
        this.processText.setLayoutData((Object)gd);
    }
}

