/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.service.IResourceGroupService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.wizard.ResourceGroupWizardPage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ResourceGroupWizard
extends Wizard
implements INewWizard {
    private static final int MAX_IMAGE_FILE_SIZE = 51200;
    private static final int READ_SIZE = 1024;
    private ResourceGroupWizardPage page;
    private IResourceGroupService rgService;
    private ResourceGroupWizardPage.Mode mode;
    private ResourceGroup group;

    public ResourceGroupWizard() {
        this(ResourceGroupWizardPage.Mode.CREATE, null);
    }

    public ResourceGroupWizard(ResourceGroupWizardPage.Mode mode, ResourceGroup group) {
        this.mode = mode;
        this.group = group;
        this.setWindowTitle(mode.getTitle());
        this.rgService = ServiceFactory.createFactory().createResourceGroupService();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.page = new ResourceGroupWizardPage(this.mode, this.group);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        switch (this.mode) {
            case CREATE: {
                try {
                    if (this.rgService.isNameExists(this.page.getResourceGroupName())) {
                        this.page.setErrorMessage("A Resource Group with this name already exists");
                        return false;
                    }
                }
                catch (Exception e) {
                    Utility.reportError("Error while checking if Name is unique", e);
                    return false;
                }
                return this.createResourceGroup();
            }
            case EDIT: {
                return this.editResourceGroup();
            }
        }
        return true;
    }

    private boolean createResourceGroup() {
        ResourceGroup newGroup = new ResourceGroup();
        try {
            this.fillEntityFromPage(newGroup, this.page);
            this.rgService.createResourceGroup(newGroup);
        }
        catch (Exception e) {
            Utility.reportError("Resource Group Creation Failed.", e);
            return false;
        }
        return true;
    }

    private boolean editResourceGroup() {
        try {
            this.fillEntityFromPage(this.group, this.page);
            this.rgService.updateResourceGroup(this.group);
        }
        catch (Exception e) {
            Utility.reportError("Resource Group Edit Failed.", e);
            return false;
        }
        return true;
    }

    private void fillEntityFromPage(ResourceGroup group, ResourceGroupWizardPage rgPage) {
        group.setName(rgPage.getResourceGroupName());
        group.setResourceType(rgPage.getResourceType());
        group.setFunctionalType(this.convertBlankToNull(rgPage.getFunctionalType()));
        group.setInternallyAcquired(rgPage.isAllocationStyleInternal());
        group.setAllocationStrategyClassName(this.convertBlankToNull(rgPage.getAllocationStrategy()));
        if (this.mode != ResourceGroupWizardPage.Mode.CREATE && rgPage.isClearCurrentImage()) {
            group.setImageContent(null);
            group.setImageFileName(null);
        }
        if (rgPage.getImageFile() != null && rgPage.getImageFile().length() > 0) {
            group.setImageContent(this.readFile(rgPage.getImageFile()));
            group.setImageFileName(new File(rgPage.getImageFile()).getName());
        }
        group.setProtectionKey(rgPage.getProtectionKey());
    }

    private String convertBlankToNull(String str) {
        if (str != null && str.trim().length() > 0) {
            return str;
        }
        return null;
    }

    private byte[] readFile(String filePath) {
        File file = new File(filePath);
        int fileLengthInt = (int)file.length();
        if (fileLengthInt > 51200) {
            throw new UIException("File Too Big | Image File Max Size (bytes): 51200");
        }
        int arraySize = fileLengthInt;
        byte[] fileContents = new byte[arraySize];
        BufferedInputStream bis = null;
        try {
            int remainingArraySize;
            int numBytesToRead;
            int bytesRead;
            bis = new BufferedInputStream(new FileInputStream(file));
            int offset = 0;
            while ((bytesRead = bis.read(fileContents, offset, numBytesToRead = 1024 > (remainingArraySize = arraySize - offset) ? remainingArraySize : 1024)) != -1 && (offset += bytesRead) != arraySize) {
            }
            byte[] byArray = fileContents;
            return byArray;
        }
        catch (Exception ioe) {
            String message = "Exception while reading the image file: " + filePath;
            throw new UIException(message, ioe);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ioe) {
                    String message = "Exception while closing the image file: " + filePath;
                    throw new UIException(message, ioe);
                }
            }
        }
    }
}

