/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.ProtectionKey;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceGroupService;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.util.UIValidator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ResourceGroupWizardPage
extends WizardPage {
    private Text nameText;
    private Text allocationStrategyText;
    private Text currentImageText;
    private Text imageText;
    private Combo resourceTypeCombo;
    private Combo functionalTypeCombo;
    private Combo protectionKeyCombo;
    private Group allocationStyleGroup;
    private Button internalRadio;
    private Button externalRadio;
    private Button clearCurrentImageCheck;
    private Button imageFileBrowseButton;
    private Map<String, ProtectionKey> protectionKeyNameObjectMap = new HashMap<String, ProtectionKey>();
    private Map<String, ResourceType> resourceTypeNameObjectMap = new HashMap<String, ResourceType>();
    private ModifyListener validationListener;
    private IResourceGroupService rgService;
    private IResourceTypeService rtService;
    private Mode mode;
    private ResourceGroup group;

    public ResourceGroupWizardPage(Mode mode, ResourceGroup group) {
        super("Resource Group");
        this.mode = mode;
        this.setTitle(mode.getTitle());
        this.setDescription(mode.getDescription());
        this.rgService = ServiceFactory.createFactory().createResourceGroupService();
        this.rtService = ServiceFactory.createFactory().createResourceTypeService();
        if (mode != Mode.CREATE) {
            this.group = this.rgService.getResourceGroup(group.getKey());
        }
        this.validationListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceGroupWizardPage.this.validate();
            }
        };
    }

    public boolean isPageComplete() {
        return this.getErrorMessage() == null && this.nameText.getText().length() > 0;
    }

    public String getResourceGroupName() {
        return this.nameText.getText();
    }

    public ResourceType getResourceType() {
        return this.resourceTypeNameObjectMap.get(this.resourceTypeCombo.getText());
    }

    public String getFunctionalType() {
        return this.functionalTypeCombo.getText();
    }

    public boolean isAllocationStyleInternal() {
        return this.internalRadio.getSelection();
    }

    public String getAllocationStrategy() {
        return this.allocationStrategyText.getText();
    }

    public boolean isClearCurrentImage() {
        return this.mode != Mode.CREATE ? this.clearCurrentImageCheck.getSelection() : false;
    }

    public String getImageFile() {
        return this.imageText.getText();
    }

    public ProtectionKey getProtectionKey() {
        String protectionKeyName = this.protectionKeyCombo.getText();
        return this.protectionKeyNameObjectMap.containsKey(protectionKeyName) ? this.protectionKeyNameObjectMap.get(protectionKeyName) : new ProtectionKey(protectionKeyName);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = this.createClientArea(parent);
        this.createNameControl(composite, null);
        this.createrResourceTypeControl(composite, (Control)this.nameText);
        this.createFunctionalTypeControl(composite, (Control)this.resourceTypeCombo);
        this.createAllocationStyleControl(composite, (Control)this.functionalTypeCombo);
        this.createAllocationStrategyControl(composite, (Control)this.allocationStyleGroup);
        if (this.mode == Mode.CREATE) {
            this.createImageControl(composite, (Control)this.allocationStrategyText);
        } else {
            this.createCurrentImageControl(composite, (Control)this.allocationStrategyText);
            this.createImageControl(composite, (Control)this.currentImageText);
        }
        this.createProtectionKeyCombo(composite, (Control)this.imageText);
        this.setValuesAndState();
        this.disableControls();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private void disableControls() {
        switch (this.mode) {
            case CREATE: {
                break;
            }
            case EDIT: {
                this.disable(new Control[]{this.nameText, this.resourceTypeCombo});
                break;
            }
            case VIEW: {
                this.disable(new Control[]{this.nameText, this.resourceTypeCombo, this.functionalTypeCombo, this.allocationStyleGroup, this.allocationStrategyText, this.clearCurrentImageCheck, this.imageText, this.imageFileBrowseButton, this.protectionKeyCombo});
            }
        }
    }

    private void disable(Control ... controls) {
        if (controls != null) {
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setEnabled(false);
                ++n2;
            }
        }
    }

    private void setValuesAndState() {
        if (this.mode != Mode.CREATE) {
            this.nameText.setText(this.convertNullToEmpty(this.group.getName()));
            if (this.group.getResourceType() != null) {
                this.resourceTypeCombo.setText(this.convertNullToEmpty(this.group.getResourceType().getName()));
            }
            this.functionalTypeCombo.setText(this.convertNullToEmpty(this.group.getFunctionalType()));
            this.internalRadio.setSelection(this.group.isInternallyAcquired());
            this.externalRadio.setSelection(!this.group.isInternallyAcquired());
            this.allocationStrategyText.setText(this.convertNullToEmpty(this.group.getAllocationStrategyClassName()));
            this.allocationStrategyText.setEnabled(this.group.isInternallyAcquired());
            this.currentImageText.setText(this.convertNullToEmpty(this.group.getImageFileName()));
            if (this.group.getImageContent() == null || this.group.getImageContent().length == 0) {
                this.clearCurrentImageCheck.setEnabled(false);
            }
            if (this.group.getProtectionKey() != null) {
                this.protectionKeyCombo.setText(this.convertNullToEmpty(this.group.getProtectionKey().getName()));
            }
        }
    }

    private String convertNullToEmpty(String str) {
        return str == null ? "" : str;
    }

    private Composite createClientArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void createNameControl(Composite parent, Control prevControl) {
        this.createLabel("Name : ", parent, prevControl);
        this.nameText = this.createText(parent, prevControl);
        this.nameText.setTextLimit(50);
        this.nameText.addModifyListener(this.validationListener);
    }

    private void createrResourceTypeControl(Composite composite, Control prevControl) {
        this.createLabel("Resource Type : ", composite, prevControl);
        this.resourceTypeCombo = this.createCombo(composite, prevControl, true);
        this.fillResourceTypeCombo();
        this.resourceTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String functionalTypeComboText = ResourceGroupWizardPage.this.functionalTypeCombo.getText();
                ResourceGroupWizardPage.this.populateFunctionalTypeCombo();
                ResourceGroupWizardPage.this.functionalTypeCombo.setText(functionalTypeComboText);
            }
        });
    }

    private void fillResourceTypeCombo() {
        List<ResourceType> resourceTypes = this.rtService.getResourceTypeList();
        if (resourceTypes != null) {
            Collections.sort(resourceTypes, new Comparator<ResourceType>(){

                @Override
                public int compare(ResourceType o1, ResourceType o2) {
                    return ResourceGroupWizardPage.this.compareIgnoreCase(o1.getName(), o2.getName());
                }
            });
            for (ResourceType resourceType : resourceTypes) {
                this.resourceTypeCombo.add(resourceType.getName());
                this.resourceTypeNameObjectMap.put(resourceType.getName(), resourceType);
            }
            this.resourceTypeCombo.select(0);
        }
    }

    private void createFunctionalTypeControl(Composite parent, Control prevControl) {
        this.createLabel("Functional Type : ", parent, prevControl);
        this.functionalTypeCombo = this.createCombo(parent, prevControl, false);
        this.functionalTypeCombo.setTextLimit(256);
        this.populateFunctionalTypeCombo();
        this.functionalTypeCombo.addModifyListener(this.validationListener);
    }

    private void populateFunctionalTypeCombo() {
        ResourceType resourceType = this.getResourceType();
        if (resourceType == null) {
            return;
        }
        List<String> functionalTypes = this.rgService.getAllFunctionalTypesForResourceType(resourceType.getId());
        if (functionalTypes != null) {
            Collections.sort(functionalTypes, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return ResourceGroupWizardPage.this.compareIgnoreCase(o1, o2);
                }
            });
            this.functionalTypeCombo.setItems(functionalTypes.toArray(new String[0]));
        }
    }

    private void createAllocationStyleControl(Composite parent, Control prevControl) {
        this.createLabel("Allocation Style : ", parent, prevControl);
        this.allocationStyleGroup = this.createGroup(parent, prevControl);
        this.internalRadio = new Button((Composite)this.allocationStyleGroup, 16);
        this.internalRadio.setBounds(10, 15, 70, 15);
        this.internalRadio.setText("Internal");
        this.internalRadio.setSelection(true);
        SelectionAdapter sl = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ResourceGroupWizardPage.this.allocationStrategyText.setEnabled(ResourceGroupWizardPage.this.internalRadio.getSelection());
                if (ResourceGroupWizardPage.this.externalRadio.getSelection()) {
                    ResourceGroupWizardPage.this.allocationStrategyText.setText("");
                }
                ResourceGroupWizardPage.this.validate();
            }
        };
        this.internalRadio.addSelectionListener((SelectionListener)sl);
        this.externalRadio = new Button((Composite)this.allocationStyleGroup, 16);
        this.externalRadio.setText("External");
        this.externalRadio.setBounds(120, 15, 70, 15);
        this.externalRadio.addSelectionListener((SelectionListener)sl);
    }

    private void createAllocationStrategyControl(Composite parent, Control prevControl) {
        this.createLabel("Allocation Strategy: ", parent, prevControl);
        this.allocationStrategyText = this.createText(parent, prevControl);
        this.allocationStrategyText.setTextLimit(256);
        this.allocationStrategyText.addModifyListener(this.validationListener);
    }

    private void createCurrentImageControl(Composite parent, Control prevControl) {
        this.createLabel("Current Image: ", parent, prevControl);
        this.clearCurrentImageCheck = new Button(parent, 32);
        this.clearCurrentImageCheck.setText("Clear");
        FormData clearCurrentImageCheckFD = new FormData();
        clearCurrentImageCheckFD.right = new FormAttachment(100, -10);
        if (prevControl != null) {
            clearCurrentImageCheckFD.top = new FormAttachment(prevControl, 10);
        }
        this.clearCurrentImageCheck.setLayoutData((Object)clearCurrentImageCheckFD);
        this.currentImageText = new Text(parent, 2048);
        this.currentImageText.setEnabled(false);
        FormData currentImageTextFD = new FormData();
        currentImageTextFD.left = new FormAttachment(30, 2);
        currentImageTextFD.right = new FormAttachment((Control)this.clearCurrentImageCheck, -10);
        if (prevControl != null) {
            currentImageTextFD.top = new FormAttachment(prevControl, 10);
        }
        this.currentImageText.setLayoutData((Object)currentImageTextFD);
    }

    private void createImageControl(Composite parent, Control prevControl) {
        this.createLabel("Image : ", parent, prevControl);
        this.imageFileBrowseButton = new Button(parent, 8);
        this.imageFileBrowseButton.setText("Browse");
        FormData fd = new FormData();
        fd.right = new FormAttachment(100, -10);
        if (prevControl != null) {
            fd.top = new FormAttachment(prevControl, 10);
        }
        this.imageFileBrowseButton.setLayoutData((Object)fd);
        this.imageFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String path = ResourceGroupWizardPage.this.getPathFromUser();
                if (path != null) {
                    ResourceGroupWizardPage.this.imageText.setText(path);
                }
            }
        });
        this.imageText = new Text(parent, 2048);
        this.imageText.addModifyListener(this.validationListener);
        fd = new FormData();
        fd.left = new FormAttachment(30, 2);
        fd.right = new FormAttachment((Control)this.imageFileBrowseButton, -5);
        if (prevControl != null) {
            fd.top = new FormAttachment(prevControl, 10);
        }
        this.imageText.setLayoutData((Object)fd);
    }

    private String getPathFromUser() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 131072);
        fileDialog.setText("Please select the image file.");
        return fileDialog.open();
    }

    private void createProtectionKeyCombo(Composite parent, Control prevControl) {
        this.createLabel("Protection Key : ", parent, prevControl);
        this.protectionKeyCombo = this.createCombo(parent, prevControl, false);
        this.protectionKeyCombo.setTextLimit(50);
        this.protectionKeyCombo.addModifyListener(this.validationListener);
        this.protectionKeyCombo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ResourceGroupWizardPage.this.protectionKeyCombo.setText(ResourceGroupWizardPage.this.protectionKeyCombo.getText().toUpperCase());
            }
        });
        this.fillProtectionKeyCombo();
    }

    private void fillProtectionKeyCombo() {
        List<ProtectionKey> protectionKeys = this.rgService.getAllProtectionKeys();
        if (protectionKeys != null) {
            Collections.sort(protectionKeys, new Comparator<ProtectionKey>(){

                @Override
                public int compare(ProtectionKey o1, ProtectionKey o2) {
                    return ResourceGroupWizardPage.this.compareIgnoreCase(o1.getName(), o2.getName());
                }
            });
        }
        for (ProtectionKey protectionKey : protectionKeys) {
            this.protectionKeyCombo.add(protectionKey.getName());
            this.protectionKeyNameObjectMap.put(protectionKey.getName(), protectionKey);
        }
    }

    private void validate() {
        String errorMessage = null;
        errorMessage = UIValidator.validateValue("Name", this.nameText.getText(), UIValidator.Validation.NOT_BLANK, UIValidator.Validation.TRIMMED);
        if (errorMessage != null) {
            this.updateErrorMessage(errorMessage);
            return;
        }
        errorMessage = UIValidator.validateValue("Functional Type", this.functionalTypeCombo.getText(), UIValidator.Validation.TRIMMED);
        if (errorMessage != null) {
            this.updateErrorMessage(errorMessage);
            return;
        }
        if (this.internalRadio.getSelection() && (errorMessage = UIValidator.validateValue("Allocation Strategy", this.allocationStrategyText.getText(), UIValidator.Validation.TRIMMED)) != null) {
            this.updateErrorMessage(errorMessage);
            return;
        }
        errorMessage = UIValidator.validateValue("Image", this.imageText.getText(), UIValidator.Validation.TRIMMED);
        if (errorMessage != null) {
            this.updateErrorMessage(errorMessage);
            return;
        }
        errorMessage = UIValidator.validateValue("Protection Key", this.protectionKeyCombo.getText(), UIValidator.Validation.NOT_BLANK, UIValidator.Validation.TRIMMED);
        if (errorMessage != null) {
            this.updateErrorMessage(errorMessage);
            return;
        }
        this.updateErrorMessage(null);
    }

    private void updateErrorMessage(String errorMessage) {
        this.setErrorMessage(errorMessage);
        this.getContainer().updateButtons();
    }

    private Label createLabel(String text, Composite parent, Control prevControl) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setLayoutData((Object)this.getLSFormData(prevControl));
        return label;
    }

    private Text createText(Composite parent, Control prevControl) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)this.getRSFormData(prevControl));
        return text;
    }

    private Combo createCombo(Composite parent, Control prevControl, boolean readOnly) {
        int style = 772;
        if (readOnly) {
            style |= 8;
        }
        Combo combo = new Combo(parent, style);
        combo.setLayoutData((Object)this.getRSFormData(prevControl));
        return combo;
    }

    private Group createGroup(Composite parent, Control prevControl) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)this.getRSFormData(prevControl));
        return group;
    }

    private FormData getLSFormData(Control control) {
        FormData fd = new FormData();
        if (control != null) {
            fd.top = new FormAttachment(control, 10);
        }
        return fd;
    }

    private FormData getRSFormData(Control control) {
        FormData fd = new FormData();
        fd.left = new FormAttachment(30, 2);
        fd.right = new FormAttachment(100, -10);
        if (control != null) {
            fd.top = new FormAttachment(control, 10);
        }
        return fd;
    }

    private int compareIgnoreCase(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return 0;
        }
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.compareToIgnoreCase(str2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        CREATE("Create Resource Group", "Create a new Resource Group"),
        VIEW("View Resource Group", null),
        EDIT("Edit Resource Group", null);

        private String title;
        private String description;

        private Mode(String title, String description) {
            this.title = title;
            this.description = description;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

